/*
 * $Id: main.cpp 111 2009-02-27 18:37:40Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Meta_Predictor/SelfTest/include/test.h"
#include "Behavioural/include/Selftest.h"

#define NB_PARAMS 3+7*3

void usage (int argc, char * argv[])
{
  err (_("<Usage> %s name_instance list_params.\n"),argv[0]);
  err (_("list_params is :\n"));
  err (_(" * nb_inst_predict            (uint32_t)\n"));
  err (_(" * nb_inst_update             (uint32_t)\n"));
  err (_(" * size_address               (uint32_t)\n"));
  err (_(" * have_bht               [3] (bool    )\n"));
  err (_(" * bht_size_shifter       [3] (uint32_t)\n"));
  err (_(" * bht_nb_shifter         [3] (uint32_t)\n"));
  err (_(" * have_pht               [3] (bool    )\n"));
  err (_(" * pht_size_counter       [3] (uint32_t)\n"));
  err (_(" * pht_nb_counter         [3] (uint32_t)\n"));
  err (_(" * pht_size_address_share [3] (uint32_t)\n"));
  exit (1);
}

#ifndef SYSTEMC
int main    (int argc, char * argv[])
#else
int sc_main (int argc, char * argv[])
#endif
{
  if (argc != static_cast<int>(2+NB_PARAMS))
    usage (argc, argv);

  uint32_t x = 1;

  string name = argv[x++];
  uint32_t _nb_inst_predict           ;
  uint32_t _nb_inst_update            ;
  uint32_t _size_address              ;
  bool     _have_bht               [3];
  uint32_t _bht_size_shifter       [3];
  uint32_t _bht_nb_shifter         [3];
  bool     _have_pht               [3];
  uint32_t _pht_size_counter       [3];
  uint32_t _pht_nb_counter         [3];
  uint32_t _pht_size_address_share [3];

  SELFTEST0(_nb_inst_predict           ,uint32_t,argv,x);
  SELFTEST0(_nb_inst_update            ,uint32_t,argv,x);
  SELFTEST0(_size_address              ,uint32_t,argv,x);

  for (uint32_t i=0; i<3; ++i)
    {
  SELFTEST0(_have_bht               [i],bool    ,argv,x);
  SELFTEST0(_bht_size_shifter       [i],uint32_t,argv,x);
  SELFTEST0(_bht_nb_shifter         [i],uint32_t,argv,x);
  SELFTEST0(_have_pht               [i],bool    ,argv,x);
  SELFTEST0(_pht_size_counter       [i],uint32_t,argv,x);
  SELFTEST0(_pht_nb_counter         [i],uint32_t,argv,x);
  SELFTEST0(_pht_size_address_share [i],uint32_t,argv,x);
    }

  int _return = EXIT_SUCCESS;
  try 
    {
      morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::direction::meta_predictor::Parameters * param = new morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::direction::meta_predictor::Parameters
	(
         _nb_inst_predict       ,
         _nb_inst_update        ,
         _size_address          ,
         _have_bht              ,
         _bht_size_shifter      ,
         _bht_nb_shifter        ,
         _have_pht              ,
         _pht_size_counter      ,
         _pht_nb_counter        ,
         _pht_size_address_share,
         true // is_toplevel
        );
      
      msg(_("%s"),param->print(0).c_str());
      
      test (name,param);
    }
  catch (morpheo::ErrorMorpheo & error)
    {
      msg (_("<%s> :\n%s"),name.c_str(), error.what ());
      _return = EXIT_FAILURE;
    }

  try 
    {
      if (_return == EXIT_SUCCESS)
	TEST_OK("Meta_Predictor : no error");
      else
	TEST_KO("Meta_Predictor : a lot of error");
    }
  catch (morpheo::ErrorMorpheo & error)
    {
//       msg (_("<%s> :\n%s"),name.c_str(), error.what ());
      _return = EXIT_FAILURE;
    }

  return (_return);
}
