#ifdef STATISTICS
/*
 * $Id: Free_List_unit_statistics_allocation.cpp 110 2009-02-19 16:31:47Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Register_translation_unit/Free_List_unit/include/Free_List_unit.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace register_translation_unit {
namespace free_list_unit {


#undef  FUNCTION
#define FUNCTION "Free_List_unit::statistics_allocation"
  void Free_List_unit::statistics_allocation (morpheo::behavioural::Parameters_Statistics * param_statistics)
  {
    log_printf(FUNC,Free_List_unit,FUNCTION,"Begin");

    _stat = new Stat (static_cast<std::string>(_name),
		      "Free_List_unit",
		      param_statistics);

    std::string sum_bank_gpr_nb_elt = "0";
    _stat_bank_gpr_nb_elt = new counter_t * [_param->_nb_bank];
    
    for (uint32_t i=0; i<_param->_nb_bank; ++i)
      {
        std::string str = "bank_gpr_nb_elt_"+toString(i);
        
        sum_bank_gpr_nb_elt = "+ "+str+" "+sum_bank_gpr_nb_elt;
        
        _stat_bank_gpr_nb_elt [i]  = _stat->create_variable(str);
        
        _stat->create_expr_average_by_cycle("average_occupation_bank_gpr_"+toString(i), str, "", toString(_("Average free list occupation (bank %d)"),i));
        _stat->create_expr_percent         ("percent_occupation_bank_gpr_"+toString(i) , "average_occupation_bank_gpr_"+toString(i), toString(_param->_bank_gpr_nb_slot), toString(_("Percent free list occupation (bank %d)"),i));
      }

    _stat->create_expr_average_by_cycle("average_occupation_bank_gpr", sum_bank_gpr_nb_elt, "", _("Average free list occupation (bank all)"));
    _stat->create_expr_percent         ("percent_occupation_bank_gpr", "average_occupation_bank_gpr", toString(_param->_bank_gpr_nb_slot*_param->_nb_bank), _("Percent free list occupation (bank all)"));
    
    std::string sum_bank_spr_nb_elt = "0";
    _stat_bank_spr_nb_elt = new counter_t * [_param->_nb_bank];

    for (uint32_t i=0; i<_param->_nb_bank; ++i)
      {
        std::string str = "bank_spr_nb_elt_"+toString(i);
        
        sum_bank_spr_nb_elt = "+ "+str+" "+sum_bank_spr_nb_elt;
        
        _stat_bank_spr_nb_elt [i]  = _stat->create_variable(str);
        
        _stat->create_expr_average_by_cycle("average_occupation_bank_spr_"+toString(i), str, "", toString(_("Average free list occupation (bank %d)"),i));
        _stat->create_expr_percent         ("percent_occupation_bank_spr_"+toString(i) , "average_occupation_bank_spr_"+toString(i), toString(_param->_bank_spr_nb_slot), toString(_("Percent free list occupation (bank %d)"),i));
      }

    _stat->create_expr_average_by_cycle("average_occupation_bank_spr", sum_bank_spr_nb_elt, "", _("Average free list occupation (bank all)"));
    _stat->create_expr_percent         ("percent_occupation_bank_spr", "average_occupation_bank_spr", toString(_param->_bank_spr_nb_slot*_param->_nb_bank), _("Percent free list occupation (bank all)"));

    _stat_nb_inst_pop      = _stat->create_variable("nb_inst_pop"     );
    _stat_nb_inst_pop_gpr  = _stat->create_variable("nb_inst_pop_gpr" );
    _stat_nb_inst_pop_spr  = _stat->create_variable("nb_inst_pop_spr" );
    _stat_nb_inst_push_gpr = _stat->create_variable("nb_inst_push_gpr");
    _stat_nb_inst_push_spr = _stat->create_variable("nb_inst_push_spr");
    
    _stat->create_expr_average_by_cycle("average_use_interface_pop"     , "nb_inst_pop"     , "", _("Average instruction per cycle on pop interface"));
    _stat->create_expr_average_by_cycle("average_use_interface_pop_gpr" , "nb_inst_pop_gpr" , "", _("Average instruction per cycle on pop interface for gpr"));
    _stat->create_expr_average_by_cycle("average_use_interface_pop_spr" , "nb_inst_pop_spr" , "", _("Average instruction per cycle on pop interface for spr"));
    _stat->create_expr_average_by_cycle("average_use_interface_push_gpr", "nb_inst_push_gpr", "", _("Average instruction per cycle on push_gpr interface"));
    _stat->create_expr_average_by_cycle("average_use_interface_push_spr", "nb_inst_push_spr", "", _("Average instruction per cycle on push_spr interface"));

    _stat->create_expr_percent         ("percent_inst_pop_need_gpr"     , "nb_inst_pop_gpr" , "nb_inst_pop", _("Percent of pop instruction that need gpr"));
    _stat->create_expr_percent         ("percent_inst_pop_need_spr"     , "nb_inst_pop_spr" , "nb_inst_pop", _("Percent of pop instruction that need spr"));

    log_printf(FUNC,Free_List_unit,FUNCTION,"End");
  };

}; // end namespace free_list_unit
}; // end namespace register_translation_unit
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
