#ifdef VHDL
/*
 * $Id: Read_queue_vhdl_body.cpp 98 2008-12-31 10:18:08Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Read_unit/Read_unit/Read_queue/include/Read_queue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_read_unit {
namespace read_unit {
namespace read_queue {


  void Read_queue::vhdl_body (Vhdl * & vhdl)
  {
    log_printf(FUNC,Read_queue,"vhdl_body","Begin");
    vhdl->set_body(0,"");
    vhdl->set_body(0,"");
    vhdl->set_body(0,"-----------------------------------");
    vhdl->set_body(0,"-- Instance queue                  ");
    vhdl->set_body(0,"-----------------------------------");
    vhdl->set_body(0,"");

    vhdl->set_body(0,"instance_"+_name+"_queue : "+_name+"_queue");
    vhdl->set_body(0,"port map (");
    vhdl->set_body(1,"  in_CLOCK       \t=>\t      in_CLOCK ");
    vhdl->set_body(1,", in_NRESET      \t=>\t      in_NRESET");
    vhdl->set_body(1,", in_INSERT_VAL  \t=>\tinternal_QUEUE_INSERT_VAL");
    vhdl->set_body(1,",out_INSERT_ACK  \t=>\tinternal_QUEUE_INSERT_ACK");
    vhdl->set_body(1,", in_INSERT_DATA \t=>\tinternal_QUEUE_INSERT_DATA");
    vhdl->set_body(1,",out_RETIRE_VAL  \t=>\tinternal_QUEUE_RETIRE_VAL");
    vhdl->set_body(1,", in_RETIRE_ACK  \t=>\tinternal_QUEUE_RETIRE_ACK");
    vhdl->set_body(1,",out_RETIRE_DATA \t=>\tinternal_QUEUE_RETIRE_DATA");
    vhdl->set_body(0,");");

    vhdl->set_body(0,"");
    vhdl->set_body(0,"-----------------------------------");
    vhdl->set_body(0,"-- Queue_data                      ");
    vhdl->set_body(0,"-----------------------------------");
    vhdl->set_body(0,"");
    
    uint32_t min = 0;
    uint32_t max;

    if(_param->_have_port_context_id   )
      {
	max = min-1+_param->_size_context_id;
	vhdl->set_body(0,"internal_QUEUE_INSERT_DATA"+std_logic_range(_param->_size_internal_queue,max,min)+" <= in_READ_QUEUE_IN_CONTEXT_ID;");
	min = max+1;
      }
    if(_param->_have_port_front_end_id   )
      {
	max = min-1+_param->_size_front_end_id;
	vhdl->set_body(0,"internal_QUEUE_INSERT_DATA"+std_logic_range(_param->_size_internal_queue,max,min)+" <= in_READ_QUEUE_IN_FRONT_END_ID;");
	min = max+1;
      }
    if(_param->_have_port_ooo_engine_id   )
      {
	max = min-1+_param->_size_ooo_engine_id;
	vhdl->set_body(0,"internal_QUEUE_INSERT_DATA"+std_logic_range(_param->_size_internal_queue,max,min)+" <= in_READ_QUEUE_IN_OOO_ENGINE_ID;");
	min = max+1;
      }
    if(_param->_have_port_rob_ptr  )
      {
	max = min-1+_param->_size_rob_ptr  ;
	vhdl->set_body(0,"internal_QUEUE_INSERT_DATA"+std_logic_range(_param->_size_internal_queue,max,min)+" <= in_READ_QUEUE_IN_ROB_ID;");
	min = max+1;
      }

    max = min-1+_param->_size_operation;
    vhdl->set_body(0,"internal_QUEUE_INSERT_DATA"+std_logic_range(_param->_size_internal_queue,max,min)+" <= in_READ_QUEUE_IN_OPERATION;");
    min = max+1;

    max = min-1+_param->_size_type;
    vhdl->set_body(0,"internal_QUEUE_INSERT_DATA"+std_logic_range(_param->_size_internal_queue,max,min)+" <= in_READ_QUEUE_IN_TYPE;");
    min = max+1;

    max = min;
    vhdl->set_body(0,"internal_QUEUE_INSERT_DATA"+std_logic_range(_param->_size_internal_queue,max,min)+" <= in_READ_QUEUE_IN_HAS_IMMEDIAT;");
    min = max+1;

    max = min-1+_param->_size_general_data;
    vhdl->set_body(0,"internal_QUEUE_INSERT_DATA"+std_logic_range(_param->_size_internal_queue,max,min)+" <= in_READ_QUEUE_IN_IMMEDIAT;");
    min = max+1;

    max = min;
    vhdl->set_body(0,"internal_QUEUE_INSERT_DATA"+std_logic_range(_param->_size_internal_queue,max,min)+" <= in_READ_QUEUE_IN_READ_RA;");
    min = max+1;

    max = min-1+_param->_size_general_register;
    vhdl->set_body(0,"internal_QUEUE_INSERT_DATA"+std_logic_range(_param->_size_internal_queue,max,min)+" <= in_READ_QUEUE_IN_NUM_REG_RA;");
    min = max+1;

    max = min;
    vhdl->set_body(0,"internal_QUEUE_INSERT_DATA"+std_logic_range(_param->_size_internal_queue,max,min)+" <= in_READ_QUEUE_IN_READ_RB;");
    min = max+1;

    max = min-1+_param->_size_general_register;
    vhdl->set_body(0,"internal_QUEUE_INSERT_DATA"+std_logic_range(_param->_size_internal_queue,max,min)+" <= in_READ_QUEUE_IN_NUM_REG_RB;");
    min = max+1;

    max = min;
    vhdl->set_body(0,"internal_QUEUE_INSERT_DATA"+std_logic_range(_param->_size_internal_queue,max,min)+" <= in_READ_QUEUE_IN_READ_RC;");
    min = max+1;

    max = min-1+_param->_size_special_register;
    vhdl->set_body(0,"internal_QUEUE_INSERT_DATA"+std_logic_range(_param->_size_internal_queue,max,min)+" <= in_READ_QUEUE_IN_NUM_REG_RC;");
    min = max+1;

    max = min;
    vhdl->set_body(0,"internal_QUEUE_INSERT_DATA"+std_logic_range(_param->_size_internal_queue,max,min)+" <= in_READ_QUEUE_IN_WRITE_RD;");
    min = max+1;

    max = min-1+_param->_size_general_register;
    vhdl->set_body(0,"internal_QUEUE_INSERT_DATA"+std_logic_range(_param->_size_internal_queue,max,min)+" <= in_READ_QUEUE_IN_NUM_REG_RD;");
    min = max+1;

    max = min;
    vhdl->set_body(0,"internal_QUEUE_INSERT_DATA"+std_logic_range(_param->_size_internal_queue,max,min)+" <= in_READ_QUEUE_IN_WRITE_RE;");
    min = max+1;

    max = min-1+_param->_size_special_register;
    vhdl->set_body(0,"internal_QUEUE_INSERT_DATA"+std_logic_range(_param->_size_internal_queue,max,min)+" <= in_READ_QUEUE_IN_NUM_REG_RE;");
    min = max+1;

    vhdl->set_body(0,"internal_QUEUE_RETIRE_ACK <= internal_READ_QUEUE_OUT_VAL and in_READ_QUEUE_OUT_ACK;");

    vhdl->set_body(0,"");
    vhdl->set_body(0,"-----------------------------------");
    vhdl->set_body(0,"-- Interface read");
    vhdl->set_body(0,"-----------------------------------");
    vhdl->set_body(0,"");
    vhdl->set_body(0,"-- GPR");
    vhdl->set_body(0,"out_GPR_READ_0_VAL           <= internal_QUEUE_RETIRE_VAL and internal_READ_RA_VAL;");
    vhdl->set_body(0,"out_GPR_READ_1_VAL           <= internal_QUEUE_RETIRE_VAL and internal_READ_RB_VAL;");
    if(_param->_have_port_ooo_engine_id)
      {
	vhdl->set_body(0,"out_GPR_READ_0_OOO_ENGINE_ID <= internal_OOO_ENGINE_ID;");
	vhdl->set_body(0,"out_GPR_READ_1_OOO_ENGINE_ID <= internal_OOO_ENGINE_ID;");
      }
    vhdl->set_body(0,"out_GPR_READ_0_NUM_REG       <= internal_NUM_REG_RA;");
    vhdl->set_body(0,"out_GPR_READ_1_NUM_REG       <= internal_NUM_REG_RB;");
    vhdl->set_body(0,"");
    
    vhdl->set_body(0,"-- SPR");
    vhdl->set_body(0,"out_SPR_READ_0_VAL           <= internal_QUEUE_RETIRE_VAL and internal_READ_RC_VAL;");
    if(_param->_have_port_ooo_engine_id)
      {
	vhdl->set_body(0,"out_SPR_READ_0_OOO_ENGINE_ID <= internal_OOO_ENGINE_ID;");
      }
    vhdl->set_body(0,"out_SPR_READ_0_NUM_REG       <= internal_NUM_REG_RC;");

    vhdl->set_body(0,"");
    vhdl->set_body(0,"-----------------------------------");
    vhdl->set_body(0,"-- Interface read_queue_out");
    vhdl->set_body(0,"-----------------------------------");
    vhdl->set_body(0,"");
    
    if(_param->_have_port_context_id   )
      vhdl->set_body(0,"out_READ_QUEUE_OUT_CONTEXT_ID    <= internal_CONTEXT_ID   ;");
    if(_param->_have_port_front_end_id   )
      vhdl->set_body(0,"out_READ_QUEUE_OUT_FRONT_END_ID  <= internal_FRONT_END_ID ;");
    if(_param->_have_port_ooo_engine_id   )
      vhdl->set_body(0,"out_READ_QUEUE_OUT_OOO_ENGINE_ID <= internal_OOO_ENGINE_ID;");
    if(_param->_have_port_rob_ptr  )
      vhdl->set_body(0,"out_READ_QUEUE_OUT_ROB_ID        <= internal_ROB_ID       ;");
    vhdl->set_body(0,"out_READ_QUEUE_OUT_OPERATION     <= internal_OPERATION    ;");
    vhdl->set_body(0,"out_READ_QUEUE_OUT_TYPE          <= internal_TYPE         ;");
    vhdl->set_body(0,"out_READ_QUEUE_OUT_HAS_IMMEDIAT  <= internal_HAS_IMMEDIAT ;");
    vhdl->set_body(0,"out_READ_QUEUE_OUT_IMMEDIAT      <= internal_IMMEDIAT     ;");
//  vhdl->set_body(0,"out_READ_QUEUE_OUT_READ_RA       <= internal_READ_RA      ;");
    vhdl->set_body(0,"out_READ_QUEUE_OUT_NUM_REG_RA    <= internal_NUM_REG_RA   ;");
    vhdl->set_body(0,"out_READ_QUEUE_OUT_DATA_RA_VAL   <= internal_NEXT_DATA_RA_VAL;");
    vhdl->set_body(0,"out_READ_QUEUE_OUT_DATA_RA       <= internal_NEXT_DATA_RA ;");
//  vhdl->set_body(0,"out_READ_QUEUE_OUT_READ_RB       <= internal_READ_RB      ;");
    vhdl->set_body(0,"out_READ_QUEUE_OUT_NUM_REG_RB    <= internal_NUM_REG_RB   ;");
    vhdl->set_body(0,"out_READ_QUEUE_OUT_DATA_RB_VAL   <= internal_NEXT_DATA_RB_VAL;");
    vhdl->set_body(0,"out_READ_QUEUE_OUT_DATA_RB       <= internal_NEXT_DATA_RB ;");
//  vhdl->set_body(0,"out_READ_QUEUE_OUT_READ_RC       <= internal_READ_RC      ;");
    vhdl->set_body(0,"out_READ_QUEUE_OUT_NUM_REG_RC    <= internal_NUM_REG_RC   ;");
    vhdl->set_body(0,"out_READ_QUEUE_OUT_DATA_RC_VAL   <= internal_NEXT_DATA_RC_VAL;");
    vhdl->set_body(0,"out_READ_QUEUE_OUT_DATA_RC       <= internal_NEXT_DATA_RC ;");
    vhdl->set_body(0,"out_READ_QUEUE_OUT_WRITE_RD      <= internal_WRITE_RD     ;");
    vhdl->set_body(0,"out_READ_QUEUE_OUT_NUM_REG_RD    <= internal_NUM_REG_RD   ;");
    vhdl->set_body(0,"out_READ_QUEUE_OUT_WRITE_RE      <= internal_WRITE_RE     ;");
    vhdl->set_body(0,"out_READ_QUEUE_OUT_NUM_REG_RE    <= internal_NUM_REG_RE   ;");
    
    vhdl->set_body(0,"");
    vhdl->set_body(0,"-----------------------------------");
    vhdl->set_body(0,"-- next reg update");
    vhdl->set_body(0,"-----------------------------------");
    vhdl->set_body(0,"");
    vhdl->set_body(0,"-- read_rx_val - 1 : must access at the registerFile (after access, is set at 0)");
    
    {
      vhdl->set_body(0,"");
      vhdl->set_body(0,"internal_NEXT_READ_RA_VAL <=");
      vhdl->set_body(1,"'0' when");
      // bypass
      vhdl->set_body(2,"-- check bypass");
      for (int32_t i=_param->_nb_gpr_write-1; i>=0 ; i--)
	{
	  std::string cmp;
	  
	  if (_param->_have_port_ooo_engine_id)
	    cmp = "and (in_GPR_WRITE_"+toString(i)+"_OOO_ENGINE_ID=internal_OOO_ENGINE_ID) ";
	  else
	    cmp = "";
	  
	  vhdl->set_body(2,"((in_GPR_WRITE_"+toString(i)+"_VAL='1') "+cmp+"and (internal_NUM_REG_RA=in_GPR_WRITE_"+toString(i)+"_NUM_REG)) or");
	}
      vhdl->set_body(2,"false else");
      vhdl->set_body(1,"internal_READ_RA_VAL and not in_GPR_READ_0_ACK;");
    }
    {
      vhdl->set_body(0,"");
      vhdl->set_body(0,"internal_NEXT_READ_RB_VAL <=");
      vhdl->set_body(1,"'0' when");
      // bypass
      vhdl->set_body(2,"-- check bypass");
      for (int32_t i=_param->_nb_gpr_write-1; i>=0 ; i--)
	{
	  std::string cmp;
	  
	  if (_param->_have_port_ooo_engine_id)
	    cmp = "and (in_GPR_WRITE_"+toString(i)+"_OOO_ENGINE_ID=internal_OOO_ENGINE_ID) ";
	  else
	    cmp = "";
	  
	  vhdl->set_body(2,"((in_GPR_WRITE_"+toString(i)+"_VAL='1') "+cmp+"and (internal_NUM_REG_RB=in_GPR_WRITE_"+toString(i)+"_NUM_REG)) or");
	}
      vhdl->set_body(2,"false else");
      vhdl->set_body(1,"internal_READ_RB_VAL and not in_GPR_READ_1_ACK;");
    }
    {
      vhdl->set_body(0,"");
      vhdl->set_body(0,"internal_NEXT_READ_RC_VAL <=");
      vhdl->set_body(1,"'0' when");
      // bypass
      vhdl->set_body(2,"-- check bypass");
      for (int32_t i=_param->_nb_spr_write-1; i>=0 ; i--)
	{
	  std::string cmp;
	  
	  if (_param->_have_port_ooo_engine_id)
	    cmp = "and (in_SPR_WRITE_"+toString(i)+"_OOO_ENGINE_ID=internal_OOO_ENGINE_ID) ";
	  else
	    cmp = "";
	  
	  vhdl->set_body(2,"((in_SPR_WRITE_"+toString(i)+"_VAL='1') "+cmp+"and (internal_NUM_REG_RC=in_SPR_WRITE_"+toString(i)+"_NUM_REG)) or");
	}
      vhdl->set_body(2,"false else");
      vhdl->set_body(1,"internal_READ_RC_VAL and not in_SPR_READ_0_ACK;");
    }
    {
      vhdl->set_body(0,"");
      vhdl->set_body(0,"internal_READ_QUEUE_OUT_VAL <= not internal_NEXT_READ_RA_VAL and not internal_NEXT_READ_RB_VAL and not internal_NEXT_READ_RC_VAL;");
      vhdl->set_body(0,"     out_READ_QUEUE_OUT_VAL <= internal_READ_QUEUE_OUT_VAL and internal_QUEUE_RETIRE_VAL;");
      
    }
    
    vhdl->set_body(0,"");
    vhdl->set_body(0,"-- data_rx_val - 1 : the read of registerFile is valid");
    
    {
      vhdl->set_body(0,"");
      vhdl->set_body(0,"internal_NEXT_DATA_RA_VAL <=");
      vhdl->set_body(1,"'1' when");
      // bypass
      vhdl->set_body(2,"-- check bypass");
      for (int32_t i=_param->_nb_gpr_write-1; i>=0 ; i--)
	{
	  std::string cmp;
	
	  if (_param->_have_port_ooo_engine_id)
	    cmp = "and (in_GPR_WRITE_"+toString(i)+"_OOO_ENGINE_ID=internal_OOO_ENGINE_ID) ";
	  else
	    cmp = "";
	  
	  vhdl->set_body(2,"((in_GPR_WRITE_"+toString(i)+"_VAL='1') "+cmp+"and (internal_NUM_REG_RA=in_GPR_WRITE_"+toString(i)+"_NUM_REG)) or");
	}
      vhdl->set_body(2,"false else");
      vhdl->set_body(1,"internal_DATA_RA_VAL or (internal_READ_RA_VAL and in_GPR_READ_0_ACK and in_GPR_READ_0_DATA_VAL);");
    }
    {
      vhdl->set_body(0,"");
      vhdl->set_body(0,"internal_NEXT_DATA_RB_VAL <=");
      vhdl->set_body(1,"'1' when");
      // bypass
      vhdl->set_body(2,"-- check bypass");
      for (int32_t i=_param->_nb_gpr_write-1; i>=0 ; i--)
	{
	  std::string cmp;
	  
	  if (_param->_have_port_ooo_engine_id)
	    cmp = "and (in_GPR_WRITE_"+toString(i)+"_OOO_ENGINE_ID=internal_OOO_ENGINE_ID) ";
	else
	  cmp = "";
	  
	  vhdl->set_body(2,"((in_GPR_WRITE_"+toString(i)+"_VAL='1') "+cmp+"and (internal_NUM_REG_RB=in_GPR_WRITE_"+toString(i)+"_NUM_REG)) or");
	}
      vhdl->set_body(2,"false else");
      vhdl->set_body(1,"internal_DATA_RB_VAL or (internal_READ_RB_VAL and in_GPR_READ_1_ACK and in_GPR_READ_1_DATA_VAL);");
    }
    {
      vhdl->set_body(0,"");
      vhdl->set_body(0,"internal_NEXT_DATA_RC_VAL <=");
      vhdl->set_body(1,"'1' when");
      // bypass
      vhdl->set_body(2,"-- check bypass");
      for (int32_t i=_param->_nb_spr_write-1; i>=0 ; i--)
	{
	  std::string cmp;
	  
	  if (_param->_have_port_ooo_engine_id)
	    cmp = "and (in_SPR_WRITE_"+toString(i)+"_OOO_ENGINE_ID=internal_OOO_ENGINE_ID) ";
	  else
	    cmp = "";
	  
	  vhdl->set_body(2,"((in_SPR_WRITE_"+toString(i)+"_VAL='1') "+cmp+"and (internal_NUM_REG_RC=in_SPR_WRITE_"+toString(i)+"_NUM_REG)) or");
	}
      vhdl->set_body(2,"false else");
      vhdl->set_body(1,"internal_DATA_RC_VAL or (internal_READ_RC_VAL and in_SPR_READ_0_ACK and in_SPR_READ_0_DATA_VAL);");
    }
    
    vhdl->set_body(0,"");
    vhdl->set_body(0,"-- data_rx - data read");
    {
      vhdl->set_body(0,"");
      vhdl->set_body(0,"internal_NEXT_DATA_RA <=");
#ifdef SYSTEMC_VHDL_COMPATIBILITY
      vhdl->set_body(1,""+std_logic_others(_param->_size_general_data,0)+" when internal_READ_RA='0' else");
#endif
      // bypass
      vhdl->set_body(2,"-- check bypass");
      for (int32_t i=_param->_nb_gpr_write-1; i>=0 ; i--)
	{
	  std::string cmp;
	
	  if (_param->_have_port_ooo_engine_id)
	    cmp = "and (in_GPR_WRITE_"+toString(i)+"_OOO_ENGINE_ID=internal_OOO_ENGINE_ID) ";
	  else
	    cmp = "";
	  
	  vhdl->set_body(1,"in_GPR_WRITE_"+toString(i)+"_DATA when ((in_GPR_WRITE_"+toString(i)+"_VAL='1') "+cmp+"and (internal_NUM_REG_RA=in_GPR_WRITE_"+toString(i)+"_NUM_REG)) else");
	}
      vhdl->set_body(1,"reg_DATA_RA when (internal_DATA_RA_VAL='1') else");
      vhdl->set_body(1,"in_GPR_READ_0_DATA;");
    }
    {
      vhdl->set_body(0,"");
      vhdl->set_body(0,"internal_NEXT_DATA_RB <=");
#ifdef SYSTEMC_VHDL_COMPATIBILITY
      vhdl->set_body(1,""+std_logic_others(_param->_size_general_data,0)+" when internal_READ_RB='0' else");
#endif
      // bypass
      vhdl->set_body(2,"-- check bypass");
      for (int32_t i=_param->_nb_gpr_write-1; i>=0 ; i--)
	{
	  std::string cmp;
	
	  if (_param->_have_port_ooo_engine_id)
	    cmp = "and (in_GPR_WRITE_"+toString(i)+"_OOO_ENGINE_ID=internal_OOO_ENGINE_ID) ";
	  else
	    cmp = "";
	  
	  vhdl->set_body(1,"in_GPR_WRITE_"+toString(i)+"_DATA when ((in_GPR_WRITE_"+toString(i)+"_VAL='1') "+cmp+"and (internal_NUM_REG_RB=in_GPR_WRITE_"+toString(i)+"_NUM_REG)) else");
	}
      vhdl->set_body(1,"reg_DATA_RB when (internal_DATA_RB_VAL='1') else");
      vhdl->set_body(1,"in_GPR_READ_1_DATA;");
    }
    {
      vhdl->set_body(0,"");
      vhdl->set_body(0,"internal_NEXT_DATA_RC <=");
#ifdef SYSTEMC_VHDL_COMPATIBILITY
      vhdl->set_body(1,""+std_logic_others(_param->_size_special_data,0)+" when internal_READ_RC='0' else");
#endif
      // bypass
      vhdl->set_body(2,"-- check bypass");
      for (int32_t i=_param->_nb_spr_write-1; i>=0 ; i--)
	{
	  std::string cmp;
	
	  if (_param->_have_port_ooo_engine_id)
	    cmp = "and (in_SPR_WRITE_"+toString(i)+"_OOO_ENGINE_ID=internal_OOO_ENGINE_ID) ";
	  else
	    cmp = "";
	  
	  vhdl->set_body(1,"in_SPR_WRITE_"+toString(i)+"_DATA when ((in_SPR_WRITE_"+toString(i)+"_VAL='1') "+cmp+"and (in_SPR_WRITE_"+toString(i)+"_NUM_REG=internal_NUM_REG_RC)) else");
	}
      vhdl->set_body(1,"reg_DATA_RC when (internal_DATA_RC_VAL='1') else");
      vhdl->set_body(1,"in_SPR_READ_0_DATA;");

    vhdl->set_body(0,"");
    vhdl->set_body(0,"-----------------------------------");
    vhdl->set_body(0,"-- transition");
    vhdl->set_body(0,"-----------------------------------");
    vhdl->set_body(0,"");
    vhdl->set_body(0,"-- need a new head if :");
    vhdl->set_body(0,"--   * queue is empty");
    vhdl->set_body(0,"--   * pop with queue");
    vhdl->set_body(0,"internal_NEXT_NEED_NEW_HEAD <= not internal_QUEUE_RETIRE_VAL or (internal_QUEUE_RETIRE_VAL and internal_QUEUE_RETIRE_ACK);");

    vhdl->set_body(0,"internal_READ_RA_VAL   <=     internal_READ_RA when reg_NEED_NEW_HEAD='1' else reg_READ_RA_VAL;");
    vhdl->set_body(0,"internal_READ_RB_VAL   <=     internal_READ_RB when reg_NEED_NEW_HEAD='1' else reg_READ_RB_VAL;");
    vhdl->set_body(0,"internal_READ_RC_VAL   <=     internal_READ_RC when reg_NEED_NEW_HEAD='1' else reg_READ_RC_VAL;");
    vhdl->set_body(0,"internal_DATA_RA_VAL   <= not internal_READ_RA when reg_NEED_NEW_HEAD='1' else reg_DATA_RA_VAL;");
    vhdl->set_body(0,"internal_DATA_RB_VAL   <= not internal_READ_RB when reg_NEED_NEW_HEAD='1' else reg_DATA_RB_VAL;");
    vhdl->set_body(0,"internal_DATA_RC_VAL   <= not internal_READ_RC when reg_NEED_NEW_HEAD='1' else reg_DATA_RC_VAL;");


    vhdl->set_body(0,"");
    vhdl->set_body(0,"transition: process (in_CLOCK)");
    vhdl->set_body(0,"begin  -- process transition");
    vhdl->set_body(1,"if in_CLOCK'event and in_CLOCK = '1' then");
    vhdl->set_body(0,"");
    vhdl->set_body(2,"if (in_NRESET = '0') then");    
    vhdl->set_body(3,"reg_NEED_NEW_HEAD <= '1';");
    vhdl->set_body(2,"else");
    vhdl->set_body(3,"reg_NEED_NEW_HEAD <= internal_NEXT_NEED_NEW_HEAD;");
    vhdl->set_body(3,"reg_READ_RA_VAL   <= internal_NEXT_READ_RA_VAL;");
    vhdl->set_body(3,"reg_READ_RB_VAL   <= internal_NEXT_READ_RB_VAL;");
    vhdl->set_body(3,"reg_READ_RC_VAL   <= internal_NEXT_READ_RC_VAL;");
    vhdl->set_body(3,"reg_DATA_RA_VAL   <= internal_NEXT_DATA_RA_VAL;");
    vhdl->set_body(3,"reg_DATA_RB_VAL   <= internal_NEXT_DATA_RB_VAL;");
    vhdl->set_body(3,"reg_DATA_RC_VAL   <= internal_NEXT_DATA_RC_VAL;");
    vhdl->set_body(3,"reg_DATA_RA       <= internal_NEXT_DATA_RA    ;");
    vhdl->set_body(3,"reg_DATA_RB       <= internal_NEXT_DATA_RB    ;");
    vhdl->set_body(3,"reg_DATA_RC       <= internal_NEXT_DATA_RC    ;");

    vhdl->set_body(2,"end if;");
    vhdl->set_body(0,"");
    vhdl->set_body(1,"end if;");
    vhdl->set_body(0,"end process transition;");

    }


    log_printf(FUNC,Read_queue,"vhdl_body","End");
  };

}; // end namespace read_queue
}; // end namespace read_unit
}; // end namespace multi_read_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
