/*
 * $Id: Register_unit_Glue_allocation.cpp 136 2009-10-20 18:52:15Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Register_unit/Register_unit_Glue/include/Register_unit_Glue.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace register_unit {
namespace register_unit_glue {



#undef  FUNCTION
#define FUNCTION "Register_unit_Glue::allocation"
  void Register_unit_Glue::allocation (void)
  {
    log_printf(FUNC,Register_unit_Glue,FUNCTION,"Begin");

    _component   = new Component (_usage);

    Entity * entity = _component->set_entity (_name       
					      ,"Register_unit_Glue"
#ifdef POSITION
					      ,COMBINATORY 
#endif
					      );

    _interfaces = entity->set_interfaces();

    // ~~~~~[Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    Interface * interface = _interfaces->set_interface(""
#ifdef POSITION
						       ,IN
						       ,SOUTH,
						       "Generalist interface"
#endif
						       );
    
     in_CLOCK        = interface->set_signal_clk              ("clock" ,1, CLOCK_VHDL_NO);
     in_NRESET       = interface->set_signal_in  <Tcontrol_t> ("nreset",1, RESET_VHDL_NO);
//     out_CONST_0      = interface->set_signal_out <Tcontrol_t> ("const_0",1);
//     out_CONST_1      = interface->set_signal_out <Tcontrol_t> ("const_1",1);

    // ~~~~~[ Interface "gpr_read" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE_BEGIN("gpr_read",IN,NORTH,_("Interface to read generalist register"),_param->_nb_gpr_read);

      ALLOC1_VALACK_IN ( in_GPR_READ_VAL           ,VAL);
      ALLOC1_VALACK_OUT(out_GPR_READ_ACK           ,ACK);
      ALLOC1_SIGNAL_IN ( in_GPR_READ_OOO_ENGINE_ID ,"ooo_engine_id",Tcontext_t     , _param->_size_ooo_engine_id);
      ALLOC1_SIGNAL_OUT(out_GPR_READ_DATA          ,"data"         ,Tgeneral_data_t, _param->_size_general_data);
      ALLOC1_SIGNAL_OUT(out_GPR_READ_DATA_VAL      ,"data_val"     ,Tcontrol_t     , 1);

      ALLOC1_INTERFACE_END(_param->_nb_gpr_read);
    }

    {
      ALLOC2_INTERFACE_BEGIN("gpr_read_registerfile",IN,NORTH,_("Interface to read generalist register - from/to register file"),_param->_nb_ooo_engine,_param->_nb_gpr_read);
      
      ALLOC2_VALACK_OUT(out_GPR_READ_REGISTERFILE_VAL ,VAL);
      ALLOC2_VALACK_IN ( in_GPR_READ_REGISTERFILE_ACK ,ACK);
      ALLOC2_SIGNAL_IN ( in_GPR_READ_REGISTERFILE_DATA,"data",Tgeneral_data_t,_param->_size_general_data);
      
      ALLOC2_INTERFACE_END(_param->_nb_ooo_engine,_param->_nb_gpr_read);
    }
    
    {
      ALLOC2_INTERFACE_BEGIN("gpr_read_status",IN,NORTH,_("Interface to read generalist register - from/to register file"),_param->_nb_ooo_engine,_param->_nb_gpr_read);
      
      ALLOC2_VALACK_OUT(out_GPR_READ_STATUS_VAL      ,VAL);
      ALLOC2_VALACK_IN ( in_GPR_READ_STATUS_ACK      ,ACK);
      ALLOC2_SIGNAL_IN ( in_GPR_READ_STATUS_DATA_VAL,"data_val",Tgeneral_data_t,1);

      ALLOC2_INTERFACE_END(_param->_nb_ooo_engine,_param->_nb_gpr_read);
    }

    // ~~~~~[ Interface "spr_read" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE_BEGIN("spr_read",IN,NORTH,_("Interface to read generalist register"),_param->_nb_spr_read);

      ALLOC1_VALACK_IN ( in_SPR_READ_VAL           ,VAL);
      ALLOC1_VALACK_OUT(out_SPR_READ_ACK           ,ACK);
      ALLOC1_SIGNAL_IN ( in_SPR_READ_OOO_ENGINE_ID ,"ooo_engine_id",Tcontext_t     , _param->_size_ooo_engine_id);
      ALLOC1_SIGNAL_OUT(out_SPR_READ_DATA          ,"data"         ,Tspecial_data_t, _param->_size_special_data);
      ALLOC1_SIGNAL_OUT(out_SPR_READ_DATA_VAL      ,"data_val"     ,Tcontrol_t     , 1);

      ALLOC1_INTERFACE_END(_param->_nb_spr_read);
    }
    
    {
      ALLOC2_INTERFACE_BEGIN("spr_read_registerfile",IN,NORTH,_("Interface to read generalist register - from/to register file"),_param->_nb_ooo_engine,_param->_nb_spr_read);
      
      ALLOC2_VALACK_OUT(out_SPR_READ_REGISTERFILE_VAL ,VAL);
      ALLOC2_VALACK_IN ( in_SPR_READ_REGISTERFILE_ACK ,ACK);
      ALLOC2_SIGNAL_IN ( in_SPR_READ_REGISTERFILE_DATA,"data",Tspecial_data_t,_param->_size_special_data);
      
      ALLOC2_INTERFACE_END(_param->_nb_ooo_engine,_param->_nb_spr_read);
    }
    
    {
      ALLOC2_INTERFACE_BEGIN("spr_read_status",IN,NORTH,_("Interface to read generalist register - from/to status"),_param->_nb_ooo_engine,_param->_nb_spr_read);
      
      ALLOC2_VALACK_OUT(out_SPR_READ_STATUS_VAL      ,VAL);
      ALLOC2_VALACK_IN ( in_SPR_READ_STATUS_ACK      ,ACK);
      ALLOC2_SIGNAL_IN ( in_SPR_READ_STATUS_DATA_VAL,"data_val",Tspecial_data_t,1);
      
      ALLOC2_INTERFACE_END(_param->_nb_ooo_engine,_param->_nb_spr_read);
    }

    // ~~~~~[ Interface "gpr_write" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE_BEGIN("gpr_write",IN,NORTH,_("Interface to write generalist register"),_param->_nb_gpr_write);
      
      ALLOC1_VALACK_IN ( in_GPR_WRITE_VAL          ,VAL);
      ALLOC1_VALACK_OUT(out_GPR_WRITE_ACK          ,ACK);
      ALLOC1_SIGNAL_IN ( in_GPR_WRITE_OOO_ENGINE_ID,"ooo_engine_id",Tcontext_t, _param->_size_ooo_engine_id);

      ALLOC1_INTERFACE_END(_param->_nb_gpr_write);
    }
    
    {
      ALLOC2_INTERFACE_BEGIN("gpr_write_registerfile",IN,NORTH,_("Interface to write generalist register - from/to registerfile"),_param->_nb_ooo_engine,_param->_nb_gpr_write);
      
      ALLOC2_VALACK_OUT(out_GPR_WRITE_REGISTERFILE_VAL,VAL);
      ALLOC2_VALACK_IN ( in_GPR_WRITE_REGISTERFILE_ACK,ACK);

      ALLOC2_INTERFACE_END(_param->_nb_ooo_engine,_param->_nb_gpr_write);
    }
    
    {
      ALLOC2_INTERFACE_BEGIN("gpr_write_status",IN,NORTH,_("Interface to write generalist register - from/to status"),_param->_nb_ooo_engine,_param->_nb_gpr_write);
      
      ALLOC2_VALACK_OUT(out_GPR_WRITE_STATUS_VAL ,VAL);
      ALLOC2_VALACK_IN ( in_GPR_WRITE_STATUS_ACK ,ACK);
      ALLOC2_SIGNAL_OUT(out_GPR_WRITE_STATUS_DATA,"data",Tgeneral_data_t,1);

      ALLOC2_INTERFACE_END(_param->_nb_ooo_engine,_param->_nb_gpr_write);
    }

    // ~~~~~[ Interface "spr_write" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE_BEGIN("spr_write",IN,NORTH,_("Interface to write generalist register"),_param->_nb_spr_write);
      
      ALLOC1_VALACK_IN ( in_SPR_WRITE_VAL          ,VAL);
      ALLOC1_VALACK_OUT(out_SPR_WRITE_ACK          ,ACK);
      ALLOC1_SIGNAL_IN ( in_SPR_WRITE_OOO_ENGINE_ID,"ooo_engine_id",Tcontext_t, _param->_size_ooo_engine_id);

      ALLOC1_INTERFACE_END(_param->_nb_spr_write);
    }
    
    {
      ALLOC2_INTERFACE_BEGIN("spr_write_registerfile",IN,NORTH,_("Interface to write generalist register - from/to registerfile"),_param->_nb_ooo_engine,_param->_nb_spr_write);
      
      ALLOC2_VALACK_OUT(out_SPR_WRITE_REGISTERFILE_VAL,VAL);
      ALLOC2_VALACK_IN ( in_SPR_WRITE_REGISTERFILE_ACK,ACK);

      ALLOC2_INTERFACE_END(_param->_nb_ooo_engine,_param->_nb_spr_write);
    }
    
    {
      ALLOC2_INTERFACE_BEGIN("spr_write_status",IN,NORTH,_("Interface to write generalist register - from/to status"),_param->_nb_ooo_engine,_param->_nb_spr_write);
      
      ALLOC2_VALACK_OUT(out_SPR_WRITE_STATUS_VAL,VAL);
      ALLOC2_VALACK_IN ( in_SPR_WRITE_STATUS_ACK,ACK);
      ALLOC2_SIGNAL_OUT(out_SPR_WRITE_STATUS_DATA,"data",Tspecial_data_t,1);

      ALLOC2_INTERFACE_END(_param->_nb_ooo_engine,_param->_nb_spr_write);
    }

    // ~~~~~[ Interface "issue" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE_BEGIN("issue",IN,WEST,_("Interface to update status (insert)"),_param->_nb_inst_issue);
      
      ALLOC1_VALACK_IN ( in_ISSUE_VAL          ,VAL);
      ALLOC1_VALACK_OUT(out_ISSUE_ACK          ,ACK);
      ALLOC1_SIGNAL_IN ( in_ISSUE_OOO_ENGINE_ID,"ooo_engine_id",Tcontext_t,_param->_size_ooo_engine_id);
      ALLOC1_SIGNAL_IN ( in_ISSUE_RD_USE       ,"rd_use"       ,Tcontrol_t, 1);
      ALLOC1_SIGNAL_IN ( in_ISSUE_RE_USE       ,"re_use"       ,Tcontrol_t, 1);

      ALLOC1_INTERFACE_END(_param->_nb_inst_issue);
    }
    
    {
      ALLOC2_INTERFACE_BEGIN("issue_gpr_status",IN,WEST,_("Interface to update status (insert)"),_param->_nb_ooo_engine,_param->_nb_inst_issue);
      
      ALLOC2_VALACK_OUT(out_ISSUE_GPR_STATUS_VAL ,VAL                     );
      ALLOC2_VALACK_IN ( in_ISSUE_GPR_STATUS_ACK ,ACK                     );
      ALLOC2_SIGNAL_OUT(out_ISSUE_GPR_STATUS_DATA,"data",Tgeneral_data_t,1);

      ALLOC2_INTERFACE_END(_param->_nb_ooo_engine,_param->_nb_inst_issue);
    }
    
    {
      ALLOC2_INTERFACE_BEGIN("issue_spr_status",IN,WEST,_("Interface to update status (insert)"),_param->_nb_ooo_engine, _param->_nb_inst_issue);
      
      ALLOC2_VALACK_OUT(out_ISSUE_SPR_STATUS_VAL ,VAL                     );
      ALLOC2_VALACK_IN ( in_ISSUE_SPR_STATUS_ACK ,ACK                     );
      ALLOC2_SIGNAL_OUT(out_ISSUE_SPR_STATUS_DATA,"data",Tspecial_data_t,1);

      ALLOC2_INTERFACE_END(_param->_nb_ooo_engine,_param->_nb_inst_issue);
    }

//     // ~~~~~[ Interface "insert_rob" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//     {
//       ALLOC2_INTERFACE_BEGIN("insert_rob",IN,WEST,_("Interface to update status (insert)"),_param->_nb_ooo_engine,_param->_nb_inst_insert_rob [it1]);
      
//       _ALLOC2_VALACK_IN ( in_INSERT_ROB_VAL   ,VAL                   ,_param->_nb_ooo_engine,_param->_nb_inst_insert_rob [it1]);
//       _ALLOC2_VALACK_OUT(out_INSERT_ROB_ACK   ,ACK                   ,_param->_nb_ooo_engine,_param->_nb_inst_insert_rob [it1]);
//       _ALLOC2_SIGNAL_IN ( in_INSERT_ROB_RD_USE,"rd_use",Tcontrol_t, 1,_param->_nb_ooo_engine,_param->_nb_inst_insert_rob [it1]);
//       _ALLOC2_SIGNAL_IN ( in_INSERT_ROB_RE_USE,"re_use",Tcontrol_t, 1,_param->_nb_ooo_engine,_param->_nb_inst_insert_rob [it1]);

//       ALLOC2_INTERFACE_END(_param->_nb_ooo_engine,_param->_nb_inst_insert_rob [it1]);
//     }
    
//     {
//       ALLOC2_INTERFACE_BEGIN("insert_rob_gpr_status",IN,WEST,_("Interface to update status (insert)"),_param->_nb_ooo_engine,_param->_nb_inst_insert_rob [it1]);
      
//       _ALLOC2_VALACK_OUT(out_INSERT_ROB_GPR_STATUS_VAL ,VAL                     ,_param->_nb_ooo_engine,_param->_nb_inst_insert_rob [it1]);
//       _ALLOC2_VALACK_IN ( in_INSERT_ROB_GPR_STATUS_ACK ,ACK                     ,_param->_nb_ooo_engine,_param->_nb_inst_insert_rob [it1]);
//       _ALLOC2_SIGNAL_OUT(out_INSERT_ROB_GPR_STATUS_DATA,"data",Tgeneral_data_t,1,_param->_nb_ooo_engine,_param->_nb_inst_insert_rob [it1]);

//       ALLOC2_INTERFACE_END(_param->_nb_ooo_engine,_param->_nb_inst_insert_rob [it1]);
//     }
    
//     {
//       ALLOC2_INTERFACE_BEGIN("insert_rob_spr_status",IN,WEST,_("Interface to update status (insert)"),_param->_nb_ooo_engine,_param->_nb_inst_insert_rob [it1]);
      
//       _ALLOC2_VALACK_OUT(out_INSERT_ROB_SPR_STATUS_VAL ,VAL                     ,_param->_nb_ooo_engine,_param->_nb_inst_insert_rob [it1]);
//       _ALLOC2_VALACK_IN ( in_INSERT_ROB_SPR_STATUS_ACK ,ACK                     ,_param->_nb_ooo_engine,_param->_nb_inst_insert_rob [it1]);
//       _ALLOC2_SIGNAL_OUT(out_INSERT_ROB_SPR_STATUS_DATA,"data",Tspecial_data_t,1,_param->_nb_ooo_engine,_param->_nb_inst_insert_rob [it1]);

//       ALLOC2_INTERFACE_END(_param->_nb_ooo_engine,_param->_nb_inst_insert_rob [it1]);
//     }

//     // ~~~~~[Interface "retire_rob" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//     in_RETIRE_ROB_VAL                      = new SC_IN (Tcontrol_t) ** [_param->_nb_ooo_engine];
//    out_RETIRE_ROB_ACK                      = new SC_OUT(Tcontrol_t) ** [_param->_nb_ooo_engine];
//     in_RETIRE_ROB_RD_OLD_USE               = new SC_IN (Tcontrol_t) ** [_param->_nb_ooo_engine];
//     in_RETIRE_ROB_RD_NEW_USE               = new SC_IN (Tcontrol_t) ** [_param->_nb_ooo_engine];
//     in_RETIRE_ROB_RE_OLD_USE               = new SC_IN (Tcontrol_t) ** [_param->_nb_ooo_engine];
//     in_RETIRE_ROB_RE_NEW_USE               = new SC_IN (Tcontrol_t) ** [_param->_nb_ooo_engine];
//    out_RETIRE_ROB_GPR_STATUS_OLD_VAL       = new SC_OUT(Tcontrol_t) ** [_param->_nb_ooo_engine];
//    out_RETIRE_ROB_GPR_STATUS_NEW_VAL       = new SC_OUT(Tcontrol_t) ** [_param->_nb_ooo_engine];
//     in_RETIRE_ROB_GPR_STATUS_OLD_ACK       = new SC_IN (Tcontrol_t) ** [_param->_nb_ooo_engine];
//     in_RETIRE_ROB_GPR_STATUS_NEW_ACK       = new SC_IN (Tcontrol_t) ** [_param->_nb_ooo_engine];
//    out_RETIRE_ROB_SPR_STATUS_OLD_VAL       = new SC_OUT(Tcontrol_t) ** [_param->_nb_ooo_engine];
//    out_RETIRE_ROB_SPR_STATUS_NEW_VAL       = new SC_OUT(Tcontrol_t) ** [_param->_nb_ooo_engine];
//     in_RETIRE_ROB_SPR_STATUS_OLD_ACK       = new SC_IN (Tcontrol_t) ** [_param->_nb_ooo_engine];
//     in_RETIRE_ROB_SPR_STATUS_NEW_ACK       = new SC_IN (Tcontrol_t) ** [_param->_nb_ooo_engine];

//     for (uint32_t i=0; i<_param->_nb_ooo_engine; i++)
//       {
// 	uint32_t x=_param->_nb_inst_retire_rob [i];

// 	 in_RETIRE_ROB_VAL                      [i] = new SC_IN (Tcontrol_t) * [x];
// 	out_RETIRE_ROB_ACK                      [i] = new SC_OUT(Tcontrol_t) * [x];
// 	 in_RETIRE_ROB_RD_OLD_USE               [i] = new SC_IN (Tcontrol_t) * [x];
// 	 in_RETIRE_ROB_RD_NEW_USE               [i] = new SC_IN (Tcontrol_t) * [x];
// 	 in_RETIRE_ROB_RE_OLD_USE               [i] = new SC_IN (Tcontrol_t) * [x];
// 	 in_RETIRE_ROB_RE_NEW_USE               [i] = new SC_IN (Tcontrol_t) * [x];
// 	out_RETIRE_ROB_GPR_STATUS_OLD_VAL       [i] = new SC_OUT(Tcontrol_t) * [x];
// 	out_RETIRE_ROB_GPR_STATUS_NEW_VAL       [i] = new SC_OUT(Tcontrol_t) * [x];
// 	 in_RETIRE_ROB_GPR_STATUS_OLD_ACK       [i] = new SC_IN (Tcontrol_t) * [x];
// 	 in_RETIRE_ROB_GPR_STATUS_NEW_ACK       [i] = new SC_IN (Tcontrol_t) * [x];
// 	out_RETIRE_ROB_SPR_STATUS_OLD_VAL       [i] = new SC_OUT(Tcontrol_t) * [x];
// 	out_RETIRE_ROB_SPR_STATUS_NEW_VAL       [i] = new SC_OUT(Tcontrol_t) * [x];
// 	 in_RETIRE_ROB_SPR_STATUS_OLD_ACK       [i] = new SC_IN (Tcontrol_t) * [x];
// 	 in_RETIRE_ROB_SPR_STATUS_NEW_ACK       [i] = new SC_IN (Tcontrol_t) * [x];
    
// 	for (uint32_t j=0; j<x; j++)
// 	  {
// 	    {
// 	      Interface_fifo * interface = _interfaces->set_interface("retire_rob_"+toString(i)+"_"+toString(j)
// #ifdef POSITION
// 								      ,IN
// 								      ,WEST
// 								      ,"Interface to update status (retire)"
// #endif
// 								      );

// 	       in_RETIRE_ROB_VAL                      [i][j] = interface->set_signal_valack_in (VAL);
// 	      out_RETIRE_ROB_ACK                      [i][j] = interface->set_signal_valack_out(ACK);
// 	       in_RETIRE_ROB_RD_OLD_USE               [i][j] = interface->set_signal_in <Tcontrol_t> ("rd_old_use", 1);
// 	       in_RETIRE_ROB_RD_NEW_USE               [i][j] = interface->set_signal_in <Tcontrol_t> ("rd_new_use", 1);
// 	       in_RETIRE_ROB_RE_OLD_USE               [i][j] = interface->set_signal_in <Tcontrol_t> ("re_old_use", 1);
// 	       in_RETIRE_ROB_RE_NEW_USE               [i][j] = interface->set_signal_in <Tcontrol_t> ("re_new_use", 1);
// 	    }
// 	    {
// 	      Interface_fifo * interface = _interfaces->set_interface("retire_rob_gpr_status_old_"+toString(i)+"_"+toString(j)
// #ifdef POSITION
// 								      ,IN
// 								      ,EAST
// 								      ,"Interface to update status (retire)"
// #endif
// 								      );

// 	      out_RETIRE_ROB_GPR_STATUS_OLD_VAL [i][j] = interface->set_signal_valack_out(VAL);
// 	       in_RETIRE_ROB_GPR_STATUS_OLD_ACK [i][j] = interface->set_signal_valack_in (ACK);
// 	    }
// 	    {
// 	      Interface_fifo * interface = _interfaces->set_interface("retire_rob_gpr_status_new_"+toString(i)+"_"+toString(j)
// #ifdef POSITION
// 								      ,IN
// 								      ,EAST
// 								      ,"Interface to update status (retire)"
// #endif
// 								      );

// 	      out_RETIRE_ROB_GPR_STATUS_NEW_VAL [i][j] = interface->set_signal_valack_out(VAL);
// 	       in_RETIRE_ROB_GPR_STATUS_NEW_ACK [i][j] = interface->set_signal_valack_in (ACK);
// 	    }
// 	    {
// 	      Interface_fifo * interface = _interfaces->set_interface("retire_rob_spr_status_old_"+toString(i)+"_"+toString(j)
// #ifdef POSITION
// 								      ,IN
// 								      ,EAST
// 								      ,"Interface to update status (retire)"
// #endif
// 								      );

// 	      out_RETIRE_ROB_SPR_STATUS_OLD_VAL [i][j] = interface->set_signal_valack_out(VAL);
// 	       in_RETIRE_ROB_SPR_STATUS_OLD_ACK [i][j] = interface->set_signal_valack_in (ACK);
// 	    }
// 	    {
// 	      Interface_fifo * interface = _interfaces->set_interface("retire_rob_spr_status_new_"+toString(i)+"_"+toString(j)
// #ifdef POSITION
// 								      ,IN
// 								      ,EAST
// 								      ,"Interface to update status (retire)"
// #endif
// 								      );

// 	      out_RETIRE_ROB_SPR_STATUS_NEW_VAL [i][j] = interface->set_signal_valack_out(VAL);
// 	       in_RETIRE_ROB_SPR_STATUS_NEW_ACK [i][j] = interface->set_signal_valack_in (ACK);
// 	    }
// 	  }
//       }

    // ~~~~~[Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

#ifdef POSITION
    if (usage_is_set(_usage,USE_POSITION))
      _component->generate_file();
#endif

    log_printf(FUNC,Register_unit_Glue,FUNCTION,"End");
  };

}; // end namespace register_unit_glue
}; // end namespace register_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
