/*
 * $Id: Reexecute_unit.cpp 136 2009-10-20 18:52:15Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Reexecute_unit/include/Reexecute_unit.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace reexecute_unit {


#undef  FUNCTION
#define FUNCTION "Reexecute_unit::Reexecute_unit"
  Reexecute_unit::Reexecute_unit 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   string name,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   morpheo::behavioural::core::multi_ooo_engine::ooo_engine::reexecute_unit::Parameters * param,
   morpheo::behavioural::Tusage_t usage
   ):
    _name              (name)
    ,_param            (param)
    ,_usage            (usage)
  {
    log_begin(Reexecute_unit,FUNCTION);

    usage_environment(_usage);

// #if DEBUG_Reexecute_unit == true
//     log_printf(INFO,Reexecute_unit,FUNCTION,_("<%s> Parameters"),_name.c_str());

//     std::cout << *param << std::endl;
// #endif    

    log_printf(INFO,Reexecute_unit,FUNCTION,_("<%s> : Allocation"),_name.c_str());

    allocation (
#ifdef STATISTICS
		param_statistics
#endif
		);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {	
	log_printf(INFO,Reexecute_unit,FUNCTION,_("<%s> : Allocation of statistics"),_name.c_str());

	statistics_allocation(param_statistics);
      }
#endif

#ifdef VHDL
    if (usage_is_set(_usage,USE_VHDL))
      {
	// generate the vhdl
	log_printf(INFO,Reexecute_unit,FUNCTION,_("<%s> : Generate the vhdl"),_name.c_str());
	
	vhdl();
      }
#endif

#ifdef SYSTEMC
    if (usage_is_set(_usage,USE_SYSTEMC))
      {
#ifdef SYSTEMCASS_SPECIFIC
        constant();
#else
	log_printf(INFO,Reexecute_unit,FUNCTION,_("<%s> : Method - constant"),_name.c_str());

	SC_METHOD (constant);
// 	dont_initialize ();
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    
#endif

	log_printf(INFO,Reexecute_unit,FUNCTION,_("<%s> : Method - transition"),_name.c_str());

	SC_METHOD (transition);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).pos();
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    

	log_printf(INFO,Reexecute_unit,FUNCTION,_("<%s> : Method - genMoore"),_name.c_str());

	SC_METHOD (genMoore);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).neg(); // need internal register
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    

	log_printf(INFO,Reexecute_unit,FUNCTION,_("<%s> : Method - genMealy_reexecute"),_name.c_str());

	SC_METHOD (genMealy_reexecute);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).neg() // need internal register
		  << (*(in_NRESET));

	for (uint32_t i=0; i<_param->_nb_inst_reexecute; i++)
	  {
	    if (_param->_have_port_context_id)
	    sensitive << (*(in_REEXECUTE_ROB_CONTEXT_ID            [i]));
	    if (_param->_have_port_front_end_id)
	    sensitive << (*(in_REEXECUTE_ROB_FRONT_END_ID          [i]));
	    if (_param->_have_port_rob_ptr  )
	    sensitive << (*(in_REEXECUTE_ROB_PACKET_ID             [i]));
	    sensitive << (*(in_REEXECUTE_ROB_VAL                   [i]))
		      << (*(in_REEXECUTE_ACK                       [i]))
		      << (*(in_REEXECUTE_ROB_OPERATION             [i]))
		      << (*(in_REEXECUTE_ROB_TYPE                  [i]))
		      << (*(in_REEXECUTE_ROB_STORE_QUEUE_PTR_WRITE [i]));
	  }

# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    

	log_printf(INFO,Reexecute_unit,FUNCTION,_("<%s> : Method - genMealy_commit"),_name.c_str());

	SC_METHOD (genMealy_commit);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).neg() // need internal register
		  << (*(in_NRESET));

	for (uint32_t i=0; i<_param->_nb_execute_loop; ++i)
	  for (uint32_t j=0; j<_param->_nb_inst_execute [i]; ++j)
	    {
	      if (_param->_have_port_context_id)
	      sensitive << (*(in_EXECUTE_LOOP_CONTEXT_ID   [i][j]));
	      if (_param->_have_port_front_end_id)
	      sensitive << (*(in_EXECUTE_LOOP_FRONT_END_ID [i][j]));
	      if (_param->_have_port_rob_ptr  )
	      sensitive << (*(in_EXECUTE_LOOP_PACKET_ID    [i][j]));
	      sensitive << (*(in_EXECUTE_LOOP_VAL          [i][j]))
// 			<< (*(in_EXECUTE_LOOP_OPERATION    [i][j]))
// 			<< (*(in_EXECUTE_LOOP_TYPE         [i][j]))
			<< (*(in_EXECUTE_LOOP_CANCEL       [i][j]))
			<< (*(in_EXECUTE_LOOP_FLAGS        [i][j]))
			<< (*(in_EXECUTE_LOOP_EXCEPTION    [i][j]))
			<< (*(in_EXECUTE_LOOP_NO_SEQUENCE  [i][j]))
			<< (*(in_EXECUTE_LOOP_ADDRESS      [i][j]))
			<< (*(in_EXECUTE_LOOP_DATA         [i][j]));
	    }
	for (uint32_t i=0; i<_param->_nb_inst_commit; ++i)
	  sensitive << (*(in_COMMIT_ACK [i]));

# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    

#endif
      }
    log_end(Reexecute_unit,FUNCTION);
  };
    
#undef  FUNCTION
#define FUNCTION "Reexecute_unit::~Reexecute_unit"
  Reexecute_unit::~Reexecute_unit (void)
  {
    log_begin(Reexecute_unit,FUNCTION);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {
	statistics_deallocation();
      }
#endif

    log_printf(INFO,Reexecute_unit,FUNCTION,_("<%s> : Deallocation"),_name.c_str());
    deallocation ();

    log_end(Reexecute_unit,FUNCTION);
  };

}; // end namespace reexecute_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
