#ifndef morpheo_behavioural_generic_registerfile_registerfile_multi_banked_Parameters_h
#define morpheo_behavioural_generic_registerfile_registerfile_multi_banked_Parameters_h

/*
 * $Id: Parameters.h 137 2010-02-16 12:35:48Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Common/include/Debug.h"
#include "Behavioural/include/Parameters.h"
#include "Behavioural/Generic/RegisterFile/RegisterFile_Multi_Banked/include/Types.h"
#include <math.h>

namespace morpheo {
namespace behavioural {
namespace generic {
namespace registerfile {
namespace registerfile_multi_banked {


  class Parameters : public morpheo::behavioural::Parameters
  {
    //-----[ fields ]------------------------------------------------------------
  public : uint32_t    _nb_port_read         ; // Global read  port
  public : uint32_t    _nb_port_write        ; // Global write port
  public : uint32_t    _nb_word              ;
  public : uint32_t    _size_word            ;
  public : uint32_t    _nb_bank              ; // Number of bank (All bank is identical)
  public : uint32_t    _nb_port_read_by_bank ; // Local  read  port
  public : uint32_t    _nb_port_write_by_bank; // Local  write port
  public : Tcrossbar_t _crossbar             ;
  public : std::string _init_value           ;

  public : uint32_t    _size_address         ;
  public : uint32_t    _size_address_by_bank ;

  public : uint32_t    _bank_shift           ;
  public : Taddress_t  _bank_mask            ;
  public : uint32_t    _num_reg_shift        ;
  public : Taddress_t  _num_reg_mask         ;

  public : uint32_t    _nb_word_by_bank      ;

  public : bool        _have_port_address     ;
  public : bool        _have_bank_port_address;
  public : bool        _have_init_value       ;

    // A lot of table to the partial crossbar
  public : uint32_t  * _link_port_read_to_bank_read  ;
//public : uint32_t  * _link_port_read_to_num_bank   ;
  public : uint32_t  * _link_port_write_to_bank_write;
//public : uint32_t  * _link_port_write_to_num_bank  ;

    //-----[ methods ]-----------------------------------------------------------
  public : Parameters  (uint32_t    nb_port_read         ,
			uint32_t    nb_port_write        ,
			uint32_t    nb_word              ,
			uint32_t    size_word            ,
			uint32_t    nb_bank              ,
			uint32_t    nb_port_read_by_bank ,
			uint32_t    nb_port_write_by_bank,
			Tcrossbar_t crossbar             ,
                        std::string init_value=""        );
//   public : Parameters  (Parameters & param) ;
  public : ~Parameters () ;

  public :        void            copy       (void);

  public :        Parameters_test msg_error  (void);

  public :        std::string     print      (uint32_t depth);
  public : friend std::ostream&   operator<< (std::ostream& output_stream,
                                              morpheo::behavioural::generic::registerfile::registerfile_multi_banked::Parameters & x);
  };

}; // end namespace registerfile_multi_banked
}; // end namespace registerfile
}; // end namespace generic
}; // end namespace behavioural
}; // end namespace morpheo              

#endif
