/*
 * $Id: Shifter_allocation.cpp 112 2009-03-18 22:36:26Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/Shifter/include/Shifter.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace shifter {


  void Shifter::allocation (void)
  {
    _component   = new Component (_usage);

    Entity * entity = _component->set_entity (_name       
					     ,"Shifter"   
#ifdef POSITION
					     ,COMBINATORY 
#endif
					     );
    
    _interfaces = entity->set_interfaces();

#if (defined(STATISTICS) || defined (VHDL_TESTBENCH))
    {
      Interface_fifo * interface = _interfaces->set_interface(""
#ifdef POSITION
							      , IN  
							      , SOUTH
							      , _("Generalist interface")
#endif
							      );
      
       in_CLOCK        = interface->set_signal_clk              ("clock" ,1, CLOCK_VHDL_NO);
       in_NRESET       = interface->set_signal_in <Tcontrol_t>  ("nreset",1, RESET_VHDL_NO);
    }
#endif
    
    {
      ALLOC1_INTERFACE_BEGIN("shifter", IN, SOUTH,_("Generalist interface"),_param->_nb_port);
      
      ALLOC1_SIGNAL_IN ( in_SHIFTER_DATA       ,"data"      ,Tdata_t     ,_param->_size_data);
      if (_param->_shift_value == 0)
      ALLOC1_SIGNAL_IN ( in_SHIFTER_SHIFT      ,"shift"     ,Tshift_t    ,_param->_size_shift);
      if (_param->_direction == external_direction)
      ALLOC1_SIGNAL_IN ( in_SHIFTER_DIRECTION  ,"direction" ,Tdirection_t,1);
      if (_param->_rotate == external_rotate)
      ALLOC1_SIGNAL_IN ( in_SHIFTER_TYPE       ,"type"      ,Ttype_t     ,1);
      if (_param->_carry == external_carry)
      ALLOC1_SIGNAL_IN ( in_SHIFTER_CARRY      ,"carry"     ,Tcarry_t    ,1);
      if (_param->_carry == external_completion)
      {
      if (_param->_type_completion_bool == true)
        {
      ALLOC1_SIGNAL_IN ( in_SHIFTER_CARRY_IN   ,"carry_in"  ,Tcontrol_t  ,1);
        }
      else
        {
      ALLOC1_SIGNAL_IN ( in_SHIFTER_COMPLETION ,"completion",Tdata_t     ,_param->_size_data_completion);
        }
      }
      ALLOC1_SIGNAL_OUT(out_SHIFTER_DATA       ,"data"      ,Tdata_t     ,_param->_size_data);
      
      ALLOC1_INTERFACE_END(_param->_nb_port);
    }
    
#ifdef POSITION
    if (usage_is_set(_usage,USE_POSITION))
      _component->generate_file();
#endif

  };
  
}; // end namespace shifter
}; // end namespace generic
}; // end namespace behavioural
}; // end namespace morpheo              
