#!/bin/bash

function genFile_name()
{
    bank=$1;
    read=$2;
    write=$3;
    file_out="-regfile_${bank}x_${read}r_${write}w";

    echo "${file_out}";
}

function genFile_cfg()
{
    file_in=$1;
    file_out=$2;
    ext=$3;
    bank=$4;
    read=$5;
    write=$6;

    sed s/@name/${file_out}/ ${file_in}.${ext} |
    sed s/@bank/${bank}/ |
    sed s/@read/${read}/ |
    sed s/@write/${write}/ > ${file_out}.${ext};
}

function genFile_sim()
{
    file_in=$1;
    file_out=$2;
    ext=$3;
    file=$4;
    sed s/@file/${file}/ ${file_in}.${ext} > ${file_out}.${ext};
}

function genTest()
{
    file_cfg="Instance_x01_w04_02"
    file_sim="Dhrystone-x01_w04_02"
    ext="cfg"
    banks=( 1 
            2 2 2
            4 4 4
            8 8 8
            16 16
            32);
    reads=( 12      # bank : 1 
            10 8 6  # bank : 2 
            8 6 4   # bank : 3 
            4 2 1   # bank : 6 
            2 1     # bank : 12
            1);     # bank : 48
    writes=(6       # bank : 1 
            5 4 3   # bank : 2 
            4 3 2   # bank : 3 
            2 1 1   # bank : 6 
            1 1     # bank : 12
            1);     # bank : 48
    nb_cfg=${#banks[*]};
    
    while test $nb_cfg -ge 1; do
	nb_cfg=$(($nb_cfg-1));
	
	bank=${banks[$nb_cfg]};
	read=${reads[$nb_cfg]};
	write=${writes[$nb_cfg]};
	
	postfix=$(genFile_name $bank $read $write);
	echo ${file_cfg}${postfix};
	genFile_cfg $file_cfg ${file_cfg}${postfix} $ext $bank $read $write;
	genFile_sim $file_sim ${file_sim}${postfix} $ext ${file_cfg}${postfix}.${ext};
    done;
}

genTest ${*};