#ifndef morpheo_behavioural_configuration_Parameter_definition_h
#define morpheo_behavioural_configuration_Parameter_definition_h

/*
 * $Id: Parameter_definition.h 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/XML.h"
#include "Common/include/ErrorMorpheo.h"
#include "Common/include/ToString.h"
#include "Common/include/Debug.h"

#include <iostream>

namespace morpheo {
namespace behavioural {
namespace configuration {


  class Parameter_definition 
  {
    // -----[ fields ]----------------------------------------------------
    // Constant
  public   : const std::string _name       ;
  public   : const std::string _min        ;
  public   : const std::string _max        ;
  public   : const std::string _step       ;
  public   : const std::string _default    ;
  public   : const std::string _level      ;
  public   : const std::string _description;

    // -----[ methods ]---------------------------------------------------
  public   :                      Parameter_definition  (std::string name         ,
                                                         std::string min          ,
                                                         std::string max          ,
                                                         std::string step         ,
                                                         std::string value_default,
                                                         std::string level        ,
                                                         std::string description  );
  public   :                     ~Parameter_definition ();

  public   : void                 test                 (std::string x);

  public   : XML                  toXML                (void);
  private  : std::string          print                (uint32_t depth);
  public   : friend std::ostream& operator<<           (std::ostream& output,
                                                        morpheo::behavioural::configuration::Parameter_definition & x);

  };

}; // end namespace configuration
}; // end namespace behavioural
}; // end namespace morpheo              

#endif
