/*
 * $Id: top_allocation.cpp 113 2009-04-14 18:39:12Z rosiere $
 *
 * [ Description ]
 * 
 * Test
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Write_unit/Write_unit/Execute_queue/SelfTest/include/top.h"
#include "Behavioural/include/Allocation.h"

void top::allocation (void)
{
  if (setlocale (LC_ALL, "") == NULL)
    msgWarning(_("setlocale ko.\n"));

  try 
    {
      _param->test();
    }
  catch (morpheo::ErrorMorpheo & error)
    {
      msgError(_("<%s> : %s"),name.c_str(),error.what());
      return;
    }
  catch (...)
    {
      msgError(_("<%s> : This test must generate a error"),name.c_str());
      exit (EXIT_FAILURE);
    }

  _usage = USE_ALL;
//   _usage = usage_unset(_usage,USE_SYSTEMC              );
//   _usage = usage_unset(_usage,USE_VHDL                 );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH       );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH_ASSERT);
//   _usage = usage_unset(_usage,USE_POSITION             );
//   _usage = usage_unset(_usage,USE_STATISTICS           );
//   _usage = usage_unset(_usage,USE_INFORMATION          );

#ifdef STATISTICS
  if (usage_is_set(_usage,USE_STATISTICS))
  _param_stat = new morpheo::behavioural::Parameters_Statistics (5,CYCLE_MAX);
#endif

  component = new Execute_queue 
    (name.c_str(),
#ifdef STATISTICS
     _param_stat,
#endif
     _param,
     _usage
     );
  
#ifdef SYSTEMC
  if (usage_is_set(_usage,USE_SYSTEMC))
    {
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  msgInformation(_("<%s> : Create signal.\n"),name.c_str());

  in_CLOCK  = new sc_clock ("clock", TIME_PERIOD, TIME_UNIT, 0.5); //name,period,time_unit,duty_cycle

  ALLOC0_SC_SIGNAL( in_NRESET        ," in_NRESET        ",Tcontrol_t);

  ALLOC0_SC_SIGNAL( in_EXECUTE_QUEUE_IN_VAL           ," in_EXECUTE_QUEUE_IN_VAL"           , Tcontrol_t        );
  ALLOC0_SC_SIGNAL(out_EXECUTE_QUEUE_IN_ACK           ,"out_EXECUTE_QUEUE_IN_ACK"           , Tcontrol_t        );
  ALLOC0_SC_SIGNAL( in_EXECUTE_QUEUE_IN_CONTEXT_ID    ," in_EXECUTE_QUEUE_IN_CONTEXT_ID"    , Tcontext_t        );
  ALLOC0_SC_SIGNAL( in_EXECUTE_QUEUE_IN_FRONT_END_ID  ," in_EXECUTE_QUEUE_IN_FRONT_END_ID"  , Tcontext_t        );
  ALLOC0_SC_SIGNAL( in_EXECUTE_QUEUE_IN_OOO_ENGINE_ID ," in_EXECUTE_QUEUE_IN_OOO_ENGINE_ID" , Tcontext_t        );
  ALLOC0_SC_SIGNAL( in_EXECUTE_QUEUE_IN_PACKET_ID     ," in_EXECUTE_QUEUE_IN_PACKET_ID"     , Tpacket_t         );
//ALLOC0_SC_SIGNAL( in_EXECUTE_QUEUE_IN_OPERATION     ," in_EXECUTE_QUEUE_IN_OPERATION"     , Toperation_t      );
//ALLOC0_SC_SIGNAL( in_EXECUTE_QUEUE_IN_TYPE          ," in_EXECUTE_QUEUE_IN_TYPE"          , Ttype_t           );
  ALLOC0_SC_SIGNAL( in_EXECUTE_QUEUE_IN_FLAGS         ," in_EXECUTE_QUEUE_IN_FLAGS"         , Tspecial_data_t   );
  ALLOC0_SC_SIGNAL( in_EXECUTE_QUEUE_IN_EXCEPTION     ," in_EXECUTE_QUEUE_IN_EXCEPTION"     , Texception_t      );
  ALLOC0_SC_SIGNAL( in_EXECUTE_QUEUE_IN_NO_SEQUENCE   ," in_EXECUTE_QUEUE_IN_NO_SEQUENCE"   , Tcontrol_t        );
  ALLOC0_SC_SIGNAL( in_EXECUTE_QUEUE_IN_ADDRESS       ," in_EXECUTE_QUEUE_IN_ADDRESS"       , Taddress_t        );
  ALLOC0_SC_SIGNAL( in_EXECUTE_QUEUE_IN_DATA          ," in_EXECUTE_QUEUE_IN_DATA"          , Tgeneral_data_t   );
  ALLOC0_SC_SIGNAL(out_EXECUTE_QUEUE_OUT_VAL          ,"out_EXECUTE_QUEUE_OUT_VAL"          , Tcontrol_t        );
  ALLOC0_SC_SIGNAL( in_EXECUTE_QUEUE_OUT_ACK          ," in_EXECUTE_QUEUE_OUT_ACK"          , Tcontrol_t        );
  ALLOC0_SC_SIGNAL(out_EXECUTE_QUEUE_OUT_CONTEXT_ID   ,"out_EXECUTE_QUEUE_OUT_CONTEXT_ID"   , Tcontext_t        );
  ALLOC0_SC_SIGNAL(out_EXECUTE_QUEUE_OUT_FRONT_END_ID ,"out_EXECUTE_QUEUE_OUT_FRONT_END_ID" , Tcontext_t        );
  ALLOC0_SC_SIGNAL(out_EXECUTE_QUEUE_OUT_OOO_ENGINE_ID,"out_EXECUTE_QUEUE_OUT_OOO_ENGINE_ID", Tcontext_t        );
  ALLOC0_SC_SIGNAL(out_EXECUTE_QUEUE_OUT_PACKET_ID    ,"out_EXECUTE_QUEUE_OUT_PACKET_ID"    , Tpacket_t         );
//ALLOC0_SC_SIGNAL(out_EXECUTE_QUEUE_OUT_OPERATION    ,"out_EXECUTE_QUEUE_OUT_OPERATION"    , Toperation_t      );
//ALLOC0_SC_SIGNAL(out_EXECUTE_QUEUE_OUT_TYPE         ,"out_EXECUTE_QUEUE_OUT_TYPE"         , Ttype_t           );
  ALLOC0_SC_SIGNAL(out_EXECUTE_QUEUE_OUT_FLAGS        ,"out_EXECUTE_QUEUE_OUT_FLAGS"        , Tspecial_data_t   );
  ALLOC0_SC_SIGNAL(out_EXECUTE_QUEUE_OUT_EXCEPTION    ,"out_EXECUTE_QUEUE_OUT_EXCEPTION"    , Texception_t      );
  ALLOC0_SC_SIGNAL(out_EXECUTE_QUEUE_OUT_NO_SEQUENCE  ,"out_EXECUTE_QUEUE_OUT_NO_SEQUENCE"  , Tcontrol_t        );
  ALLOC0_SC_SIGNAL(out_EXECUTE_QUEUE_OUT_ADDRESS      ,"out_EXECUTE_QUEUE_OUT_ADDRESS"      , Taddress_t        );
  ALLOC0_SC_SIGNAL(out_EXECUTE_QUEUE_OUT_DATA         ,"out_EXECUTE_QUEUE_OUT_DATA"         , Tgeneral_data_t   );
  
  /********************************************************
   * Instanciation
   ********************************************************/
  
  msgInformation(_("<%s> : Instanciation of _Execute_queue.\n"),name.c_str());

  INSTANCE0_SC_SIGNAL(component, in_CLOCK         );
  INSTANCE0_SC_SIGNAL(component, in_NRESET        );

  INSTANCE0_SC_SIGNAL(component,  in_EXECUTE_QUEUE_IN_VAL           );
  INSTANCE0_SC_SIGNAL(component, out_EXECUTE_QUEUE_IN_ACK           );
  if (_param->_have_port_context_id)
  INSTANCE0_SC_SIGNAL(component,  in_EXECUTE_QUEUE_IN_CONTEXT_ID    );
  if (_param->_have_port_front_end_id)
  INSTANCE0_SC_SIGNAL(component,  in_EXECUTE_QUEUE_IN_FRONT_END_ID  );
  if (_param->_have_port_ooo_engine_id)
  INSTANCE0_SC_SIGNAL(component,  in_EXECUTE_QUEUE_IN_OOO_ENGINE_ID );
  if (_param->_have_port_rob_ptr)
  INSTANCE0_SC_SIGNAL(component,  in_EXECUTE_QUEUE_IN_PACKET_ID     );
//INSTANCE0_SC_SIGNAL(component,  in_EXECUTE_QUEUE_IN_OPERATION     );
//INSTANCE0_SC_SIGNAL(component,  in_EXECUTE_QUEUE_IN_TYPE          );
  INSTANCE0_SC_SIGNAL(component,  in_EXECUTE_QUEUE_IN_FLAGS         );
  INSTANCE0_SC_SIGNAL(component,  in_EXECUTE_QUEUE_IN_EXCEPTION     );
  INSTANCE0_SC_SIGNAL(component,  in_EXECUTE_QUEUE_IN_NO_SEQUENCE   );
  INSTANCE0_SC_SIGNAL(component,  in_EXECUTE_QUEUE_IN_ADDRESS       );
  INSTANCE0_SC_SIGNAL(component,  in_EXECUTE_QUEUE_IN_DATA          );

  INSTANCE0_SC_SIGNAL(component, out_EXECUTE_QUEUE_OUT_VAL          );
  INSTANCE0_SC_SIGNAL(component,  in_EXECUTE_QUEUE_OUT_ACK          );
  if (_param->_have_port_context_id)
  INSTANCE0_SC_SIGNAL(component, out_EXECUTE_QUEUE_OUT_CONTEXT_ID   );
  if (_param->_have_port_front_end_id)
  INSTANCE0_SC_SIGNAL(component, out_EXECUTE_QUEUE_OUT_FRONT_END_ID );
  if (_param->_have_port_ooo_engine_id)
  INSTANCE0_SC_SIGNAL(component, out_EXECUTE_QUEUE_OUT_OOO_ENGINE_ID);
  if (_param->_have_port_rob_ptr)
  INSTANCE0_SC_SIGNAL(component, out_EXECUTE_QUEUE_OUT_PACKET_ID    );
//INSTANCE0_SC_SIGNAL(component, out_EXECUTE_QUEUE_OUT_OPERATION    );
//INSTANCE0_SC_SIGNAL(component, out_EXECUTE_QUEUE_OUT_TYPE         );
  INSTANCE0_SC_SIGNAL(component, out_EXECUTE_QUEUE_OUT_FLAGS        );
  INSTANCE0_SC_SIGNAL(component, out_EXECUTE_QUEUE_OUT_EXCEPTION    );
  INSTANCE0_SC_SIGNAL(component, out_EXECUTE_QUEUE_OUT_NO_SEQUENCE  );
  INSTANCE0_SC_SIGNAL(component, out_EXECUTE_QUEUE_OUT_ADDRESS      );
  INSTANCE0_SC_SIGNAL(component, out_EXECUTE_QUEUE_OUT_DATA         );
    }
#endif
}
