#ifndef morpheo_behavioural_core_multi_execute_loop_execute_loop_multi_write_unit_write_unit_Parameters_h
#define morpheo_behavioural_core_multi_execute_loop_execute_loop_multi_write_unit_write_unit_Parameters_h

/*
 * $Id: Parameters.h 115 2009-04-20 21:29:17Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Common/include/Debug.h"
#include "Behavioural/include/Parameters.h"
#include <math.h>

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Write_unit/Write_unit/Write_queue/include/Parameters.h"
#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Write_unit/Write_unit/Execute_queue/include/Parameters.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_write_unit {
namespace write_unit {


  class Parameters : public morpheo::behavioural::Parameters
  {
    //-----[ fields ]------------------------------------------------------------
  public : uint32_t              _size_write_queue             ;
  public : uint32_t              _size_execute_queue           ;
  public : uint32_t              _nb_context                   ;
  public : uint32_t              _nb_front_end                 ;
  public : uint32_t              _nb_ooo_engine                ;
  public : uint32_t              _nb_packet                    ;
//public : uint32_t              _size_general_data            ;
  public : uint32_t              _nb_general_register          ;
//public : uint32_t              _size_special_data            ;
  public : uint32_t              _nb_special_register          ;
  public : uint32_t              _nb_bypass_write              ;
  public : write_queue::Twrite_queue_scheme_t _write_queue_scheme           ;

  public : uint32_t              _nb_gpr_write                 ;
  public : uint32_t              _nb_spr_write                 ;
			        
//public : uint32_t              _size_context_id              ;
//public : uint32_t              _size_front_end_id            ;
//public : uint32_t              _size_ooo_engine_id           ;
//public : uint32_t              _size_packet_id               ;
//public : uint32_t              _size_general_register        ;
//public : uint32_t              _size_special_register        ;
			        
  public : bool                  _have_component_execute_queue ;
//public : bool                  _have_port_context_id         ;
//public : bool                  _have_port_front_end_id       ;
//public : bool                  _have_port_ooo_engine_id      ;
//public : bool                  _have_port_packet_id          ;

  public : morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_write_unit::write_unit::write_queue  ::Parameters * _param_write_queue;
  public : morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_write_unit::write_unit::execute_queue::Parameters * _param_execute_queue;

    //-----[ methods ]-----------------------------------------------------------
  public : Parameters  (uint32_t              size_write_queue   ,
			uint32_t              size_execute_queue ,
			uint32_t              nb_context         ,
			uint32_t              nb_front_end       ,
			uint32_t              nb_ooo_engine      ,
			uint32_t              nb_packet          ,
			uint32_t              size_general_data  ,
			uint32_t              nb_general_register,
			uint32_t              size_special_data  ,
			uint32_t              nb_special_register,
			uint32_t              nb_bypass_write    ,
			write_queue::Twrite_queue_scheme_t write_queue_scheme ,
                        bool                  is_toplevel=false);
//public : Parameters  (Parameters & param) ;
  public : ~Parameters () ;

  public :        void            copy       (void);

  public :        Parameters_test msg_error  (void);

  public :        std::string   print      (uint32_t depth);
  public : friend std::ostream& operator<< (std::ostream& output_stream,
					    morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_write_unit::write_unit::Parameters & x);
  };

}; // end namespace write_unit
}; // end namespace multi_write_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
