#ifdef SYSTEMC
/*
 * $Id: Execution_unit_to_Write_unit_transition.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Network/Execution_unit_to_Write_unit/include/Execution_unit_to_Write_unit.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace network {
namespace execution_unit_to_write_unit {


#undef  FUNCTION
#define FUNCTION "Execution_unit_to_Write_unit::transition"
  void Execution_unit_to_Write_unit::transition (void)
  {
    log_printf(FUNC,Execution_unit_to_Write_unit,FUNCTION,"Begin");

    if (PORT_READ(in_NRESET) == 0)
      {
	// Flush routing_table
	for (uint32_t x=0; x<_param->_nb_execute_unit; x++)
	  for (uint32_t y=0; y<_param->_nb_execute_unit_port[x]; y++)
	    for (uint32_t j=0; j<_param->_nb_thread; j++)
	      _destination [x][y][j].clear();
	
	// Fill routing table
	for (uint32_t x=0; x<_param->_nb_execute_unit; x++)
	  for (uint32_t y=0; y<_param->_nb_execute_unit_port[x]; y++)
	    for (uint32_t j=0; j<_param->_nb_write_unit; j++)
	      // Test if link between src and dest
	      if (_param->_table_routing [x][y][j])
		// Test the thread accepted by the execute_unit
		for (uint32_t k=0; k<_param->_nb_thread; k++)
		  if (_param->_table_thread[j][k])
		    // push_back == minor have a better priority
		    _destination [x][y][k].push_back(j);
      }
    else
      {
	if (_param->_priority == PRIORITY_ROUND_ROBIN)
	  for (uint32_t x=0; x<_param->_nb_execute_unit; x++)
	    for (uint32_t y=0; y<_param->_nb_execute_unit_port[x]; y++)
	      for (uint32_t j=0; j<_param->_nb_thread; j++)
		if (_destination [x][y][j].size() > 1)
		  {
		    // Head queue became the Tail queue
		    _destination [x][y][j].push_back(_destination [x][y][j].front());
		    _destination [x][y][j].pop_front();
		  }
      }
    
    
#if (DEBUG >= DEBUG_TRACE)
    // Print
    log_printf(TRACE,Read_unit_to_Execution_unit,FUNCTION,"Routing Table");
    for (uint32_t x=0; x<_param->_nb_execute_unit; x++)
      for (uint32_t y=0; y<_param->_nb_execute_unit_port[x]; y++)
	for (uint32_t j=0; j<_param->_nb_thread; j++)
	  for (std::list<uint32_t>::iterator k=_destination[x][y][j].begin();
	       k != _destination[x][y][j].end();
	       k++)
	    log_printf(TRACE,Read_unit_to_Execution_unit,FUNCTION,"  * Execute_unit [%d][%d], send at the write_unit [%d], the operation of thread [%d].",x,y,*k,j);
#endif

#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
    end_cycle ();
#endif

    log_printf(FUNC,Execution_unit_to_Write_unit,FUNCTION,"End");
  };

}; // end namespace execution_unit_to_write_unit
}; // end namespace network
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
