#ifndef morpheo_behavioural_core_multi_front_end_front_end_ifetch_unit_ifetch_queue_Types_h
#define morpheo_behavioural_core_multi_front_end_front_end_ifetch_unit_ifetch_queue_Types_h

/*
 * $Id: Types.h 136 2009-10-20 18:52:15Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Types.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace ifetch_unit {
namespace ifetch_queue {

  typedef enum 
    {
       IFETCH_QUEUE_SCHEME_NO_ASSOC   // Read only head
      ,IFETCH_QUEUE_SCHEME_FULL_ASSOC // Scan all slot
    } Tifetch_queue_scheme_t;

  typedef enum
    {
      IFETCH_QUEUE_STATE_EMPTY         ,  // slot is empty
//    IFETCH_QUEUE_STATE_WAIT_REQ      ,  // slot is allocated               - wait request to   cache
      IFETCH_QUEUE_STATE_WAIT_RSP      ,  // slot have send a request        - wait respons from cache
      IFETCH_QUEUE_STATE_HAVE_RSP      ,  // slot have a bloc of instruction - wait accept by decod
      IFETCH_QUEUE_STATE_ERROR_WAIT_RSP   // A event occure -> flush the queue but, ack rsp
    } ifetch_queue_state_t;

#define IFETCH_QUEUE_STATE_SIZE 2

  class ifetch_queue_entry_t
  {
  public : ifetch_queue_state_t   _state                      ;
  public : Tinstruction_t       * _instruction                ;
  public : Tcontrol_t           * _instruction_enable         ;
  public : Tgeneral_address_t     _address                    ;
  public : Tinst_ifetch_ptr_t     _inst_ifetch_ptr            ;
  public : Tbranch_state_t        _branch_state               ;
  public : Tprediction_ptr_t      _branch_update_prediction_id;
  public : Texception_t           _exception                  ;
    
  public : ifetch_queue_entry_t (uint32_t nb_instruction)
    {
      _instruction        = new Tinstruction_t [nb_instruction];
      _instruction_enable = new Tcontrol_t     [nb_instruction];
    }

  public : ~ifetch_queue_entry_t (void)
    {
      delete [] _instruction       ;
      delete [] _instruction_enable;
    }
  };

}; // end namespace ifetch_queue
}; // end namespace ifetch_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core
}; // end namespace behavioural

  template<> inline std::string toString<morpheo::behavioural::core::multi_front_end::front_end::ifetch_unit::ifetch_queue::Tifetch_queue_scheme_t>(const morpheo::behavioural::core::multi_front_end::front_end::ifetch_unit::ifetch_queue::Tifetch_queue_scheme_t& x)
  {
    switch (x)
      {
      case morpheo::behavioural::core::multi_front_end::front_end::ifetch_unit::ifetch_queue::IFETCH_QUEUE_SCHEME_NO_ASSOC   : return "no_assoc"  ; break;
      case morpheo::behavioural::core::multi_front_end::front_end::ifetch_unit::ifetch_queue::IFETCH_QUEUE_SCHEME_FULL_ASSOC : return "full_assoc"; break;
      default : return ""; break;
      }
  };

  template<> inline morpheo::behavioural::core::multi_front_end::front_end::ifetch_unit::ifetch_queue::Tifetch_queue_scheme_t fromString<morpheo::behavioural::core::multi_front_end::front_end::ifetch_unit::ifetch_queue::Tifetch_queue_scheme_t>(const std::string& x)
  {
    if ( (x.compare(toString(static_cast<uint32_t>(morpheo::behavioural::core::multi_front_end::front_end::ifetch_unit::ifetch_queue::IFETCH_QUEUE_SCHEME_NO_ASSOC  ))) == 0) or
         (x.compare("no_assoc")   == 0))
      return morpheo::behavioural::core::multi_front_end::front_end::ifetch_unit::ifetch_queue::IFETCH_QUEUE_SCHEME_NO_ASSOC;
    if ( (x.compare(toString(static_cast<uint32_t>(morpheo::behavioural::core::multi_front_end::front_end::ifetch_unit::ifetch_queue::IFETCH_QUEUE_SCHEME_FULL_ASSOC))) == 0) or
         (x.compare("full_assoc") == 0))
      return morpheo::behavioural::core::multi_front_end::front_end::ifetch_unit::ifetch_queue::IFETCH_QUEUE_SCHEME_FULL_ASSOC;
    
    throw (ErrorMorpheo ("<fromString> : Unknow string : \""+x+"\""));
  };
  
  template<> inline std::string toString<morpheo::behavioural::core::multi_front_end::front_end::ifetch_unit::ifetch_queue::ifetch_queue_state_t>(const morpheo::behavioural::core::multi_front_end::front_end::ifetch_unit::ifetch_queue::ifetch_queue_state_t& x)
  {
    switch (x)
      {
      case morpheo::behavioural::core::multi_front_end::front_end::ifetch_unit::ifetch_queue::IFETCH_QUEUE_STATE_EMPTY          : return "empty"         ; break;
//    case morpheo::behavioural::core::multi_front_end::front_end::ifetch_unit::ifetch_queue::IFETCH_QUEUE_STATE_WAIT_REQ       : return "wait_req"      ; break;
      case morpheo::behavioural::core::multi_front_end::front_end::ifetch_unit::ifetch_queue::IFETCH_QUEUE_STATE_WAIT_RSP       : return "wait_rsp"      ; break;
      case morpheo::behavioural::core::multi_front_end::front_end::ifetch_unit::ifetch_queue::IFETCH_QUEUE_STATE_HAVE_RSP       : return "have_rsp"      ; break;
      case morpheo::behavioural::core::multi_front_end::front_end::ifetch_unit::ifetch_queue::IFETCH_QUEUE_STATE_ERROR_WAIT_RSP : return "error_wait_rsp"; break;
      default    : return ""      ; break;
      }
  };


}; // end namespace morpheo              
#endif
