/*
 * $Id: Branch_Target_Buffer_Register.cpp 132 2009-07-11 16:39:35Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Branch_Target_Buffer/Branch_Target_Buffer_Register/include/Branch_Target_Buffer_Register.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace branch_target_buffer {
namespace branch_target_buffer_register {

#undef  FUNCTION
#define FUNCTION "Branch_Target_Buffer_Register::Branch_Target_Buffer_Register"
  Branch_Target_Buffer_Register::Branch_Target_Buffer_Register 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   string name,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::branch_target_buffer::branch_target_buffer_register::Parameters * param,
   morpheo::behavioural::Tusage_t usage
   ):
    _name  (name)
   ,_param (param)
   ,_usage (usage)
  {
    log_printf(FUNC,Branch_Target_Buffer_Register,FUNCTION,"Begin");

// #if DEBUG_Branch_Target_Buffer_Register == true
//     log_printf(INFO,Branch_Target_Buffer_Register,FUNCTION,_("<%s> Parameters"),_name.c_str());

//     std::cout << *param << std::endl;
// #endif    

    log_printf(INFO,Branch_Target_Buffer_Register,FUNCTION,"Allocation");

    allocation (
#ifdef STATISTICS
		param_statistics
#endif
		);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {	
	log_printf(INFO,Branch_Target_Buffer_Register,FUNCTION,"Allocation of statistics");

	statistics_allocation(param_statistics);
      }
#endif

#ifdef VHDL
    if (usage_is_set(_usage,USE_VHDL))
      {
	// generate the vhdl
	log_printf(INFO,Branch_Target_Buffer_Register,FUNCTION,"Generate the vhdl");
	
	vhdl();
      }
#endif

#ifdef SYSTEMC
    if (usage_is_set(_usage,USE_SYSTEMC))
      {
#ifdef SYSTEMCASS_SPECIFIC
        constant();
#else
	log_printf(INFO,Branch_Target_Buffer_Register,FUNCTION,"Method - constant");

	SC_METHOD (constant);
// 	dont_initialize ();
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    
#endif

	log_printf(INFO,Branch_Target_Buffer_Register,FUNCTION,"Method - transition");

	SC_METHOD (transition);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).pos();
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    

	log_printf(INFO,Branch_Target_Buffer_Register,FUNCTION,"Method - genMealy_predict");

	SC_METHOD (genMealy_predict);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).neg() // use internal register
		  << (*(in_NRESET));
	for (uint32_t i=0; i<_param->_nb_inst_predict; i++)
	  {
// 	    sensitive << (*(in_PREDICT_VAL        [i]))
	    sensitive << (*(in_PREDICT_ADDRESS    [i]));
	    if (_param->_have_port_context_id)
	    sensitive << (*(in_PREDICT_CONTEXT_ID [i]));
	  }

// # ifdef SYSTEMCASS_SPECIFIC
// 	// List dependency information
// 	for (uint32_t i=0; i<_param->_nb_inst_predict; i++)
// 	  for (uint32_t j=0; j<_param->_associativity; j++)
// 	    {
// 	      (*(out_PREDICT_HIT          [i][j])) (*(in_PREDICT_ADDRESS    [i]));
// 	      if (_param->_have_port_context_id)
// 	      (*(out_PREDICT_HIT          [i][j])) (*(in_PREDICT_CONTEXT_ID [i]));

// 	      (*(out_PREDICT_ADDRESS_SRC  [i][j])) (*(in_PREDICT_ADDRESS    [i]));
// 	      if (_param->_have_port_context_id)
// 	      (*(out_PREDICT_ADDRESS_SRC  [i][j])) (*(in_PREDICT_CONTEXT_ID [i]));

// 	      (*(out_PREDICT_ADDRESS_DEST [i][j])) (*(in_PREDICT_ADDRESS    [i]));
// 	      if (_param->_have_port_context_id)
// 	      (*(out_PREDICT_ADDRESS_DEST [i][j])) (*(in_PREDICT_CONTEXT_ID [i]));

// 	      (*(out_PREDICT_CONDITION    [i][j])) (*(in_PREDICT_ADDRESS    [i]));
// 	      if (_param->_have_port_context_id)
// 	      (*(out_PREDICT_CONDITION    [i][j])) (*(in_PREDICT_CONTEXT_ID [i]));

// 	      (*(out_PREDICT_LAST_TAKE    [i][j])) (*(in_PREDICT_ADDRESS    [i]));
// 	      if (_param->_have_port_context_id)
// 	      (*(out_PREDICT_LAST_TAKE    [i][j])) (*(in_PREDICT_CONTEXT_ID [i]));

// 	      (*(out_PREDICT_IS_ACCURATE  [i][j])) (*(in_PREDICT_ADDRESS    [i]));
// 	      if (_param->_have_port_context_id)
// 	      (*(out_PREDICT_IS_ACCURATE  [i][j])) (*(in_PREDICT_CONTEXT_ID [i]));
// 	  }
// # endif

	if (_param->_have_port_victim)
	  {
	log_printf(INFO,Branch_Target_Buffer_Register,FUNCTION,"Method - genMealy_decod");

	SC_METHOD (genMealy_decod);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).neg() // use internal register
		  << (*(in_NRESET));
	for (uint32_t i=0; i<_param->_nb_inst_decod; i++)
	  {
	    sensitive << (*(in_DECOD_VAL         [i]))
		      << (*(in_DECOD_ADDRESS_SRC [i]));
	    if (_param->_have_port_context_id)
	    sensitive << (*(in_DECOD_CONTEXT_ID  [i]));
	  }

// # ifdef SYSTEMCASS_SPECIFIC
// 	// List dependency information
// 	for (uint32_t i=0; i<_param->_nb_inst_decod; i++)
// 	  {
// 	    (*(out_DECOD_HIT [i])) (*(in_DECOD_VAL         [i]));
// 	    (*(out_DECOD_HIT [i])) (*(in_DECOD_ADDRESS_SRC [i]));
// 	    if (_param->_have_port_context_id)
// 	    (*(out_DECOD_HIT [i])) (*(in_DECOD_CONTEXT_ID  [i]));

// 	    (*(out_DECOD_HIT_INDEX [i])) (*(in_DECOD_VAL         [i]));
// 	    (*(out_DECOD_HIT_INDEX [i])) (*(in_DECOD_ADDRESS_SRC [i]));
// 	    if (_param->_have_port_context_id)
// 	    (*(out_DECOD_HIT_INDEX [i])) (*(in_DECOD_CONTEXT_ID  [i]));
// 	  }
// #endif
 	  }

	if (_param->_have_port_victim)
	  {
	log_printf(INFO,Branch_Target_Buffer_Register,FUNCTION,"Method - genMealy_update");

	SC_METHOD (genMealy_update);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).neg() // use internal register
		  << (*(in_NRESET));
	for (uint32_t i=0; i<_param->_nb_inst_update; i++)
	  {
	    sensitive << (*(in_UPDATE_VAL         [i]))
		      << (*(in_UPDATE_ADDRESS_SRC [i]));
	    if (_param->_have_port_context_id)
	    sensitive << (*(in_UPDATE_CONTEXT_ID  [i]));
	  }

// # ifdef SYSTEMCASS_SPECIFIC
// 	// List dependency information
// 	for (uint32_t i=0; i<_param->_nb_inst_update; i++)
// 	  {
// 	    (*(out_UPDATE_HIT [i])) (*(in_UPDATE_VAL         [i]));
// 	    (*(out_UPDATE_HIT [i])) (*(in_UPDATE_ADDRESS_SRC [i]));
// 	    if (_param->_have_port_context_id)
// 	    (*(out_UPDATE_HIT [i])) (*(in_UPDATE_CONTEXT_ID  [i]));

// 	    (*(out_UPDATE_HIT_INDEX [i])) (*(in_UPDATE_VAL         [i]));
// 	    (*(out_UPDATE_HIT_INDEX [i])) (*(in_UPDATE_ADDRESS_SRC [i]));
// 	    if (_param->_have_port_context_id)
// 	    (*(out_UPDATE_HIT_INDEX [i])) (*(in_UPDATE_CONTEXT_ID  [i]));
// 	  }
// # endif
 	  }
#endif

      }
    log_printf(FUNC,Branch_Target_Buffer_Register,FUNCTION,"End");
  };
    
#undef  FUNCTION
#define FUNCTION "Branch_Target_Buffer_Register::~Branch_Target_Buffer_Register"
  Branch_Target_Buffer_Register::~Branch_Target_Buffer_Register (void)
  {
    log_printf(FUNC,Branch_Target_Buffer_Register,FUNCTION,"Begin");

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {
	statistics_deallocation();
      }
#endif

    log_printf(INFO,Branch_Target_Buffer_Register,FUNCTION,"Deallocation");
    deallocation ();
    log_printf(FUNC,Branch_Target_Buffer_Register,FUNCTION,"End");
  };

}; // end namespace branch_target_buffer_register
}; // end namespace branch_target_buffer
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core
}; // end namespace behavioural
}; // end namespace morpheo
