/*
 * $Id: Free_List_unit_allocation.cpp 123 2009-06-08 20:43:30Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Register_translation_unit/Free_List_unit/include/Free_List_unit.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace register_translation_unit {
namespace free_list_unit {



#undef  FUNCTION
#define FUNCTION "Free_List_unit::allocation"
  void Free_List_unit::allocation (
#ifdef STATISTICS
			       morpheo::behavioural::Parameters_Statistics * param_statistics
#else
			       void
#endif
			       )
  {
    log_printf(FUNC,Free_List_unit,FUNCTION,"Begin");

    _component   = new Component (_usage);

    Entity * entity = _component->set_entity (_name       
					      ,"Free_List_unit"
#ifdef POSITION
					      ,COMBINATORY 
#endif
					      );

    _interfaces = entity->set_interfaces();

    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

      Interface * interface = _interfaces->set_interface(""
#ifdef POSITION
							 ,IN
							 ,SOUTH,
							 _("Generalist interface")
#endif
							 );

     in_CLOCK        = interface->set_signal_clk              ("clock" ,1, CLOCK_VHDL_YES);
     in_NRESET       = interface->set_signal_in  <Tcontrol_t> ("nreset",1, RESET_VHDL_YES);

    // ~~~~~[ interface : "pop" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     {
       ALLOC1_INTERFACE_BEGIN("pop", IN, NORTH, _("New destination register"), _param->_nb_pop);

       ALLOC1_VALACK_IN ( in_POP_VAL        ,VAL);
       ALLOC1_VALACK_OUT(out_POP_ACK        ,ACK);
       ALLOC1_SIGNAL_IN ( in_POP_GPR_VAL    ,"gpr_val"    ,Tcontrol_t        ,1                             );
       ALLOC1_SIGNAL_OUT(out_POP_GPR_NUM_REG,"gpr_num_reg",Tgeneral_address_t,_param->_size_general_register);
       ALLOC1_SIGNAL_IN ( in_POP_SPR_VAL    ,"spr_val"    ,Tcontrol_t        ,1                             );
       ALLOC1_SIGNAL_OUT(out_POP_SPR_NUM_REG,"spr_num_reg",Tspecial_address_t,_param->_size_special_register);

       ALLOC1_INTERFACE_END(_param->_nb_pop);
     }

    // ~~~~~[ interface : "push_gpr" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     {
       ALLOC1_INTERFACE_BEGIN("push_gpr", IN, NORTH, _("General register free"), _param->_nb_push);

       ALLOC1_VALACK_IN ( in_PUSH_GPR_VAL    ,VAL);
       ALLOC1_VALACK_OUT(out_PUSH_GPR_ACK    ,ACK);
       ALLOC1_SIGNAL_IN ( in_PUSH_GPR_NUM_REG,"num_reg",Tgeneral_address_t,_param->_size_general_register);

       ALLOC1_INTERFACE_END(_param->_nb_push);
     }

    // ~~~~~[ interface : "push_spr" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     {
       ALLOC1_INTERFACE_BEGIN("push_spr", IN, NORTH, _("General register free"), _param->_nb_push);

       ALLOC1_VALACK_IN ( in_PUSH_SPR_VAL    ,VAL);
       ALLOC1_VALACK_OUT(out_PUSH_SPR_ACK    ,ACK);
       ALLOC1_SIGNAL_IN ( in_PUSH_SPR_NUM_REG,"num_reg",Tspecial_address_t,_param->_size_special_register);

       ALLOC1_INTERFACE_END(_param->_nb_push);
     }

    // ~~~~~[ interface : "info" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#ifdef DEBUG_TEST
     {
       ALLOC0_INTERFACE_BEGIN("info",OUT, NORTH, _("Information"));

       ALLOC0_SIGNAL_OUT(out_INFO_NB_GPR_FREE,"nb_gpr_free",uint32_t,_param->_size_general_register+1);
       ALLOC0_SIGNAL_OUT(out_INFO_NB_SPR_FREE,"nb_spr_free",uint32_t,_param->_size_special_register+1);

       ALLOC0_INTERFACE_END();
     }
#endif

     if (usage_is_set(_usage,USE_SYSTEMC))
       {
     ALLOC1(_gpr_list,std::list<uint32_t>,_param->_nb_bank);
     ALLOC1(_spr_list,std::list<uint32_t>,_param->_nb_bank);

     ALLOC1(internal_POP_ACK      ,Tcontrol_t,_param->_nb_pop);
     ALLOC1(internal_POP_GPR_BANK ,uint32_t  ,_param->_nb_pop);
     ALLOC1(internal_POP_SPR_BANK ,uint32_t  ,_param->_nb_pop);

     ALLOC1(internal_PUSH_GPR_ACK ,Tcontrol_t,_param->_nb_push);
     ALLOC1(internal_PUSH_SPR_ACK ,Tcontrol_t,_param->_nb_push);
     ALLOC1(internal_PUSH_GPR_BANK,uint32_t  ,_param->_nb_push);
     ALLOC1(internal_PUSH_SPR_BANK,uint32_t  ,_param->_nb_push);
       }

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
    _priority_gpr = new generic::priority::Priority (_name+"_priority_gpr",
						     _param->_priority,
						     _param->_nb_bank,
						     _param->_nb_bank);

    _priority_spr = new generic::priority::Priority (_name+"_priority_spr",
						     _param->_priority,
						     _param->_nb_bank,
						     _param->_nb_bank);

#ifdef POSITION
     if (usage_is_set(_usage,USE_POSITION))
       _component->generate_file();
#endif

    log_printf(FUNC,Free_List_unit,FUNCTION,"End");
  };

}; // end namespace free_list_unit
}; // end namespace register_translation_unit
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
