/*
 * $Id: Parameters.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Rename_unit_Glue/include/Parameters.h"
#include "Common/include/Max.h"
namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace rename_unit_glue {


#undef  FUNCTION
#define FUNCTION "Rename_unit_Glue::Parameters"
  Parameters::Parameters (uint32_t    nb_front_end          ,
			  uint32_t  * nb_context            ,
//                        uint32_t    size_front_end_id     ,
//                        uint32_t    size_context_id       ,
			  uint32_t    nb_inst_insert        ,
			  uint32_t    nb_inst_retire        ,
			  uint32_t    size_general_data     ,
			  uint32_t    size_special_register ,
                          bool        is_toplevel
                          )
  {
    log_begin(Rename_unit_Glue,FUNCTION);

    _nb_front_end           = nb_front_end  ;
    _nb_context             = nb_context    ;
    _nb_inst_insert         = nb_inst_insert;
    _nb_inst_retire         = nb_inst_retire;

    test();

    if (is_toplevel)
      {
        _size_general_data      = size_general_data    ;
        _size_special_register  = size_special_register;
        
        _size_front_end_id      = log2(_nb_front_end);
        _size_context_id        = log2(max<uint32_t>(_nb_context,_nb_front_end));
        
        _have_port_front_end_id = _size_front_end_id > 0;
        _have_port_context_id   = _size_context_id   > 0;
        
        copy();
      }

    log_end(Rename_unit_Glue,FUNCTION);
  };
  
// #undef  FUNCTION
// #define FUNCTION "Rename_unit_Glue::Parameters (copy)"
//   Parameters::Parameters (Parameters & param)
//   {
//     log_begin(Rename_unit_Glue,FUNCTION);
//     test();
//     log_end(Rename_unit_Glue,FUNCTION);
//   };

#undef  FUNCTION
#define FUNCTION "Rename_unit_Glue::~Parameters"
  Parameters::~Parameters (void)
  {
    log_begin(Rename_unit_Glue,FUNCTION);
    log_end(Rename_unit_Glue,FUNCTION);
  };

#undef  FUNCTION
#define FUNCTION "Rename_unit_Glue::copy"
  void Parameters::copy (void)
  {
    log_begin(Rename_unit_Glue,FUNCTION);
    log_end(Rename_unit_Glue,FUNCTION);
  };

}; // end namespace rename_unit_glue
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
