#ifndef morpheo_behavioural_core_multi_ooo_engine_ooo_engine_Parameters_h
#define morpheo_behavioural_core_multi_ooo_engine_ooo_engine_Parameters_h

/*
 * $Id: Parameters.h 117 2009-05-16 14:42:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Parameters.h"
#include "Common/include/Debug.h"

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/include/Parameters.h"
#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Commit_unit/include/Parameters.h"
#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Issue_queue/include/Parameters.h"
#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Reexecute_unit/include/Parameters.h"
#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Special_Register_unit/include/Parameters.h"
#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/OOO_Engine_Glue/include/Parameters.h"

#include <vector>

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {


  class Parameters : public morpheo::behavioural::Parameters
  {
    //-----[ fields ]------------------------------------------------------------

  public : uint32_t              _nb_front_end                     ;
  public : uint32_t            * _nb_context                       ;//[nb_front_end]
  public : uint32_t              _nb_rename_unit                   ;
  public : uint32_t              _nb_execute_loop                  ;
  public : uint32_t            * _nb_inst_decod                    ;//[nb_front_end]
  public : uint32_t            * _nb_inst_insert                   ;//[nb_rename_unit]
  public : uint32_t            * _nb_inst_retire                   ;//[nb_rename_unit]
  public : uint32_t              _nb_inst_issue                    ;
  public : uint32_t            * _nb_inst_execute                  ;//[nb_execute_loop]
  public : uint32_t              _nb_inst_reexecute                ;
  public : uint32_t              _nb_inst_commit                   ;
  public : uint32_t              _nb_inst_branch_complete          ;
  public : uint32_t           ** _nb_branch_speculated             ;//[nb_front_end][nb_context]
  public : uint32_t              _nb_rename_unit_select            ;
  public : uint32_t              _nb_execute_loop_select           ;
//public : uint32_t              _size_general_data                ;
//public : uint32_t              _size_special_data                ;
  public : uint32_t            * _link_rename_unit_with_front_end  ;//[nb_front_end]
    // Commit
  public : uint32_t              _size_re_order_buffer             ;
  public : uint32_t              _nb_re_order_buffer_bank          ;
  public : Tpriority_t           _commit_priority                  ;
  public : Tload_balancing_t     _commit_load_balancing            ;
    // Issue
  public : uint32_t              _size_issue_queue                 ;
  public : issue_queue::Tissue_queue_scheme_t
                                 _issue_queue_scheme               ;
  public : uint32_t              _nb_issue_queue_bank              ;
  public : Tpriority_t           _issue_priority                   ;
  public : Tload_balancing_t     _issue_load_balancing             ;
//   public : bool               ** _table_routing                    ;//[nb_rename_unit][nb_inst_issue]
//   public : bool               ** _table_issue_type                 ;//[nb_inst_issue][nb_type]
    // Reexecute
  public : uint32_t              _size_reexecute_queue             ;
  public : Tpriority_t           _reexecute_priority               ;
  public : Tload_balancing_t     _reexecute_load_balancing         ;
    // Rename_unit
  public : Tpriority_t         * _rename_select_priority           ;//[nb_rename_unit]
  public : Tload_balancing_t   * _rename_select_load_balancing     ;//[nb_rename_unit]
  public : uint32_t            * _rename_select_nb_front_end_select;//[nb_rename_unit]
  public : uint32_t            * _nb_general_register              ;//[nb_rename_unit]
  public : uint32_t            * _nb_special_register              ;//[nb_rename_unit]
  public : uint32_t            * _nb_reg_free                      ;//[nb_rename_unit]
  public : uint32_t            * _nb_rename_unit_bank              ;//[nb_rename_unit]
//   public : uint32_t            * _size_read_counter                ;//[nb_rename_unit]
  public : uint32_t            * _nb_load_store_queue              ;//[nb_rename_unit]
  public : uint32_t           ** _size_store_queue                 ;//[nb_rename_unit][nb_load_store_queue]
  public : uint32_t           ** _size_load_queue                  ;//[nb_rename_unit][nb_load_store_queue]
  public : uint32_t           ** _nb_inst_memory                   ;//[nb_rename_unit][nb_load_store_queue]
  public : uint32_t           ** _link_load_store_unit_with_thread ;//[nb_front_end][nb_context]
    // SPR
  public : bool              *** _implement_group                  ;//[nb_front_end][nb_context][NB_GROUP]
    // Others
  public : uint32_t              _nb_thread                          ;
  public : uint32_t           ** _translate_num_context_to_num_thread; //[nb_front_end][nb_context]


  public : std::vector<uint32_t>*_link_front_end_with_rename_unit              ;//[nb_rename_unit]
  public : uint32_t            * _rename_unit_nb_front_end                     ;//[nb_rename_unit]
  public : uint32_t           ** _rename_unit_nb_context                       ;//[nb_rename_unit][nb_front_end]
  public : uint32_t           ** _rename_unit_nb_inst_decod                    ;//[nb_rename_unit][nb_front_end]
  public : uint32_t          *** _rename_unit_link_load_store_unit_with_thread ;//[nb_rename_unit][nb_front_end][nb_context]
  public : uint32_t            * _rename_unit_size_front_end_id                ;//[nb_rename_unit]
  public : uint32_t            * _rename_unit_size_context_id                  ;//[nb_rename_unit]
  public : uint32_t              _max_nb_context                               ;
  public : uint32_t              _max_branch_speculated                        ;
//public : uint32_t              _size_front_end_id                            ;
//public : uint32_t              _size_context_id                              ;
//public : uint32_t              _size_packet_id                               ;
  public : uint32_t              _size_rename_id                               ;
//public : uint32_t              _size_max_depth                               ;
//public : uint32_t              _size_general_register                        ;
//public : uint32_t              _size_special_register                        ;
//public : uint32_t              _size_store_queue_ptr                         ;
//public : uint32_t              _size_load_queue_ptr                          ;
//public : uint32_t              _size_nb_inst                                 ;
//public : uint32_t           ** _size_depth                                   ;//[nb_front_end][nb_context]
  public : uint32_t              _sum_inst_insert                               ;
  public : uint32_t              _sum_inst_retire                              ;

//public : bool                  _have_port_front_end_id                       ;
//public : bool                  _have_port_context_id                         ;
//public : bool                  _have_port_packet_id                          ;
  public : bool                  _have_port_rename_id                          ;
//public : bool                  _have_port_load_queue_ptr                     ;
//public : bool                  _have_port_max_depth                          ;
//public : bool               ** _have_port_depth                              ;//[nb_front_end][nb_context]

  public  : morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit          ::Parameters ** _param_rename_unit          ;
  public  : morpheo::behavioural::core::multi_ooo_engine::ooo_engine::commit_unit          ::Parameters  * _param_commit_unit          ;
  public  : morpheo::behavioural::core::multi_ooo_engine::ooo_engine::issue_queue          ::Parameters  * _param_issue_queue          ;
  public  : morpheo::behavioural::core::multi_ooo_engine::ooo_engine::reexecute_unit       ::Parameters  * _param_reexecute_unit       ;   
  public  : morpheo::behavioural::core::multi_ooo_engine::ooo_engine::special_register_unit::Parameters  * _param_special_register_unit;
  public  : morpheo::behavioural::core::multi_ooo_engine::ooo_engine::ooo_engine_glue      ::Parameters  * _param_glue                 ;

    //-----[ methods ]-----------------------------------------------------------
  public : Parameters  (uint32_t              nb_front_end                     ,
                        uint32_t            * nb_context                       ,//[nb_front_end]
                        uint32_t              nb_rename_unit                   ,
                        uint32_t              nb_execute_loop                  ,
                        uint32_t            * nb_inst_decod                    ,//[nb_front_end]
                        uint32_t            * nb_inst_insert                   ,//[nb_rename_unit]
                        uint32_t            * nb_inst_retire                   ,//[nb_rename_unit]
//                      uint32_t              nb_inst_issue                    ,
                        uint32_t            * nb_inst_execute                  ,//[nb_execute_loop]
                        uint32_t              nb_inst_reexecute                ,
                        uint32_t              nb_inst_commit                   ,
                        uint32_t              nb_inst_branch_complete          ,
                        uint32_t           ** nb_branch_speculated             ,//[nb_front_end][nb_context]
                        uint32_t              size_nb_inst_decod               ,
                        uint32_t              nb_rename_unit_select            ,
                        uint32_t              nb_execute_loop_select           ,
                        uint32_t              size_general_data                ,
                        uint32_t              size_special_data                ,
                        uint32_t            * link_rename_unit_with_front_end  ,//[nb_front_end]
                        // Commit
                        uint32_t              size_re_order_buffer             ,
                        uint32_t              nb_re_order_buffer_bank          ,
                        Tpriority_t           commit_priority                  ,
                        Tload_balancing_t     commit_load_balancing            ,
                        // Issue
                        uint32_t              size_issue_queue                 ,
                        issue_queue::Tissue_queue_scheme_t
                                              issue_queue_scheme               ,
                        uint32_t              nb_issue_queue_bank              ,
                        Tpriority_t           issue_priority                   ,
                        Tload_balancing_t     issue_load_balancing             ,
//                         bool               ** table_routing                    ,//[nb_rename_unit][nb_inst_issue]
//                         bool               ** table_issue_type                 ,//[nb_inst_issue][nb_type]
                        // Reexecute
                        uint32_t              size_reexecute_queue             ,
                        Tpriority_t           reexecute_priority               ,
                        Tload_balancing_t     reexecute_load_balancing         ,
                        // Rename_unit
                        Tpriority_t         * rename_select_priority           ,//[nb_rename_unit]
                        Tload_balancing_t   * rename_select_load_balancing     ,//[nb_rename_unit]
                        uint32_t            * rename_select_nb_front_end_select,//[nb_rename_unit]
                        uint32_t            * nb_general_register              ,//[nb_rename_unit]
                        uint32_t            * nb_special_register              ,//[nb_rename_unit]
                        uint32_t            * nb_reg_free                      ,//[nb_rename_unit]
                        uint32_t            * nb_rename_unit_bank              ,//[nb_rename_unit]
//                      uint32_t            * size_read_counter                ,//[nb_rename_unit]
                        uint32_t            * nb_load_store_queue              ,//[nb_rename_unit]
                        uint32_t           ** size_store_queue                 ,//[nb_rename_unit][nb_load_store_queue]
                        uint32_t           ** size_load_queue                  ,//[nb_rename_unit][nb_load_store_queue]
                        uint32_t           ** nb_inst_memory                   ,//[nb_rename_unit][nb_load_store_queue]
                        uint32_t           ** link_load_store_unit_with_thread ,//[nb_front_end][nb_context]
                        // SPR
                        bool              *** implement_group                  ,//[nb_front_end][nb_context][NB_GROUP]
                        // Others
                        uint32_t              nb_thread                          ,
                        uint32_t           ** translate_num_context_to_num_thread, //[nb_front_end][nb_context]
                        bool                  is_toplevel=false
                        );
//   public : Parameters  (Parameters & param) ;
  public : ~Parameters () ;

  public :        Parameters_test msg_error  (void);

  public :        void            copy       (void);

  public :        std::string     print      (uint32_t depth);
  public : friend std::ostream&   operator<< (std::ostream& output_stream,
                                              morpheo::behavioural::core::multi_ooo_engine::ooo_engine::Parameters & x);
  };

}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
