/*
 * $Id: Entity.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Entity.h"

namespace morpheo              {
namespace behavioural          {

  Entity::Entity  ( std::string       name   
		   ,std::string       type  
#ifdef POSITION
		   ,schema_t     schema
#endif
		    ,Tusage_t      usage
		    ):
     _name       (name      )
    ,_type       (type      )
#ifdef POSITION
    ,_schema     (schema    )
#endif
     ,_usage      (usage     )
  {
    log_printf(FUNC,Behavioural,"Entity","Begin");
    _interfaces = new Interfaces (name, usage);
#ifdef POSITION
    _is_map     = false;
#endif
    log_printf(FUNC,Behavioural,"Entity","End");
  };

  Entity::Entity  (const Entity & entity):
     _name       (entity._name      )
    ,_type       (entity._type      )
#ifdef POSITION
    ,_schema     (entity._schema    )
#endif
    ,_usage      (entity._usage     )
  {
    log_printf(FUNC,Behavioural,"Entity (copy)","Begin");
    _interfaces = entity._interfaces;
#ifdef POSITION
    _is_map     = entity._is_map    ;
    _comment    = entity._comment   ;
#endif
    log_printf(FUNC,Behavioural,"Entity (copy)","End");
  };
  
  Entity::~Entity ()
  {
    log_printf(FUNC,Behavioural,"~Entity","Begin");
    delete _interfaces;
    log_printf(FUNC,Behavioural,"~Entity","End");
  };

}; // end namespace behavioural          
}; // end namespace morpheo              
