/*
 * Test_017
 *
 * end_ko : infinite_loop
 * end_ok : Write in R1 the stop address and stop an data
 *          The store in the destination of an jump
 * start  : Test l.cmov
 */
	
	.file	"crt0.s"
	/*
	.section .vector
	*/
	.section .text
	.align	4	

/* ---[ 0x0  : Print a error ]------------------------------------------- */

	.org 0x0
_end_ko        :        
	l.movhi r1,     hi(_tty)
	l.ori   r1, r1, lo(_tty)
        l.sw    4(r1), r1 /* stop address */
_infinite_loop :        
        l.j	_infinite_loop
        l.nop

_end_ok :
	l.movhi r1,     hi(_tty)
	l.ori   r1, r1, lo(_tty)
        l.sw    4(r1), r0 /* stop address */


/* ---[ 0x100: RESET exception ]----------------------------------------- */
        .org 0x100
	.global _start
_start:

	l.movhi r1,     hi(0xdeadbeef) /* RA */
	l.ori   r1, r1, lo(0xdeadbeef)
	l.movhi r2,     hi(0x87654321) /* RB */
	l.ori   r2, r2, lo(0x87654321)

        /**********/
        /* Test 1 */
        /**********/

        l.sfeq  r0, r0
        l.cmov  r3, r1, r2

        /* Test result */
        l.sfeq  r3, r1
        l.bnf   _end_ko
        l.nop

        /**********/
        /* Test 2 */
        /**********/

        l.sfne  r0, r0
        l.cmov  r3, r1, r2

        /* Test result */
        l.sfeq  r3, r2
        l.bnf   _end_ko
        l.nop
        
        /**********/
        /* End */
        /**********/

        l.j     _end_ok
        l.nop
