#ifndef ENVIRONMENT_DATA_SEGMENT_H
#define ENVIRONMENT_DATA_SEGMENT_H

#include "../../../shared/soclib_segment_table.h"
#include "Type_target.h"

#include <iomanip>

extern "C" void loadexec(void **emem, int *esize, int *eoffset, const char *file, const char ** sections);

namespace environment {
namespace data {

  class Segment
  {
  protected : std::string   name;

  protected : uint32_t      base;
  protected : uint32_t      index;
  protected : uint32_t      size;
  protected : bool          uncached;
  protected : char        * data;
  protected : type_target_t type;

//public :  Segment (void);
  public :  Segment (SEGMENT_TABLE_ENTRY * segment);
  public : ~Segment (void);

  public : bool                 init          (const char * filename, const  char ** sections);
  public : void                 define_target (type_target_t type, uint32_t index);
  public : type_target_t        getType       (void);
  public : uint32_t             getIndex      (void);
  public : uint32_t             getBase       (void);
  public : uint32_t             getSize       (void);
  public : bool                 getUncached   (void);
  public : char *               data_addr     (void);
  public : bool                 test          (std::string name);
  public : bool                 test          (uint32_t address, uint32_t size);
  public : void                 read          (uint32_t address, uint32_t size, char * & data_dest);
  public : void                 write         (uint32_t address, uint32_t size, char * & data_src);
  public : std::string          print         (uint32_t depth);
  public : friend std::ostream& operator<<    (std::ostream& output, Segment & x);
  };

};
};
#endif
