#include "../include/Sim2OS.h"

namespace environment {
namespace sim2os {

    void * Sim2OS::execute (service_t num)
    {
      num_service = num;
      
      return execute();
    }
  
    /*
     * execute the service with all
     * the list of arg must be finish by "NULL"
     * also the list can't have a NULL as param
     */
    void * Sim2OS::execute (service_t num, void * arg, ...)
    {
      num_service = num;
      
      va_list ap;
      va_start (ap,arg);
      uint32_t it = 1;
      while (arg != NULL)
	{
	  arguments[it] = arg;  
	  it ++;
	  arg = va_arg(ap,void *);
	}
  
      va_end(ap);
      return execute();
    }

    /*
     * execute the service without argument
     */
    void * Sim2OS::execute ()
    {
      result = NULL;
      
      switch (num_service)
	{
	case SERVICE_OPEN          : {result = service_open     (); break;}
	case SERVICE_CLOSE         : {result = service_close    (); break;}
	case SERVICE_READ          : {result = service_read     (); break;}
	case SERVICE_WRITE         : {result = service_write    (); break;}
	case SERVICE_TIME          : {result = service_time     (); break;}
	case SERVICE_CLOCK         : {result = service_clock    (); break;}
	case SERVICE_LSEEK         : {result = service_lseek    (); break;}
	case SERVICE_UNIMPLEMENTED :
	  {
	    std::cerr << "<" << name << "> service Unimplemented : " << num_service << std::endl;
	    break;
	  }

	case SERVICE_UNDEFINED     :
	default                    :
	  {
	    std::cerr << "<" << name << "> service Undefine      : " << num_service << std::endl;
	    break;
	  }
	}//end switch

      // Erase all elt;
      num_service = SERVICE_UNDEFINED;
      arguments.erase(arguments.begin(),arguments.end());
      return result;
    };
};
};
