#ifndef morpheo_behavioural_configuration_Generator_h
#define morpheo_behavioural_configuration_Generator_h

/*
 * $Id: Generator.h 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Configuration/include/Parameter_definition.h"
#include "Behavioural/Configuration/include/Link_definition.h"
#include "Behavioural/Configuration/include/XMLUtils.h"
#include <map>

namespace morpheo {
namespace behavioural {
namespace configuration {

  class Generator 
  {
    // -----[ fields ]----------------------------------------------------
  private  : std::string _filename;
  private  : std::map<std::string, Parameter_definition *> * _array_param;
  private  : std::map<std::string, Link_definition *>      * _array_link;

    // -----[ methods ]---------------------------------------------------
  public   :                        Generator  (std::string filename);
  public   :                       ~Generator  ();

  public   : Parameter_definition * getParam   (std::string name);
  public   : Link_definition *      getLink    (std::string name);
    

  public   : void                   test       (std::string param,
                                                std::string x);
  public   : void                   test       (std::string link,
                                                std::string father_name,
                                                bool        father_is_src,
                                                bool        father_is_dest);
                                   
  private  : void                   insert     (Parameter_definition * param);
  private  : void                   insert     (Link_definition      * param);
  private  : void                   fromFile   (std::string filename);
                                   
  public   : void                   toFile     (std::string dirname=".");
  private  : XML                    toXML      (void);
  private  : std::string            print      (uint32_t depth);
  public   : friend std::ostream&   operator<< (std::ostream& output,
                                              morpheo::behavioural::configuration::Generator & x);
  };

}; // end namespace configuration
}; // end namespace behavioural
}; // end namespace morpheo              

#endif
