/*
 * $Id: Parameters_print.cpp 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Dcache_Access/include/Parameters.h"
#include "Behavioural/include/XML.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace dcache_access {


#undef  FUNCTION
#define FUNCTION "Dcache_Access::print"
  std::string Parameters::print (uint32_t depth)
  {
    log_begin(Dcache_Access,FUNCTION);

    XML xml ("dcache_access");

    xml.balise_open("dcache_access");
    xml.singleton_begin("nb_execute_loop        "); xml.attribut("value",toString(_nb_execute_loop        )); xml.singleton_end();
    xml.singleton_begin("nb_dcache_port         "); xml.attribut("value",toString(_nb_dcache_port         )); xml.singleton_end();
    xml.singleton_begin("size_address           "); xml.attribut("value",toString(_size_address           )); xml.singleton_end();
    xml.singleton_begin("size_data              "); xml.attribut("value",toString(_size_data              )); xml.singleton_end();
    xml.singleton_begin("priority               "); xml.attribut("value",toString(_priority               )); xml.singleton_end();
    xml.singleton_begin("load_balancing         "); xml.attribut("value",toString(_load_balancing         )); xml.singleton_end();

    for (uint32_t i=0;i<_nb_execute_loop; i++)
      {
        xml. balise_open_begin("component");
        xml.  attribut("type","execute_loop");
        xml.  attribut("id"  ,toString(i));
        xml. balise_open_end();
	xml.singleton_begin("nb_load_store_unit     "); xml.attribut("value",toString(_nb_load_store_unit     [i])); xml.singleton_end();
	
	for (uint32_t j=0; j<_nb_load_store_unit [i]; ++j)
	  {
	    xml. balise_open_begin("component");
	    xml.  attribut("type","load_store_unit");
	    xml.  attribut("id"  ,toString(j));
	    xml. balise_open_end();
	    xml.singleton_begin("nb_cache_access        "); xml.attribut("value",toString(_nb_cache_access        [i][j])); xml.singleton_end();
	    xml.singleton_begin("size_thread_id         "); xml.attribut("value",toString(_size_thread_id         [i][j])); xml.singleton_end();
	    xml.singleton_begin("size_packet_id         "); xml.attribut("value",toString(_size_packet_id         [i][j])); xml.singleton_end();

	    for (uint32_t k=0; k<_nb_cache_access [i][j]; ++k)
	      {
		xml. balise_open_begin("component");
		xml.  attribut("type","cache_access");
		xml.  attribut("id"  ,toString(k));
		xml. balise_open_end();
		xml.singleton_begin("table_routing          "); xml.attribut("value",toString(_table_routing          [i][j][k])); xml.singleton_end();
		
		xml. balise_close();
	      }
	    xml. balise_close();
	  }
	xml. balise_close();
      }

    xml.balise_close();

    log_end(Dcache_Access,FUNCTION);
    
    return xml.get_body(depth);
  };

#undef  FUNCTION
#define FUNCTION "Dcache_Access::operator<<"
  std::ostream& operator<< (std::ostream& output_stream ,
			    morpheo::behavioural::core::dcache_access::Parameters & x)
  {
    log_begin(Dcache_Access,FUNCTION);

    output_stream << x.print(0);
    
    log_end(Dcache_Access,FUNCTION);

    return output_stream;
  };

}; // end namespace dcache_access
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
