#ifndef morpheo_behavioural_core_icache_access_Parameters_h
#define morpheo_behavioural_core_icache_access_Parameters_h

/*
 * $Id: Parameters.h 88 2008-12-10 18:31:39Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Icache_Access/include/Types.h"
#include "Behavioural/include/Parameters.h"
#include "Common/include/Debug.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace icache_access {


  class Parameters : public morpheo::behavioural::Parameters
  {
    //-----[ fields ]------------------------------------------------------------
  public : uint32_t             _nb_thread                    ;
  public : uint32_t             _nb_front_end                 ;
  public : uint32_t           * _nb_context                   ;//[nb_front_end]
  public : uint32_t             _nb_icache_port               ;
  public : uint32_t             _size_address                 ;
  public : uint32_t             _size_icache_thread_id        ;
  public : uint32_t             _size_icache_packet_id        ;
  public : uint32_t          ** _nb_instruction               ;//[nb_front_end][nb_context]
  public : uint32_t          ** _size_packet_id               ;//[nb_front_end][nb_context]
  public : uint32_t          ** _table_routing                ;//[nb_front_end][nb_context]
  public : Tpriority_t          _priority                     ;
  public : Tload_balancing_t    _load_balancing               ;
  public : uint32_t          ** _translate_context_to_thread  ;//[nb_front_end][nb_context]

  public : uint32_t             _max_nb_context               ;
  public : uint32_t             _max_nb_instruction           ;
  public : uint32_t             _size_thread_id               ;
  public : uint32_t             _max_size_packet_id           ;
  public : Tcontext_t           _shift_num_front_end          ;
  public : Tcontext_t           _mask_size_context            ;
  public : uint32_t           * _icache_nb_instruction        ;//[nb_icache_port]
  public : Tcontext_t         * _translate_thread_to_context  ;//[nb_thread]
  public : Tcontext_t         * _translate_thread_to_front_end;//[nb_thread]

  public : bool                 _have_port_icache_thread_id   ;
  public : bool                 _have_port_icache_packet_id   ;
  public : bool              ** _have_port_packet_id          ;//[nb_front_end][nb_context]

    //-----[ methods ]-----------------------------------------------------------
  public : Parameters  
  (uint32_t             nb_thread                  ,
   uint32_t             nb_front_end               ,
   uint32_t           * nb_context                 ,
   uint32_t             nb_icache_port             ,
   uint32_t             size_address               ,
   uint32_t             size_icache_thread_id      ,
   uint32_t             size_icache_packet_id      ,
   uint32_t          ** nb_instruction             ,
   uint32_t          ** size_packet_id             ,
   uint32_t          ** table_routing              ,
   Tpriority_t          priority                   ,
   Tload_balancing_t    load_balancing             ,
   uint32_t          ** translate_context_to_thread,
   bool                 is_toplevel=false);
    
//   public : Parameters  (Parameters & param) ;
  public : ~Parameters () ;

  public :        void            copy       (void);

  public :        Parameters_test msg_error  (void);

  public :        std::string     print      (uint32_t depth);
  public : friend std::ostream&   operator<< (std::ostream& output_stream,
					    morpheo::behavioural::core::icache_access::Parameters & x);
  };

}; // end namespace icache_access
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
