-------------------------------------------------------------------------------
-- File    : ./Functionnal_unit_0.vhdl
-- Date    : Fri Mar 13 16:20:01 2009
-- Version : 0.2.111 - Castor
-- Comment : it's a autogenerated file, don't modify
-------------------------------------------------------------------------------


library ieee;
  use ieee.numeric_bit.all;       
  use ieee.numeric_std.all;       
  use ieee.std_logic_1164.all;    
  use ieee.std_logic_arith.all;   
  use ieee.std_logic_misc.all;    
--use ieee.std_logic_signed.all;  
  use ieee.std_logic_unsigned.all;
--use ieee.std_logic_textio.all;  


library work;
use work.Functionnal_unit_0_Pack.all;
use work.Functionnal_unit_0_shifter_Pack.all;

Library XilinxCoreLib;
use XilinxCoreLib.c_compare_v9_0_comp.all;

entity Functionnal_unit_0 is
	port (
	in_CLOCK	: in     std_logic;
	in_NRESET	: in     std_logic;
	in_EXECUTE_IN_VAL	: in     std_logic;
	out_EXECUTE_IN_ACK	: out    std_logic;
	in_EXECUTE_IN_OOO_ENGINE_ID	: in     std_logic;
	in_EXECUTE_IN_PACKET_ID	: in     std_logic_vector(7 downto 0);
	in_EXECUTE_IN_OPERATION	: in     std_logic_vector(6 downto 0);
	in_EXECUTE_IN_TYPE	: in     std_logic_vector(4 downto 0);
	in_EXECUTE_IN_STORE_QUEUE_PTR_WRITE	: in     std_logic_vector(1 downto 0);
	in_EXECUTE_IN_HAS_IMMEDIAT	: in     std_logic;
	in_EXECUTE_IN_IMMEDIAT	: in     std_logic_vector(31 downto 0);
	in_EXECUTE_IN_DATA_RA	: in     std_logic_vector(31 downto 0);
	in_EXECUTE_IN_DATA_RB	: in     std_logic_vector(31 downto 0);
	in_EXECUTE_IN_DATA_RC	: in     std_logic_vector(1 downto 0);
	in_EXECUTE_IN_WRITE_RD	: in     std_logic;
	in_EXECUTE_IN_NUM_REG_RD	: in     std_logic_vector(4 downto 0);
	in_EXECUTE_IN_WRITE_RE	: in     std_logic;
	in_EXECUTE_IN_NUM_REG_RE	: in     std_logic_vector(3 downto 0);
	out_EXECUTE_OUT_VAL	: out    std_logic;
	in_EXECUTE_OUT_ACK	: in     std_logic;
	out_EXECUTE_OUT_OOO_ENGINE_ID	: out    std_logic;
	out_EXECUTE_OUT_PACKET_ID	: out    std_logic_vector(7 downto 0);
	out_EXECUTE_OUT_WRITE_RD	: out    std_logic;
	out_EXECUTE_OUT_NUM_REG_RD	: out    std_logic_vector(4 downto 0);
	out_EXECUTE_OUT_DATA_RD	: out    std_logic_vector(31 downto 0);
	out_EXECUTE_OUT_WRITE_RE	: out    std_logic;
	out_EXECUTE_OUT_NUM_REG_RE	: out    std_logic_vector(3 downto 0);
	out_EXECUTE_OUT_DATA_RE	: out    std_logic_vector(1 downto 0);
	out_EXECUTE_OUT_EXCEPTION	: out    std_logic_vector(4 downto 0);
	out_EXECUTE_OUT_NO_SEQUENCE	: out    std_logic;
	out_EXECUTE_OUT_ADDRESS	: out    std_logic_vector(29 downto 0)
	     );
end Functionnal_unit_0;

architecture behavioural of Functionnal_unit_0 is
	type Tmac	is array (1 downto 0) of std_logic_vector(31 downto 0);

	signal sig_EXECUTE_IN_ACK	: std_logic;
	signal reg_BUSY_IN	: std_logic;
	signal reg_EXECUTE_IN_OOO_ENGINE_ID	: std_logic;
	signal reg_EXECUTE_IN_PACKET_ID	: std_logic_vector(7 downto 0);
	signal reg_EXECUTE_IN_OPERATION	: std_logic_vector(6 downto 0);
	signal reg_EXECUTE_IN_TYPE	: std_logic_vector(4 downto 0);
	signal reg_EXECUTE_IN_HAS_IMMEDIAT	: std_logic;
	signal reg_EXECUTE_IN_IMMEDIAT	: std_logic_vector(31 downto 0);
	signal reg_EXECUTE_IN_DATA_RA	: std_logic_vector(31 downto 0);
	signal reg_EXECUTE_IN_DATA_RB	: std_logic_vector(31 downto 0);
	signal reg_EXECUTE_IN_DATA_RC	: std_logic_vector(1 downto 0);
	signal reg_EXECUTE_IN_WRITE_RD	: std_logic;
	signal reg_EXECUTE_IN_NUM_REG_RD	: std_logic_vector(4 downto 0);
	signal reg_EXECUTE_IN_WRITE_RE	: std_logic;
	signal reg_EXECUTE_IN_NUM_REG_RE	: std_logic_vector(3 downto 0);
	signal sig_B_OPERAND	: std_logic_vector(31 downto 0);
	signal sig_IS_ARITH	: std_logic;
	signal sig_IS_LOGIC	: std_logic;
	signal sig_CIN_ARITH	: std_logic;
	signal sig_ARITH_B_OPERAND	: std_logic_vector(31 downto 0);
	signal sig_RES_ARITH	: std_logic_vector(32 downto 0);
	signal sig_A_AND_B	: std_logic_vector(31 downto 0);
	signal sig_A_OR_B	: std_logic_vector(31 downto 0);
	signal sig_A_XOR_B	: std_logic_vector(31 downto 0);
	signal sig_RES_LOGIC	: std_logic_vector(31 downto 0);
	signal sig_RES_ALU	: std_logic_vector(31 downto 0);
	signal sig_OVR_ALU	: std_logic;
	signal sig_COUT_ALU	: std_logic;
	signal sig_RES_MOVE	: std_logic_vector(31 downto 0);
	signal sig_CMOV	: std_logic_vector(31 downto 0);
	signal sig_MOVHI	: std_logic_vector(31 downto 0);
	signal sig_RES_BRANCH	: std_logic_vector(31 downto 0);
	signal sig_ADDR_BRANCH	: std_logic_vector(29 downto 0);
	signal sig_NOSQ_BRANCH	: std_logic;
	signal sig_RES_SHIFTER	: std_logic_vector(31 downto 0);
	signal sig_EXT_BYTE_S	: std_logic_vector(31 downto 0);
	signal sig_EXT_BYTE_Z	: std_logic_vector(31 downto 0);
	signal sig_EXT_HALF_WORD_S	: std_logic_vector(31 downto 0);
	signal sig_EXT_HALF_WORD_Z	: std_logic_vector(31 downto 0);
	signal sig_EXT_WORD_S	: std_logic_vector(31 downto 0);
	signal sig_EXT_WORD_Z	: std_logic_vector(31 downto 0);
	signal sig_EXT_S	: std_logic_vector(31 downto 0);
	signal sig_EXT_Z	: std_logic_vector(31 downto 0);
	signal sig_RES_EXTEND	: std_logic_vector(31 downto 0);
	signal sig_FF1	: std_logic_vector(5 downto 0);
	signal sig_FL1	: std_logic_vector(5 downto 0);
	signal sig_RES_FIND	: std_logic_vector(31 downto 0);
	signal sig_SPR_IS_HERE	: std_logic;
	signal sig_MFSPR	: std_logic_vector(31 downto 0);
	signal sig_MTSPR	: std_logic_vector(31 downto 0);
	signal sig_RES_SPECIAL	: std_logic_vector(31 downto 0);
	signal sig_EXECUTE_OUT_VAL	: std_logic;
	signal sig_EXECUTE_OUT_UPDATE	: std_logic;
	signal reg_BUSY_OUT	: std_logic;
	signal reg_EXECUTE_OUT_OOO_ENGINE_ID	: std_logic;
	signal sig_EXECUTE_OUT_OOO_ENGINE_ID	: std_logic;
	signal reg_EXECUTE_OUT_PACKET_ID	: std_logic_vector(7 downto 0);
	signal sig_EXECUTE_OUT_PACKET_ID	: std_logic_vector(7 downto 0);
	signal reg_EXECUTE_OUT_WRITE_RD	: std_logic;
	signal sig_EXECUTE_OUT_WRITE_RD	: std_logic;
	signal reg_EXECUTE_OUT_NUM_REG_RD	: std_logic_vector(4 downto 0);
	signal sig_EXECUTE_OUT_NUM_REG_RD	: std_logic_vector(4 downto 0);
	signal reg_EXECUTE_OUT_DATA_RD	: std_logic_vector(31 downto 0);
	signal sig_EXECUTE_OUT_DATA_RD	: std_logic_vector(31 downto 0);
	signal reg_EXECUTE_OUT_WRITE_RE	: std_logic;
	signal sig_EXECUTE_OUT_WRITE_RE	: std_logic;
	signal reg_EXECUTE_OUT_NUM_REG_RE	: std_logic_vector(3 downto 0);
	signal sig_EXECUTE_OUT_NUM_REG_RE	: std_logic_vector(3 downto 0);
	signal reg_EXECUTE_OUT_DATA_RE	: std_logic_vector(1 downto 0);
	signal sig_EXECUTE_OUT_DATA_RE	: std_logic_vector(1 downto 0);
	signal reg_EXECUTE_OUT_EXCEPTION	: std_logic_vector(4 downto 0);
	signal sig_EXECUTE_OUT_EXCEPTION	: std_logic_vector(4 downto 0);
	signal reg_EXECUTE_OUT_NO_SEQUENCE	: std_logic;
	signal sig_EXECUTE_OUT_NO_SEQUENCE	: std_logic;
	signal reg_EXECUTE_OUT_ADDRESS	: std_logic_vector(29 downto 0);
	signal sig_EXECUTE_OUT_ADDRESS	: std_logic_vector(29 downto 0);
	signal reg_MACLO             	: Tmac;
	signal reg_MACHI             	: Tmac;

	signal sig_IS_LESS	: std_logic;
	signal sig_A_COMPARE	: std_logic_vector(31 downto 0);
	signal sig_B_COMPARE	: std_logic_vector(31 downto 0);
	signal sig_A_GT_B_S	: std_logic;
	signal sig_A_GT_B_U	: std_logic;
	signal sig_A_EQ_B	: std_logic;
	signal sig_A_GT_B	: std_logic;
	signal sig_A_GE_B	: std_logic;
	signal sig_A_NE_B	: std_logic;
	signal sig_IS_SIGNED	: std_logic;
	signal sig_FLAG_F	: std_logic;
	signal sig_BUSY		: std_logic;

	type TFQUEUE	is array (7 downto 0) of std_logic_vector(131 downto 0);
	-- OOO_ENGINE_ID(1) + PACKET_ID(8) + OPERATION(7) + TYPE(5) +
        -- HAS_IMMEDIAT(1) + IMMEDIAT(32) + DATA_RA(32) + DATA_RB(32) + DATA_RC(2) +
        -- WRITE_RD(1) + NUM_REG_RD(5) + WRITE_RE(1) + NUM_REG_RE(4) + VALID(1)
        -- = 132 BITS
	signal reg_FUNCTIONAL_QUEUE            	: TFQUEUE;



	alias reg_OOO_ENGINE_ID_7	: std_logic	is reg_FUNCTIONAL_QUEUE(7)(131);
	alias reg_OOO_ENGINE_ID_6	: std_logic	is reg_FUNCTIONAL_QUEUE(6)(131);
	alias reg_OOO_ENGINE_ID_5	: std_logic	is reg_FUNCTIONAL_QUEUE(5)(131);
	alias reg_OOO_ENGINE_ID_4	: std_logic	is reg_FUNCTIONAL_QUEUE(4)(131);
	alias reg_OOO_ENGINE_ID_3	: std_logic	is reg_FUNCTIONAL_QUEUE(3)(131);
	alias reg_OOO_ENGINE_ID_2	: std_logic	is reg_FUNCTIONAL_QUEUE(2)(131);
	alias reg_OOO_ENGINE_ID_1	: std_logic	is reg_FUNCTIONAL_QUEUE(1)(131);
	alias reg_OOO_ENGINE_ID_0	: std_logic	is reg_FUNCTIONAL_QUEUE(0)(131);
	alias reg_PACKET_ID_7	: std_logic_vector(7 downto 0)	is reg_FUNCTIONAL_QUEUE(7)(130 downto 123);
	alias reg_PACKET_ID_6	: std_logic_vector(7 downto 0)	is reg_FUNCTIONAL_QUEUE(6)(130 downto 123);
	alias reg_PACKET_ID_5	: std_logic_vector(7 downto 0)	is reg_FUNCTIONAL_QUEUE(5)(130 downto 123);
	alias reg_PACKET_ID_4	: std_logic_vector(7 downto 0)	is reg_FUNCTIONAL_QUEUE(4)(130 downto 123);
	alias reg_PACKET_ID_3	: std_logic_vector(7 downto 0)	is reg_FUNCTIONAL_QUEUE(3)(130 downto 123);
	alias reg_PACKET_ID_2	: std_logic_vector(7 downto 0)	is reg_FUNCTIONAL_QUEUE(2)(130 downto 123);
	alias reg_PACKET_ID_1	: std_logic_vector(7 downto 0)	is reg_FUNCTIONAL_QUEUE(1)(130 downto 123);
	alias reg_PACKET_ID_0	: std_logic_vector(7 downto 0)	is reg_FUNCTIONAL_QUEUE(0)(130 downto 123);
	alias reg_OPERATION_7	: std_logic_vector(6 downto 0)	is reg_FUNCTIONAL_QUEUE(7)(122 downto 116);
	alias reg_OPERATION_6	: std_logic_vector(6 downto 0)	is reg_FUNCTIONAL_QUEUE(6)(122 downto 116);
	alias reg_OPERATION_5	: std_logic_vector(6 downto 0)	is reg_FUNCTIONAL_QUEUE(5)(122 downto 116);
	alias reg_OPERATION_4	: std_logic_vector(6 downto 0)	is reg_FUNCTIONAL_QUEUE(4)(122 downto 116);
	alias reg_OPERATION_3	: std_logic_vector(6 downto 0)	is reg_FUNCTIONAL_QUEUE(3)(122 downto 116);
	alias reg_OPERATION_2	: std_logic_vector(6 downto 0)	is reg_FUNCTIONAL_QUEUE(2)(122 downto 116);
	alias reg_OPERATION_1	: std_logic_vector(6 downto 0)	is reg_FUNCTIONAL_QUEUE(1)(122 downto 116);

	alias reg_TYPE_7	: std_logic_vector(4 downto 0)	is reg_FUNCTIONAL_QUEUE(7)(115 downto 111);
	alias reg_TYPE_6	: std_logic_vector(4 downto 0)	is reg_FUNCTIONAL_QUEUE(6)(115 downto 111);
	alias reg_TYPE_5	: std_logic_vector(4 downto 0)	is reg_FUNCTIONAL_QUEUE(5)(115 downto 111);
	alias reg_TYPE_4	: std_logic_vector(4 downto 0)	is reg_FUNCTIONAL_QUEUE(4)(115 downto 111);
	alias reg_TYPE_3	: std_logic_vector(4 downto 0)	is reg_FUNCTIONAL_QUEUE(3)(115 downto 111);
	alias reg_TYPE_2	: std_logic_vector(4 downto 0)	is reg_FUNCTIONAL_QUEUE(2)(115 downto 111);
	alias reg_TYPE_1	: std_logic_vector(4 downto 0)	is reg_FUNCTIONAL_QUEUE(1)(115 downto 111);

	alias reg_HAS_IMMEDIAT_7	: std_logic	is reg_FUNCTIONAL_QUEUE(7)(110);
	alias reg_HAS_IMMEDIAT_6	: std_logic	is reg_FUNCTIONAL_QUEUE(6)(110);
	alias reg_HAS_IMMEDIAT_5	: std_logic	is reg_FUNCTIONAL_QUEUE(5)(110);
	alias reg_HAS_IMMEDIAT_4	: std_logic	is reg_FUNCTIONAL_QUEUE(4)(110);
	alias reg_HAS_IMMEDIAT_3	: std_logic	is reg_FUNCTIONAL_QUEUE(3)(110);
	alias reg_HAS_IMMEDIAT_2	: std_logic	is reg_FUNCTIONAL_QUEUE(2)(110);
	alias reg_HAS_IMMEDIAT_1	: std_logic	is reg_FUNCTIONAL_QUEUE(1)(110);

	alias reg_IMMEDIAT_7	: std_logic_vector(31 downto 0)	is reg_FUNCTIONAL_QUEUE(7)(109 downto 78);
	alias reg_IMMEDIAT_6	: std_logic_vector(31 downto 0)	is reg_FUNCTIONAL_QUEUE(6)(109 downto 78);
	alias reg_IMMEDIAT_5	: std_logic_vector(31 downto 0)	is reg_FUNCTIONAL_QUEUE(5)(109 downto 78);
	alias reg_IMMEDIAT_4	: std_logic_vector(31 downto 0)	is reg_FUNCTIONAL_QUEUE(4)(109 downto 78);
	alias reg_IMMEDIAT_3	: std_logic_vector(31 downto 0)	is reg_FUNCTIONAL_QUEUE(3)(109 downto 78);
	alias reg_IMMEDIAT_2	: std_logic_vector(31 downto 0)	is reg_FUNCTIONAL_QUEUE(2)(109 downto 78);
	alias reg_IMMEDIAT_1	: std_logic_vector(31 downto 0)	is reg_FUNCTIONAL_QUEUE(1)(109 downto 78);

	alias reg_DATA_RA_7	: std_logic_vector(31 downto 0)	is reg_FUNCTIONAL_QUEUE(7)(77 downto 46);
	alias reg_DATA_RA_6	: std_logic_vector(31 downto 0)	is reg_FUNCTIONAL_QUEUE(6)(77 downto 46);
	alias reg_DATA_RA_5	: std_logic_vector(31 downto 0)	is reg_FUNCTIONAL_QUEUE(5)(77 downto 46);
	alias reg_DATA_RA_4	: std_logic_vector(31 downto 0)	is reg_FUNCTIONAL_QUEUE(4)(77 downto 46);
	alias reg_DATA_RA_3	: std_logic_vector(31 downto 0)	is reg_FUNCTIONAL_QUEUE(3)(77 downto 46);
	alias reg_DATA_RA_2	: std_logic_vector(31 downto 0)	is reg_FUNCTIONAL_QUEUE(2)(77 downto 46);
	alias reg_DATA_RA_1	: std_logic_vector(31 downto 0)	is reg_FUNCTIONAL_QUEUE(1)(77 downto 46);

	alias reg_DATA_RB_7	: std_logic_vector(31 downto 0)	is reg_FUNCTIONAL_QUEUE(7)(45 downto 14);
	alias reg_DATA_RB_6	: std_logic_vector(31 downto 0)	is reg_FUNCTIONAL_QUEUE(6)(45 downto 14);
	alias reg_DATA_RB_5	: std_logic_vector(31 downto 0)	is reg_FUNCTIONAL_QUEUE(5)(45 downto 14);
	alias reg_DATA_RB_4	: std_logic_vector(31 downto 0)	is reg_FUNCTIONAL_QUEUE(4)(45 downto 14);
	alias reg_DATA_RB_3	: std_logic_vector(31 downto 0)	is reg_FUNCTIONAL_QUEUE(3)(45 downto 14);
	alias reg_DATA_RB_2	: std_logic_vector(31 downto 0)	is reg_FUNCTIONAL_QUEUE(2)(45 downto 14);
	alias reg_DATA_RB_1	: std_logic_vector(31 downto 0)	is reg_FUNCTIONAL_QUEUE(1)(45 downto 14);

	alias reg_DATA_RC_7	: std_logic_vector(1 downto 0)	is reg_FUNCTIONAL_QUEUE(7)(13 downto 12);
	alias reg_DATA_RC_6	: std_logic_vector(1 downto 0)	is reg_FUNCTIONAL_QUEUE(6)(13 downto 12);
	alias reg_DATA_RC_5	: std_logic_vector(1 downto 0)	is reg_FUNCTIONAL_QUEUE(5)(13 downto 12);
	alias reg_DATA_RC_4	: std_logic_vector(1 downto 0)	is reg_FUNCTIONAL_QUEUE(4)(13 downto 12);
	alias reg_DATA_RC_3	: std_logic_vector(1 downto 0)	is reg_FUNCTIONAL_QUEUE(3)(13 downto 12);
	alias reg_DATA_RC_2	: std_logic_vector(1 downto 0)	is reg_FUNCTIONAL_QUEUE(2)(13 downto 12);
	alias reg_DATA_RC_1	: std_logic_vector(1 downto 0)	is reg_FUNCTIONAL_QUEUE(1)(13 downto 12);

	alias reg_WRITE_RD_7	: std_logic	is reg_FUNCTIONAL_QUEUE(7)(11);
	alias reg_WRITE_RD_6	: std_logic	is reg_FUNCTIONAL_QUEUE(6)(11);
	alias reg_WRITE_RD_5	: std_logic	is reg_FUNCTIONAL_QUEUE(5)(11);
	alias reg_WRITE_RD_4	: std_logic	is reg_FUNCTIONAL_QUEUE(4)(11);
	alias reg_WRITE_RD_3	: std_logic	is reg_FUNCTIONAL_QUEUE(3)(11);
	alias reg_WRITE_RD_2	: std_logic	is reg_FUNCTIONAL_QUEUE(2)(11);
	alias reg_WRITE_RD_1	: std_logic	is reg_FUNCTIONAL_QUEUE(1)(11);
	alias reg_WRITE_RD_0	: std_logic	is reg_FUNCTIONAL_QUEUE(0)(11);
	alias reg_NUM_REG_RD_7	: std_logic_vector(4 downto 0)	is reg_FUNCTIONAL_QUEUE(7)(10 downto 6);
	alias reg_NUM_REG_RD_6	: std_logic_vector(4 downto 0)	is reg_FUNCTIONAL_QUEUE(6)(10 downto 6);
	alias reg_NUM_REG_RD_5	: std_logic_vector(4 downto 0)	is reg_FUNCTIONAL_QUEUE(5)(10 downto 6);
	alias reg_NUM_REG_RD_4	: std_logic_vector(4 downto 0)	is reg_FUNCTIONAL_QUEUE(4)(10 downto 6);
	alias reg_NUM_REG_RD_3	: std_logic_vector(4 downto 0)	is reg_FUNCTIONAL_QUEUE(3)(10 downto 6);
	alias reg_NUM_REG_RD_2	: std_logic_vector(4 downto 0)	is reg_FUNCTIONAL_QUEUE(2)(10 downto 6);
	alias reg_NUM_REG_RD_1	: std_logic_vector(4 downto 0)	is reg_FUNCTIONAL_QUEUE(1)(10 downto 6);
	alias reg_NUM_REG_RD_0	: std_logic_vector(4 downto 0)	is reg_FUNCTIONAL_QUEUE(0)(10 downto 6);
	alias reg_WRITE_RE_7	: std_logic	is reg_FUNCTIONAL_QUEUE(7)(5);
	alias reg_WRITE_RE_6	: std_logic	is reg_FUNCTIONAL_QUEUE(6)(5);
	alias reg_WRITE_RE_5	: std_logic	is reg_FUNCTIONAL_QUEUE(5)(5);
	alias reg_WRITE_RE_4	: std_logic	is reg_FUNCTIONAL_QUEUE(4)(5);
	alias reg_WRITE_RE_3	: std_logic	is reg_FUNCTIONAL_QUEUE(3)(5);
	alias reg_WRITE_RE_2	: std_logic	is reg_FUNCTIONAL_QUEUE(2)(5);
	alias reg_WRITE_RE_1	: std_logic	is reg_FUNCTIONAL_QUEUE(1)(5);
	alias reg_WRITE_RE_0	: std_logic	is reg_FUNCTIONAL_QUEUE(0)(5);
	alias reg_NUM_REG_RE_7	: std_logic_vector(3 downto 0)	is reg_FUNCTIONAL_QUEUE(7)(4 downto 1);
	alias reg_NUM_REG_RE_6	: std_logic_vector(3 downto 0)	is reg_FUNCTIONAL_QUEUE(6)(4 downto 1);
	alias reg_NUM_REG_RE_5	: std_logic_vector(3 downto 0)	is reg_FUNCTIONAL_QUEUE(5)(4 downto 1);
	alias reg_NUM_REG_RE_4	: std_logic_vector(3 downto 0)	is reg_FUNCTIONAL_QUEUE(4)(4 downto 1);
	alias reg_NUM_REG_RE_3	: std_logic_vector(3 downto 0)	is reg_FUNCTIONAL_QUEUE(3)(4 downto 1);
	alias reg_NUM_REG_RE_2	: std_logic_vector(3 downto 0)	is reg_FUNCTIONAL_QUEUE(2)(4 downto 1);
	alias reg_NUM_REG_RE_1	: std_logic_vector(3 downto 0)	is reg_FUNCTIONAL_QUEUE(1)(4 downto 1);
	alias reg_NUM_REG_RE_0	: std_logic_vector(3 downto 0)	is reg_FUNCTIONAL_QUEUE(0)(4 downto 1);
	alias reg_VALID_7	: std_logic	is reg_FUNCTIONAL_QUEUE(7)(0);
	alias reg_VALID_6	: std_logic	is reg_FUNCTIONAL_QUEUE(6)(0);
	alias reg_VALID_5	: std_logic	is reg_FUNCTIONAL_QUEUE(5)(0);
	alias reg_VALID_4	: std_logic	is reg_FUNCTIONAL_QUEUE(4)(0);
	alias reg_VALID_3	: std_logic	is reg_FUNCTIONAL_QUEUE(3)(0);
	alias reg_VALID_2	: std_logic	is reg_FUNCTIONAL_QUEUE(2)(0);
	alias reg_VALID_1	: std_logic	is reg_FUNCTIONAL_QUEUE(1)(0);
	alias reg_VALID_0	: std_logic	is reg_FUNCTIONAL_QUEUE(0)(0);

	-- OOO_ENGINE_ID(1) + PACKET_ID(8) + OPERATION(7) + TYPE (5) +
        -- HAS_IMMEDIAT (1) + DATA_RA (32) + DATA_RB (32) + DATA_RC (2) +
        -- WRITE_RD(1) + NUM_REG_RD(5) + WRITE_RE(1) + NUM_REG_RE(4) + VALID(1)
        -- = 100 BITS

begin
	
	-- 
	-- -----------------------------------
	-- -- Registers                       
	-- -----------------------------------
	-- 

	process (in_CLOCK)
	begin
		if in_CLOCK'event and in_CLOCK = '1' then
			if (in_NRESET = '0') then
				reg_BUSY_IN <= '0';
				reg_BUSY_OUT <= '0';
			else
				-- Input
				if (sig_EXECUTE_IN_ACK = '1') then
					if (in_EXECUTE_IN_OPERATION = "00100") then
						reg_VALID_7 <= in_EXECUTE_IN_VAL;
						reg_NUM_REG_RE_7 <= in_EXECUTE_IN_NUM_REG_RE;
						reg_WRITE_RE_7 <= in_EXECUTE_IN_WRITE_RE;
						reg_NUM_REG_RD_7 <= in_EXECUTE_IN_NUM_REG_RD;
						reg_WRITE_RD_7 <= in_EXECUTE_IN_WRITE_RD;
						reg_DATA_RC_7 <= in_EXECUTE_IN_DATA_RC;
						reg_DATA_RB_7 <= in_EXECUTE_IN_DATA_RB;
						reg_DATA_RA_7 <= in_EXECUTE_IN_DATA_RA;
						reg_IMMEDIAT_7 <= in_EXECUTE_IN_IMMEDIAT;
						reg_HAS_IMMEDIAT_7 <= in_EXECUTE_IN_HAS_IMMEDIAT;
						reg_TYPE_7 <= in_EXECUTE_IN_TYPE;
						reg_OPERATION_7 <= in_EXECUTE_IN_OPERATION;
						reg_PACKET_ID_7 <= in_EXECUTE_IN_PACKET_ID;
						reg_OOO_ENGINE_ID_7 <= in_EXECUTE_IN_OOO_ENGINE_ID;
					else
						reg_VALID_1 <= in_EXECUTE_IN_VAL;
						reg_NUM_REG_RE_1 <= in_EXECUTE_IN_NUM_REG_RE;
						reg_WRITE_RE_1 <= in_EXECUTE_IN_WRITE_RE;
						reg_NUM_REG_RD_1 <= in_EXECUTE_IN_NUM_REG_RD;
						reg_WRITE_RD_1 <= in_EXECUTE_IN_WRITE_RD;
						reg_DATA_RC_1 <= in_EXECUTE_IN_DATA_RC;
						reg_DATA_RB_1 <= in_EXECUTE_IN_DATA_RB;
						reg_DATA_RA_1 <= in_EXECUTE_IN_DATA_RA;
						reg_IMMEDIAT_1 <= in_EXECUTE_IN_IMMEDIAT;
						reg_HAS_IMMEDIAT_1 <= in_EXECUTE_IN_HAS_IMMEDIAT;
						reg_TYPE_1 <= in_EXECUTE_IN_TYPE;
						reg_OPERATION_1 <= in_EXECUTE_IN_OPERATION;
						reg_PACKET_ID_1 <= in_EXECUTE_IN_PACKET_ID;
						reg_OOO_ENGINE_ID_1 <= in_EXECUTE_IN_OOO_ENGINE_ID;

                                        end if;
				end if;
				if (sig_EXECUTE_OUT_UPDATE = '1') then
					reg_VALID_0         <= reg_VALID_1;
					reg_NUM_REG_RE_0    <= reg_NUM_REG_RE_1;
					reg_WRITE_RE_0      <= reg_WRITE_RE_1;
					reg_NUM_REG_RD_0    <= reg_NUM_REG_RD_1;
					reg_WRITE_RD_0      <= reg_WRITE_RD_1;
					reg_DATA_RC_0       <= reg_DATA_RC_1;
					reg_DATA_RB_0       <= reg_DATA_RB_1;
					reg_DATA_RA_0       <= reg_DATA_RA_1;
					reg_IMMEDIAT_0      <= reg_IMMEDIAT_1;
					reg_HAS_IMMEDIAT_0  <= reg_HAS_IMMEDIAT_1;
					reg_TYPE_0          <= reg_TYPE_1;
					reg_OPERATION_0     <= reg_OPERATION_1;
					reg_PACKET_ID_0     <= reg_PACKET_ID_1;
					reg_OOO_ENGINE_ID_0 <= reg_OOO_ENGINE_ID_1;

					reg_VALID_1         <= reg_VALID_2;
					reg_NUM_REG_RE_1    <= reg_NUM_REG_RE_2;
					reg_WRITE_RE_1      <= reg_WRITE_RE_2;
					reg_NUM_REG_RD_1    <= reg_NUM_REG_RD_2;
					reg_WRITE_RD_1      <= reg_WRITE_RD_2;
					reg_DATA_RC_1       <= reg_DATA_RC_2;
					reg_DATA_RB_1       <= reg_DATA_RB_2;
					reg_DATA_RA_1       <= reg_DATA_RA_2;
					reg_IMMEDIAT_1      <= reg_IMMEDIAT_2;
					reg_HAS_IMMEDIAT_1  <= reg_HAS_IMMEDIAT_2;
					reg_TYPE_1          <= reg_TYPE_2;
					reg_OPERATION_1     <= reg_OPERATION_2;
					reg_PACKET_ID_1     <= reg_PACKET_ID_2;
					reg_OOO_ENGINE_ID_1 <= reg_OOO_ENGINE_ID_2;

					reg_VALID_2         <= reg_VALID_3;
					reg_NUM_REG_RE_2    <= reg_NUM_REG_RE_3;
					reg_WRITE_RE_2      <= reg_WRITE_RE_3;
					reg_NUM_REG_RD_2    <= reg_NUM_REG_RD_3;
					reg_WRITE_RD_2      <= reg_WRITE_RD_3;
					reg_DATA_RC_2       <= reg_DATA_RC_3;
					reg_DATA_RB_2       <= reg_DATA_RB_3;
					reg_DATA_RA_2       <= reg_DATA_RA_3;
					reg_IMMEDIAT_2      <= reg_IMMEDIAT_3;
					reg_HAS_IMMEDIAT_2  <= reg_HAS_IMMEDIAT_3;
					reg_TYPE_2          <= reg_TYPE_3;
					reg_OPERATION_2     <= reg_OPERATION_3;
					reg_PACKET_ID_2     <= reg_PACKET_ID_3;
					reg_OOO_ENGINE_ID_2 <= reg_OOO_ENGINE_ID_3;

					reg_VALID_3         <= reg_VALID_4;
					reg_NUM_REG_RE_3    <= reg_NUM_REG_RE_4;
					reg_WRITE_RE_3      <= reg_WRITE_RE_4;
					reg_NUM_REG_RD_3    <= reg_NUM_REG_RD_4;
					reg_WRITE_RD_3      <= reg_WRITE_RD_4;
					reg_DATA_RC_3       <= reg_DATA_RC_4;
					reg_DATA_RB_3       <= reg_DATA_RB_4;
					reg_DATA_RA_3       <= reg_DATA_RA_4;
					reg_IMMEDIAT_3      <= reg_IMMEDIAT_4;
					reg_HAS_IMMEDIAT_3  <= reg_HAS_IMMEDIAT_4;
					reg_TYPE_3          <= reg_TYPE_4;
					reg_OPERATION_3     <= reg_OPERATION_4;
					reg_PACKET_ID_3     <= reg_PACKET_ID_4;
					reg_OOO_ENGINE_ID_3 <= reg_OOO_ENGINE_ID_4;

					reg_VALID_4         <= reg_VALID_5;
					reg_NUM_REG_RE_4    <= reg_NUM_REG_RE_5;
					reg_WRITE_RE_4      <= reg_WRITE_RE_5;
					reg_NUM_REG_RD_4    <= reg_NUM_REG_RD_5;
					reg_WRITE_RD_4      <= reg_WRITE_RD_5;
					reg_DATA_RC_4       <= reg_DATA_RC_5;
					reg_DATA_RB_4       <= reg_DATA_RB_5;
					reg_DATA_RA_4       <= reg_DATA_RA_5;
					reg_IMMEDIAT_4      <= reg_IMMEDIAT_5;
					reg_HAS_IMMEDIAT_4  <= reg_HAS_IMMEDIAT_5;
					reg_TYPE_4          <= reg_TYPE_5;
					reg_OPERATION_4     <= reg_OPERATION_5;
					reg_PACKET_ID_4     <= reg_PACKET_ID_5;
					reg_OOO_ENGINE_ID_4 <= reg_OOO_ENGINE_ID_5;

					reg_VALID_5         <= reg_VALID_6;
					reg_NUM_REG_RE_5    <= reg_NUM_REG_RE_6;
					reg_WRITE_RE_5      <= reg_WRITE_RE_6;
					reg_NUM_REG_RD_5    <= reg_NUM_REG_RD_6;
					reg_WRITE_RD_5      <= reg_WRITE_RD_6;
					reg_DATA_RC_5       <= reg_DATA_RC_6;
					reg_DATA_RB_5       <= reg_DATA_RB_6;
					reg_DATA_RA_5       <= reg_DATA_RA_6;
					reg_IMMEDIAT_5      <= reg_IMMEDIAT_6;
					reg_HAS_IMMEDIAT_5  <= reg_HAS_IMMEDIAT_6;
					reg_TYPE_5          <= reg_TYPE_6;
					reg_OPERATION_5     <= reg_OPERATION_6;
					reg_PACKET_ID_5     <= reg_PACKET_ID_6;
					reg_OOO_ENGINE_ID_5 <= reg_OOO_ENGINE_ID_6;

					reg_VALID_6         <= reg_VALID_7;
					reg_NUM_REG_RE_6    <= reg_NUM_REG_RE_7;
					reg_WRITE_RE_6      <= reg_WRITE_RE_7;
					reg_NUM_REG_RD_6    <= reg_NUM_REG_RD_7;
					reg_WRITE_RD_6      <= reg_WRITE_RD_7;
					reg_DATA_RC_6       <= reg_DATA_RC_7;
					reg_DATA_RB_6       <= reg_DATA_RB_7;
					reg_DATA_RA_6       <= reg_DATA_RA_7;
					reg_IMMEDIAT_6      <= reg_IMMEDIAT_7;
					reg_HAS_IMMEDIAT_6  <= reg_HAS_IMMEDIAT_7;
					reg_TYPE_6          <= reg_TYPE_7;
					reg_OPERATION_6     <= reg_OPERATION_7;
					reg_PACKET_ID_6     <= reg_PACKET_ID_7;
					reg_OOO_ENGINE_ID_6 <= reg_OOO_ENGINE_ID_7;
				end if;
			end if;
		end if;
	end process;
	
	-- 
	-- -----------------------------------
	-- -- Insides                         
	-- -----------------------------------
	-- 
	
	sig_B_OPERAND <= reg_IMMEDIAT_1 when (reg_HAS_IMMEDIAT_1 = '1') else
		reg_DATA_RB_1;
	-- 
	-- ALU
	-- 
	sig_IS_ARITH <= reg_OPERATION_1(0) or reg_OPERATION_1(1) or reg_OPERATION_1(2);
	sig_IS_LOGIC <= reg_OPERATION_1(3) or reg_OPERATION_1(4) or reg_OPERATION_1(5);
	sig_CIN_ARITH <= reg_DATA_RC_1(1) and reg_OPERATION_1(1);
	sig_ARITH_B_OPERAND <= ((not sig_B_OPERAND) + 1) when (reg_OPERATION_1(2) = '1') else
		sig_B_OPERAND;
	sig_RES_ARITH <= ('0' & reg_DATA_RA_1) + ('0' & sig_ARITH_B_OPERAND) + ("000000000000000000000000000000" & sig_CIN_ARITH);
	
	sig_A_AND_B <= reg_DATA_RA_1 and sig_B_OPERAND;
	sig_A_OR_B <= reg_DATA_RA_1 or sig_B_OPERAND;
	sig_A_XOR_B <= reg_DATA_RA_1 xor sig_B_OPERAND;
	
	with reg_OPERATION_1 select
	sig_RES_LOGIC <=
		sig_A_AND_B when "0001000",
		sig_A_OR_B  when "0010000",
		sig_A_XOR_B when "0100000",
		"00000000000000000000000000000000" when others;
	sig_RES_ALU <=
		sig_RES_ARITH (31 downto 0) when (sig_IS_ARITH = '1') else
		sig_RES_LOGIC when (sig_IS_LOGIC = '1') else
		"00000000000000000000000000000000";
	
	-- In ISA l.sub doesn't change carry flag.
	sig_COUT_ALU <= (sig_RES_ARITH(32) and (reg_OPERATION_1(0) or reg_OPERATION_1(1))) or (reg_OPERATION_1(2) and reg_DATA_RC_1(1));
	sig_OVR_ALU <= ((sig_ARITH_B_OPERAND(31) and reg_DATA_RA_1(31) and not sig_RES_ARITH(31)) or (not sig_ARITH_B_OPERAND(31) and not reg_DATA_RA_1(31) and sig_RES_ARITH(31))) and sig_IS_ARITH;
	
	-- 
	-- MOVE
	-- 
	sig_MOVHI <= reg_IMMEDIAT_1(15 downto 0) & "0000000000000000";
	sig_CMOV <=
		reg_DATA_RA_1 when (reg_DATA_RC_1(0) = '1') else
		reg_DATA_RB_1;
	sig_RES_MOVE <=
		sig_MOVHI when (reg_OPERATION_1(0) = '1') else
		sig_CMOV when (reg_OPERATION_1(1) = '1') else
		"00000000000000000000000000000000";
	
	-- 
	-- TEST
	-- 
	sig_IS_LESS <= reg_OPERATION_1(3);
	sig_A_COMPARE <=
		sig_B_OPERAND when (sig_IS_LESS = '1') else
		reg_DATA_RA_1;

	sig_B_COMPARE <=
		reg_DATA_RA_1 when (sig_IS_LESS = '1') else
		sig_B_OPERAND;

	a_gt_b_s : c_compare_v9_0
	  generic map (
	    c_width      => 32,
	    c_data_type  => 0,                -- 0 = signed, 1 = unsigned
	    c_has_a_eq_b => 0,
	    c_has_a_gt_b => 1)
	  port map (
	    a => sig_A_COMPARE,
	    b => sig_B_COMPARE,
	    a_gt_b => sig_A_GT_B_S);

	a_gt_b_u : c_compare_v9_0
	  generic map (
	    c_width      => 32,
	    c_data_type  => 1,                -- 0 = signed, 1 = unsigned
	    c_has_a_eq_b => 0,
	    c_has_a_gt_b => 1)
	  port map (
	    a => sig_A_COMPARE,
	    b => sig_B_COMPARE,
	    a_gt_b => sig_A_GT_B_U);

	a_eq_b : c_compare_v9_0
	  generic map (                       -- sign doesn't matter for
                                              -- equality test
	    c_width      => 32,
	    c_has_a_eq_b => 1,
	    c_has_a_gt_b => 0)
	  port map (
	    a => sig_A_COMPARE,
	    b => sig_B_COMPARE,
	    a_eq_b => sig_A_EQ_B);

	sig_IS_SIGNED <= reg_OPERATION_1(6);
	sig_A_GT_B <=
		sig_A_GT_B_S when (sig_IS_SIGNED = '1') else
		sig_A_GT_B_U;
	sig_A_GE_B <= sig_A_GT_B or sig_A_EQ_B;
	sig_A_NE_B <= not sig_A_EQ_B;
	
	sig_FLAG_F <=
		(sig_A_EQ_B and reg_OPERATION_1(4)) or
		(sig_A_NE_B and reg_OPERATION_1(5)) or
		(sig_A_GE_B and reg_OPERATION_1(0)) or
		(sig_A_GT_B and reg_OPERATION_1(1));
	
	
	-- 
	-- BRANCH
	-- 
	sig_NOSQ_BRANCH <= (reg_DATA_RC_1(0) and reg_OPERATION_1(2)) or (not reg_DATA_RC_1(0) and reg_OPERATION_1(1)) or reg_OPERATION_1(3);
	sig_RES_BRANCH <=
		reg_IMMEDIAT_1(29 downto 0) & "00"when (reg_OPERATION_1(3) = '1') else
		"00000000000000000000000000000000";
	sig_ADDR_BRANCH <=
		reg_DATA_RB_1(31 downto 2) when (reg_OPERATION_1(3) = '1') else
		reg_IMMEDIAT_1(29 downto 0);
	
	-- 
	-- SHIFTER
	-- 
	-- Instance shifter
	instance_Functionnal_unit_0_shifter : Functionnal_unit_0_shifter
	port map (
		  in_SHIFTER_0_DATA      	=>	reg_DATA_RA_1
		, in_SHIFTER_0_SHIFT     	=>	sig_B_OPERAND(4 downto 0)
		, in_SHIFTER_0_DIRECTION 	=>	reg_OPERATION_1(0)
		, in_SHIFTER_0_TYPE      	=>	reg_OPERATION_1(1)
		, in_SHIFTER_0_CARRY     	=>	reg_OPERATION_1(2)
		,out_SHIFTER_0_DATA      	=>	sig_RES_SHIFTER
	);
	
	
	-- 
	-- EXTEND
	-- 
	sig_EXT_BYTE_S <=
		"111111111111111111111111" & reg_DATA_RA_1 (7 downto 0) when (reg_DATA_RA_1 (7) = '1') else
		"000000000000000000000000" & reg_DATA_RA_1 (7 downto 0);
	
	sig_EXT_BYTE_Z <=
		"000000000000000000000000" & reg_DATA_RA_1 (7 downto 0);
	
	sig_EXT_HALF_WORD_S <=
		"1111111111111111" & reg_DATA_RA_1 (15 downto 0) when (reg_DATA_RA_1 (15) = '1') else
		"0000000000000000" & reg_DATA_RA_1 (15 downto 0);
	
	sig_EXT_HALF_WORD_Z <=
		"0000000000000000" & reg_DATA_RA_1 (15 downto 0);
	
	sig_EXT_WORD_S <=
		"" & reg_DATA_RA_1 (31 downto 0) when (reg_DATA_RA_1 (31) = '1') else
		"" & reg_DATA_RA_1 (31 downto 0);
	
	sig_EXT_WORD_Z <=
		"" & reg_DATA_RA_1 (31 downto 0);
	
	sig_EXT_S <=
		sig_EXT_BYTE_S      when (reg_IMMEDIAT_1 = 8)  else
		sig_EXT_HALF_WORD_S when (reg_IMMEDIAT_1 = 16) else
		sig_EXT_WORD_S;
	
	sig_EXT_Z <=
		sig_EXT_BYTE_Z      when (reg_IMMEDIAT_1 = 8)  else
		sig_EXT_HALF_WORD_Z when (reg_IMMEDIAT_1 = 16) else
		sig_EXT_WORD_Z;
	
	sig_RES_EXTEND <=
		sig_EXT_Z      when (reg_OPERATION_1(0) = '1')  else
		sig_EXT_S;
	
	
	-- 
	-- FIND
	-- 
	sig_FF1 <=
		"000001" 	when (reg_DATA_RA_1 (0) = '1') 	else
		"000010" 	when (reg_DATA_RA_1 (1) = '1') 	else
		"000011" 	when (reg_DATA_RA_1 (2) = '1') 	else
		"000100" 	when (reg_DATA_RA_1 (3) = '1') 	else
		"000101" 	when (reg_DATA_RA_1 (4) = '1') 	else
		"000110" 	when (reg_DATA_RA_1 (5) = '1') 	else
		"000111" 	when (reg_DATA_RA_1 (6) = '1') 	else
		"001000" 	when (reg_DATA_RA_1 (7) = '1') 	else
		"001001" 	when (reg_DATA_RA_1 (8) = '1') 	else
		"001010" 	when (reg_DATA_RA_1 (9) = '1') 	else
		"001011" 	when (reg_DATA_RA_1 (10) = '1') 	else
		"001100" 	when (reg_DATA_RA_1 (11) = '1') 	else
		"001101" 	when (reg_DATA_RA_1 (12) = '1') 	else
		"001110" 	when (reg_DATA_RA_1 (13) = '1') 	else
		"001111" 	when (reg_DATA_RA_1 (14) = '1') 	else
		"010000" 	when (reg_DATA_RA_1 (15) = '1') 	else
		"010001" 	when (reg_DATA_RA_1 (16) = '1') 	else
		"010010" 	when (reg_DATA_RA_1 (17) = '1') 	else
		"010011" 	when (reg_DATA_RA_1 (18) = '1') 	else
		"010100" 	when (reg_DATA_RA_1 (19) = '1') 	else
		"010101" 	when (reg_DATA_RA_1 (20) = '1') 	else
		"010110" 	when (reg_DATA_RA_1 (21) = '1') 	else
		"010111" 	when (reg_DATA_RA_1 (22) = '1') 	else
		"011000" 	when (reg_DATA_RA_1 (23) = '1') 	else
		"011001" 	when (reg_DATA_RA_1 (24) = '1') 	else
		"011010" 	when (reg_DATA_RA_1 (25) = '1') 	else
		"011011" 	when (reg_DATA_RA_1 (26) = '1') 	else
		"011100" 	when (reg_DATA_RA_1 (27) = '1') 	else
		"011101" 	when (reg_DATA_RA_1 (28) = '1') 	else
		"011110" 	when (reg_DATA_RA_1 (29) = '1') 	else
		"011111" 	when (reg_DATA_RA_1 (30) = '1') 	else
		"100000" 	when (reg_DATA_RA_1 (31) = '1') 	else
		"000000";
	
	sig_FL1 <=
		"100000" 	when (reg_DATA_RA_1 (31) = '1') 	else
		"011111" 	when (reg_DATA_RA_1 (30) = '1') 	else
		"011110" 	when (reg_DATA_RA_1 (29) = '1') 	else
		"011101" 	when (reg_DATA_RA_1 (28) = '1') 	else
		"011100" 	when (reg_DATA_RA_1 (27) = '1') 	else
		"011011" 	when (reg_DATA_RA_1 (26) = '1') 	else
		"011010" 	when (reg_DATA_RA_1 (25) = '1') 	else
		"011001" 	when (reg_DATA_RA_1 (24) = '1') 	else
		"011000" 	when (reg_DATA_RA_1 (23) = '1') 	else
		"010111" 	when (reg_DATA_RA_1 (22) = '1') 	else
		"010110" 	when (reg_DATA_RA_1 (21) = '1') 	else
		"010101" 	when (reg_DATA_RA_1 (20) = '1') 	else
		"010100" 	when (reg_DATA_RA_1 (19) = '1') 	else
		"010011" 	when (reg_DATA_RA_1 (18) = '1') 	else
		"010010" 	when (reg_DATA_RA_1 (17) = '1') 	else
		"010001" 	when (reg_DATA_RA_1 (16) = '1') 	else
		"010000" 	when (reg_DATA_RA_1 (15) = '1') 	else
		"001111" 	when (reg_DATA_RA_1 (14) = '1') 	else
		"001110" 	when (reg_DATA_RA_1 (13) = '1') 	else
		"001101" 	when (reg_DATA_RA_1 (12) = '1') 	else
		"001100" 	when (reg_DATA_RA_1 (11) = '1') 	else
		"001011" 	when (reg_DATA_RA_1 (10) = '1') 	else
		"001010" 	when (reg_DATA_RA_1 (9) = '1') 	else
		"001001" 	when (reg_DATA_RA_1 (8) = '1') 	else
		"001000" 	when (reg_DATA_RA_1 (7) = '1') 	else
		"000111" 	when (reg_DATA_RA_1 (6) = '1') 	else
		"000110" 	when (reg_DATA_RA_1 (5) = '1') 	else
		"000101" 	when (reg_DATA_RA_1 (4) = '1') 	else
		"000100" 	when (reg_DATA_RA_1 (3) = '1') 	else
		"000011" 	when (reg_DATA_RA_1 (2) = '1') 	else
		"000010" 	when (reg_DATA_RA_1 (1) = '1') 	else
		"000001" 	when (reg_DATA_RA_1 (0) = '1') 	else
		"000000";
	
	sig_RES_FIND <=
		"00000000000000000000000000"&sig_FF1      when (reg_OPERATION_1(0) = '1')  else
		"00000000000000000000000000"&sig_FL1;
	
	
	-- 
	-- SPECIAL
	-- 
	sig_SPR_IS_HERE <=
		'1' when (sig_A_OR_B(15 downto 0) = "00101") else
		'0';
	-- MFSPR
	sig_MFSPR <=
		reg_MACLO(0) when (sig_SPR_IS_HERE = '1' and sig_A_OR_B(10 downto 0) = "00000000001") else
		reg_MACHI(0) when (sig_SPR_IS_HERE = '1' and sig_A_OR_B(10 downto 0) = "00000000010") else
		"00000000000000000000000000000000";
	
	
	-- MTSPR
	process (in_CLOCK)
	begin
		if in_CLOCK'event and in_CLOCK = '1' then
			if (sig_SPR_IS_HERE = '1') then
				if (sig_A_OR_B(10 downto 0) = "00000000001") then
					reg_MACLO(0) <= reg_DATA_RB_1;
				end if;
				if (sig_A_OR_B(10 downto 0) = "00000000010") then
					reg_MACHI(0) <= reg_DATA_RB_1;
				end if;
			end if;
		end if;
	end process;
	
	sig_RES_SPECIAL <=
		sig_MFSPR when (reg_OPERATION_1 = "0000001")  else
		reg_DATA_RB_1 when (reg_OPERATION_1 = "0000010")  else
		"00000000000000000000000000000000";
	
	-- 
	-- TRANSACTION
	-- 
	sig_BUSY <=
--		reg_FUNCTIONAL_QUEUE(34)(0) when in_EXECUTE_IN_OPERATION = "" else
		reg_FUNCTIONAL_QUEUE(7)(0)  when in_EXECUTE_IN_OPERATION = "" else
		reg_FUNCTIONAL_QUEUE(1)(0);
	sig_EXECUTE_OUT_VAL <= reg_FUNCTIONAL_QUEUE(0)(0);
	sig_EXECUTE_OUT_UPDATE <= not reg_FUNCTIONAL_QUEUE(0)(0) or in_EXECUTE_OUT_ACK;
	sig_EXECUTE_IN_ACK <= not sig_BUSY or sig_EXECUTE_OUT_UPDATE;
	
	-- 
	-- -----------------------------------
	-- --                                  
	-- -----------------------------------
	-- 
	
	sig_EXECUTE_OUT_OOO_ENGINE_ID <= reg_OOO_ENGINE_ID_1;
	sig_EXECUTE_OUT_PACKET_ID <= reg_EXECUTE_IN_PACKET_ID;
	sig_EXECUTE_OUT_WRITE_RD <=  reg_WRITE_RD_1;
	sig_EXECUTE_OUT_NUM_REG_RD <= reg_NUM_REG_RD_1;
	with reg_TYPE_1 select
	sig_EXECUTE_OUT_DATA_RD <=
		sig_RES_ALU when "00000",
		sig_RES_MOVE when "00010",
		sig_RES_BRANCH when "01010",
		sig_RES_SHIFTER when "00001",
		sig_RES_EXTEND when "00110",
		sig_RES_FIND when "00111",
		sig_RES_SPECIAL when "01000",
		"00000000000000000000000000000000" when others;
	sig_EXECUTE_OUT_WRITE_RE <= reg_WRITE_RE_1;
	sig_EXECUTE_OUT_NUM_REG_RE <= reg_NUM_REG_RE_1;
	with reg_TYPE_1 select
	sig_EXECUTE_OUT_DATA_RE <=
		sig_COUT_ALU & sig_OVR_ALU when "00000",
		'0' & sig_FLAG_F when "00011",
		"00" when others;
	sig_EXECUTE_OUT_EXCEPTION <=
		"01011" when (reg_TYPE_1 = "00000" and sig_OVR_ALU = '1') else
		"10011" when (reg_TYPE_1 = "01000" and reg_OPERATION_1 = "0000001" and sig_SPR_IS_HERE = '0') else
		"10100" when (reg_TYPE_1 = "01000" and reg_OPERATION_1 = "0000010" and sig_SPR_IS_HERE = '0') else
		"00000";
	with reg_TYPE_1 select
	sig_EXECUTE_OUT_NO_SEQUENCE <=
		sig_NOSQ_BRANCH when "01010",
		'0'when others;
	with reg_TYPE_1 select
	sig_EXECUTE_OUT_ADDRESS <=
		sig_ADDR_BRANCH when "01010",
		sig_A_OR_B(29 downto 0) when "01000",
		"000000000000000000000000000000" when others;
	
	-- 
	-- -----------------------------------
	-- -- Outputs                          
	-- -----------------------------------
	-- 
	
	out_EXECUTE_OUT_OOO_ENGINE_ID <= reg_EXECUTE_OUT_OOO_ENGINE_ID;
	out_EXECUTE_OUT_PACKET_ID <= reg_EXECUTE_OUT_PACKET_ID;
	out_EXECUTE_OUT_WRITE_RD <=  reg_EXECUTE_OUT_WRITE_RD;
	out_EXECUTE_OUT_NUM_REG_RD <= reg_EXECUTE_OUT_NUM_REG_RD;
	out_EXECUTE_OUT_DATA_RD <= reg_EXECUTE_OUT_DATA_RD;
	out_EXECUTE_OUT_WRITE_RE <= reg_EXECUTE_OUT_WRITE_RE;
	out_EXECUTE_OUT_NUM_REG_RE <= reg_EXECUTE_OUT_NUM_REG_RE;
	out_EXECUTE_OUT_DATA_RE <= reg_EXECUTE_OUT_DATA_RE;
	out_EXECUTE_OUT_EXCEPTION <= reg_EXECUTE_OUT_EXCEPTION;
	out_EXECUTE_OUT_NO_SEQUENCE <= reg_EXECUTE_OUT_NO_SEQUENCE;
	out_EXECUTE_OUT_ADDRESS <= reg_EXECUTE_OUT_ADDRESS;
	out_EXECUTE_OUT_VAL <= sig_EXECUTE_OUT_VAL;
	out_EXECUTE_IN_ACK <= sig_EXECUTE_IN_ACK;

end behavioural;

