#ifdef STATISTICS
/*
 * $Id: Load_store_unit_statistics_allocation.cpp 110 2009-02-19 16:31:47Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Execute_unit/Execute_unit/Load_store_unit/include/Load_store_unit.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_execute_unit {
namespace execute_unit {
namespace load_store_unit {


#undef  FUNCTION
#define FUNCTION "Load_store_unit::statistics_allocation"
  void Load_store_unit::statistics_allocation (morpheo::behavioural::Parameters_Statistics * param_statistics)
  {
    log_printf(FUNC,Load_store_unit,FUNCTION,"Begin");

    _stat = new Stat (static_cast<std::string>(_name),
		      "Load_store_unit",
		      param_statistics);

    _stat_use_store_queue                      = _stat->create_variable("use_store_queue");
    _stat_use_load_queue                       = _stat->create_variable("use_load_queue");
    _stat_use_speculative_access_queue         = _stat->create_variable("use_speculative_access_queue");

    _stat_average_use_store_queue              = _stat->create_counter("average_use_store_queue"              , "", "Average by cycle of the store_queue occupation ");
    _stat_average_use_load_queue               = _stat->create_counter("average_use_load_queue"               , "", "Average by cycle of the load_queue occupation");
    _stat_average_use_speculative_access_queue = _stat->create_counter("average_use_speculative_access_queue" , "", "Average by cycle of the speculative_access_queue occupation");

    _stat_percent_use_store_queue              = _stat->create_counter("percent_use_store_queue"              , "%", "Percent of store_queue usage");
    _stat_percent_use_load_queue               = _stat->create_counter("percent_use_load_queue"               , "%", "Percent of load_queue usage");
    _stat_percent_use_speculative_access_queue = _stat->create_counter("percent_use_speculative_access_queue" , "%", "Percent of speculative_access_queue usage");

    _stat->create_expr("average_use_store_queue"             , "/ use_store_queue              cycle", false);
    _stat->create_expr("average_use_load_queue"              , "/ use_load_queue               cycle", false);
    _stat->create_expr("average_use_speculative_access_queue", "/ use_speculative_access_queue cycle", false);

    _stat->create_expr("percent_use_store_queue"              , "/ * average_use_store_queue              100 " + toString(_param->_size_store_queue             ), false);
    _stat->create_expr("percent_use_load_queue"               , "/ * average_use_load_queue               100 " + toString(_param->_size_load_queue              ), false);
    _stat->create_expr("percent_use_speculative_access_queue" , "/ * average_use_speculative_access_queue 100 " + toString(_param->_size_speculative_access_queue), false);


    _stat_nb_inst_load                         = _stat->create_variable("nb_inst_load"                   );
    _stat_nb_inst_load_commit_speculative      = _stat->create_variable("nb_inst_load_commit_speculative");
    _stat_nb_inst_load_commit_miss             = _stat->create_variable("nb_inst_load_commit_miss"       );

    _stat->create_expr_percent("percent_nb_inst_load_commit_speculative","nb_inst_load_commit_speculative", "nb_inst_load"                   , "Percent of load instruction with a speculative commit ");
    _stat->create_expr_percent("percent_nb_inst_load_commit_miss"       ,"nb_inst_load_commit_miss"       , "nb_inst_load_commit_speculative", "Percent of load instruction with a miss speculative commit");


    log_printf(FUNC,Load_store_unit,FUNCTION,"End");
  };

}; // end namespace load_store_unit
}; // end namespace execute_unit
}; // end namespace multi_execute_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
