/*
 * $Id: Read_unit_to_Execution_unit.cpp 136 2009-10-20 18:52:15Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Network/Read_unit_to_Execution_unit/include/Read_unit_to_Execution_unit.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace network {
namespace read_unit_to_execution_unit {


#undef  FUNCTION
#define FUNCTION "Read_unit_to_Execution_unit::Read_unit_to_Execution_unit"
  Read_unit_to_Execution_unit::Read_unit_to_Execution_unit 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   string name,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   morpheo::behavioural::core::multi_execute_loop::execute_loop::network::read_unit_to_execution_unit::Parameters * param,
   morpheo::behavioural::Tusage_t usage
   ):
    _name              (name)
    ,_param            (param)
    ,_usage            (usage)
  {
    log_printf(FUNC,Read_unit_to_Execution_unit,FUNCTION,_("<%s> Begin"),_name.c_str());

// #if DEBUG_Read_unit_to_Execution_unit == true
//     log_printf(INFO,Read_unit_to_Execution_unit,FUNCTION,_("<%s> Parameters"),_name.c_str());

//     std::cout << *param << std::endl;
// #endif    

    log_printf(INFO,Read_unit_to_Execution_unit,FUNCTION,_("<%s> Allocation"),_name.c_str());

    allocation (
#ifdef STATISTICS
		param_statistics
#endif
		);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {	
	log_printf(INFO,Read_unit_to_Execution_unit,FUNCTION,_("<%s> Allocation of statistics"),_name.c_str());

	statistics_declaration(param_statistics);
      }
#endif

#ifdef VHDL
    if (usage_is_set(_usage,USE_VHDL))
      {
	// generate the vhdl
	log_printf(INFO,Read_unit_to_Execution_unit,FUNCTION,_("<%s> Generate the vhdl"),_name.c_str());
	
	vhdl();
      }
#endif

#ifdef SYSTEMC
    if (usage_is_set(_usage,USE_SYSTEMC))
      {
	log_printf(INFO,Read_unit_to_Execution_unit,FUNCTION,_("<%s> Method - transition"),_name.c_str());

	SC_METHOD (transition);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).pos();
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    

	log_printf(INFO,Read_unit_to_Execution_unit,FUNCTION,_("<%s> Method - genMealy"),_name.c_str());

	SC_METHOD (genMealy);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).neg()
		  << (*(in_NRESET));

	for (uint32_t i=0; i<_param->_nb_read_unit; i++)
	  for (uint32_t j=0; j<_param->_nb_read_unit_port[i]; j++)
	    {
	      sensitive << (*(in_READ_UNIT_OUT_VAL                   [i][j]))
			<< (*(in_READ_UNIT_OUT_OPERATION             [i][j]))
			<< (*(in_READ_UNIT_OUT_TYPE                  [i][j]))
			<< (*(in_READ_UNIT_OUT_CANCEL                [i][j]))
			<< (*(in_READ_UNIT_OUT_HAS_IMMEDIAT          [i][j]))
			<< (*(in_READ_UNIT_OUT_IMMEDIAT              [i][j]))
			<< (*(in_READ_UNIT_OUT_DATA_RA               [i][j]))
			<< (*(in_READ_UNIT_OUT_DATA_RB               [i][j]))
			<< (*(in_READ_UNIT_OUT_DATA_RC               [i][j]))
			<< (*(in_READ_UNIT_OUT_WRITE_RD              [i][j]))
			<< (*(in_READ_UNIT_OUT_NUM_REG_RD            [i][j]))
			<< (*(in_READ_UNIT_OUT_WRITE_RE              [i][j]))
			<< (*(in_READ_UNIT_OUT_NUM_REG_RE            [i][j]))
			<< (*(in_READ_UNIT_OUT_STORE_QUEUE_PTR_WRITE [i][j]))
			<< (*(in_READ_UNIT_OUT_STORE_QUEUE_PTR_READ  [i][j]))
			<< (*(in_READ_UNIT_OUT_STORE_QUEUE_EMPTY     [i][j]));

	      if (_param->_have_port_load_queue_ptr)
	      sensitive  << (*(in_READ_UNIT_OUT_LOAD_QUEUE_PTR_WRITE  [i][j]));
	      if (_param->_have_port_context_id)
	      sensitive  << (*(in_READ_UNIT_OUT_CONTEXT_ID            [i][j]));
	      if (_param->_have_port_front_end_id)
	      sensitive  << (*(in_READ_UNIT_OUT_FRONT_END_ID          [i][j]));
	      if (_param->_have_port_ooo_engine_id)
	      sensitive  << (*(in_READ_UNIT_OUT_OOO_ENGINE_ID         [i][j]));
	      if (_param->_have_port_rob_ptr  )
	      sensitive  << (*(in_READ_UNIT_OUT_PACKET_ID             [i][j]));
	    }
	
	for (uint32_t i=0; i<_param->_nb_execute_unit; i++)
	  for (uint32_t j=0; j<_param->_nb_execute_unit_port[i]; j++)
	    sensitive << (*(in_EXECUTE_UNIT_IN_ACK [i][j]));
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
	for (uint32_t i=0; i<_param->_nb_read_unit; i++)
	  for (uint32_t j=0; j<_param->_nb_read_unit_port[i]; j++)
	  {
	    (*(out_READ_UNIT_OUT_ACK [i][j])) (*(in_READ_UNIT_OUT_VAL           [i][j]));
	    (*(out_READ_UNIT_OUT_ACK [i][j])) (*(in_READ_UNIT_OUT_TYPE          [i][j]));
	    if (_param->_have_port_context_id)
	    (*(out_READ_UNIT_OUT_ACK [i][j])) (*(in_READ_UNIT_OUT_CONTEXT_ID    [i][j]));
	    if (_param->_have_port_front_end_id)
	    (*(out_READ_UNIT_OUT_ACK [i][j])) (*(in_READ_UNIT_OUT_FRONT_END_ID  [i][j]));
	    if (_param->_have_port_ooo_engine_id)
	    (*(out_READ_UNIT_OUT_ACK [i][j])) (*(in_READ_UNIT_OUT_OOO_ENGINE_ID [i][j]));

	    for (uint32_t x=0; x<_param->_nb_execute_unit; x++)
	      for (uint32_t y=0; y<_param->_nb_execute_unit_port[x]; y++)
	      (*(out_READ_UNIT_OUT_ACK [i][j])) (*(in_EXECUTE_UNIT_IN_ACK [x][y]));
	  }

	for (uint32_t i=0; i<_param->_nb_execute_unit; i++)
	  for (uint32_t j=0; j<_param->_nb_execute_unit_port[i]; j++)
	  {
	    (*(out_EXECUTE_UNIT_IN_VAL [i][j])) (*(in_EXECUTE_UNIT_IN_ACK [i][j]));

	    for (uint32_t x=0; x<_param->_nb_read_unit; x++)
	      for (uint32_t y=0; y<_param->_nb_read_unit_port[x]; y++)
	      {
		(*(out_EXECUTE_UNIT_IN_VAL [i][j])) (*(in_READ_UNIT_OUT_VAL           [x][y]));
		(*(out_EXECUTE_UNIT_IN_VAL [i][j])) (*(in_READ_UNIT_OUT_TYPE          [x][y]));
		if (_param->_have_port_context_id)
		(*(out_EXECUTE_UNIT_IN_VAL [i][j])) (*(in_READ_UNIT_OUT_CONTEXT_ID    [x][y]));
		if (_param->_have_port_front_end_id)
		(*(out_EXECUTE_UNIT_IN_VAL [i][j])) (*(in_READ_UNIT_OUT_FRONT_END_ID  [x][y]));
		if (_param->_have_port_ooo_engine_id)
		(*(out_EXECUTE_UNIT_IN_VAL [i][j])) (*(in_READ_UNIT_OUT_OOO_ENGINE_ID [x][y]));
	      }

	    if (_param->_have_port_context_id)
	      {
	    (*(out_EXECUTE_UNIT_IN_CONTEXT_ID [i][j])) (*(in_EXECUTE_UNIT_IN_ACK [i][j]));

	    for (uint32_t x=0; x<_param->_nb_read_unit; x++)
	      for (uint32_t y=0; y<_param->_nb_read_unit_port[x]; y++)
	      {
		(*(out_EXECUTE_UNIT_IN_CONTEXT_ID [i][j])) (*(in_READ_UNIT_OUT_VAL           [x][y]));
		(*(out_EXECUTE_UNIT_IN_CONTEXT_ID [i][j])) (*(in_READ_UNIT_OUT_TYPE          [x][y]));
		if (_param->_have_port_context_id)
		(*(out_EXECUTE_UNIT_IN_CONTEXT_ID [i][j])) (*(in_READ_UNIT_OUT_CONTEXT_ID    [x][y]));
		if (_param->_have_port_front_end_id)
		(*(out_EXECUTE_UNIT_IN_CONTEXT_ID [i][j])) (*(in_READ_UNIT_OUT_FRONT_END_ID  [x][y]));
		if (_param->_have_port_ooo_engine_id)
		(*(out_EXECUTE_UNIT_IN_CONTEXT_ID [i][j])) (*(in_READ_UNIT_OUT_OOO_ENGINE_ID [x][y]));
	      }
	      }

	    if (_param->_have_port_front_end_id)
	      {
	    (*(out_EXECUTE_UNIT_IN_FRONT_END_ID [i][j])) (*(in_EXECUTE_UNIT_IN_ACK [i][j]));

	    for (uint32_t x=0; x<_param->_nb_read_unit; x++)
	      for (uint32_t y=0; y<_param->_nb_read_unit_port[x]; y++)
	      {
		(*(out_EXECUTE_UNIT_IN_FRONT_END_ID [i][j])) (*(in_READ_UNIT_OUT_VAL           [x][y]));
		(*(out_EXECUTE_UNIT_IN_FRONT_END_ID [i][j])) (*(in_READ_UNIT_OUT_TYPE          [x][y]));
		if (_param->_have_port_context_id)
		(*(out_EXECUTE_UNIT_IN_FRONT_END_ID [i][j])) (*(in_READ_UNIT_OUT_CONTEXT_ID    [x][y]));
		if (_param->_have_port_front_end_id)
		(*(out_EXECUTE_UNIT_IN_FRONT_END_ID [i][j])) (*(in_READ_UNIT_OUT_FRONT_END_ID  [x][y]));
		if (_param->_have_port_ooo_engine_id)
		(*(out_EXECUTE_UNIT_IN_FRONT_END_ID [i][j])) (*(in_READ_UNIT_OUT_OOO_ENGINE_ID [x][y]));
	      }
	      }

	    if (_param->_have_port_ooo_engine_id)
	      {
	    (*(out_EXECUTE_UNIT_IN_OOO_ENGINE_ID [i][j])) (*(in_EXECUTE_UNIT_IN_ACK [i][j]));

	    for (uint32_t x=0; x<_param->_nb_read_unit; x++)
	      for (uint32_t y=0; y<_param->_nb_read_unit_port[x]; y++)
	      {
		(*(out_EXECUTE_UNIT_IN_OOO_ENGINE_ID [i][j])) (*(in_READ_UNIT_OUT_VAL           [x][y]));
		(*(out_EXECUTE_UNIT_IN_OOO_ENGINE_ID [i][j])) (*(in_READ_UNIT_OUT_TYPE          [x][y]));
		if (_param->_have_port_context_id)
		(*(out_EXECUTE_UNIT_IN_OOO_ENGINE_ID [i][j])) (*(in_READ_UNIT_OUT_CONTEXT_ID    [x][y]));
		if (_param->_have_port_front_end_id)
		(*(out_EXECUTE_UNIT_IN_OOO_ENGINE_ID [i][j])) (*(in_READ_UNIT_OUT_FRONT_END_ID  [x][y]));
		if (_param->_have_port_ooo_engine_id)
		(*(out_EXECUTE_UNIT_IN_OOO_ENGINE_ID [i][j])) (*(in_READ_UNIT_OUT_OOO_ENGINE_ID [x][y]));
	      }
	      }

	    if (_param->_have_port_rob_ptr  )
	      {
	    (*(out_EXECUTE_UNIT_IN_PACKET_ID [i][j])) (*(in_EXECUTE_UNIT_IN_ACK [i][j]));

	    for (uint32_t x=0; x<_param->_nb_read_unit; x++)
	      for (uint32_t y=0; y<_param->_nb_read_unit_port[x]; y++)
	      {
		(*(out_EXECUTE_UNIT_IN_PACKET_ID [i][j])) (*(in_READ_UNIT_OUT_PACKET_ID     [x][y]));
		(*(out_EXECUTE_UNIT_IN_PACKET_ID [i][j])) (*(in_READ_UNIT_OUT_VAL           [x][y]));
		(*(out_EXECUTE_UNIT_IN_PACKET_ID [i][j])) (*(in_READ_UNIT_OUT_TYPE          [x][y]));
		if (_param->_have_port_context_id)
		(*(out_EXECUTE_UNIT_IN_PACKET_ID [i][j])) (*(in_READ_UNIT_OUT_CONTEXT_ID    [x][y]));
		if (_param->_have_port_front_end_id)
		(*(out_EXECUTE_UNIT_IN_PACKET_ID [i][j])) (*(in_READ_UNIT_OUT_FRONT_END_ID  [x][y]));
		if (_param->_have_port_ooo_engine_id)
		(*(out_EXECUTE_UNIT_IN_PACKET_ID [i][j])) (*(in_READ_UNIT_OUT_OOO_ENGINE_ID [x][y]));
	      }
	      }

	    (*(out_EXECUTE_UNIT_IN_OPERATION [i][j])) (*(in_EXECUTE_UNIT_IN_ACK [i][j]));

	    for (uint32_t x=0; x<_param->_nb_read_unit; x++)
	      for (uint32_t y=0; y<_param->_nb_read_unit_port[x]; y++)
	      {
		(*(out_EXECUTE_UNIT_IN_OPERATION [i][j])) (*(in_READ_UNIT_OUT_OPERATION     [x][y]));
		(*(out_EXECUTE_UNIT_IN_OPERATION [i][j])) (*(in_READ_UNIT_OUT_VAL           [x][y]));
		(*(out_EXECUTE_UNIT_IN_OPERATION [i][j])) (*(in_READ_UNIT_OUT_TYPE          [x][y]));
		if (_param->_have_port_context_id)
		(*(out_EXECUTE_UNIT_IN_OPERATION [i][j])) (*(in_READ_UNIT_OUT_CONTEXT_ID    [x][y]));
		if (_param->_have_port_front_end_id)
		(*(out_EXECUTE_UNIT_IN_OPERATION [i][j])) (*(in_READ_UNIT_OUT_FRONT_END_ID  [x][y]));
		if (_param->_have_port_ooo_engine_id)
		(*(out_EXECUTE_UNIT_IN_OPERATION [i][j])) (*(in_READ_UNIT_OUT_OOO_ENGINE_ID [x][y]));
	      }

	    (*(out_EXECUTE_UNIT_IN_TYPE [i][j])) (*(in_EXECUTE_UNIT_IN_ACK [i][j]));

	    for (uint32_t x=0; x<_param->_nb_read_unit; x++)
	      for (uint32_t y=0; y<_param->_nb_read_unit_port[x]; y++)
	      {
		(*(out_EXECUTE_UNIT_IN_TYPE [i][j])) (*(in_READ_UNIT_OUT_VAL           [x][y]));
		(*(out_EXECUTE_UNIT_IN_TYPE [i][j])) (*(in_READ_UNIT_OUT_TYPE          [x][y]));
		if (_param->_have_port_context_id)
		(*(out_EXECUTE_UNIT_IN_TYPE [i][j])) (*(in_READ_UNIT_OUT_CONTEXT_ID    [x][y]));
		if (_param->_have_port_front_end_id)
		(*(out_EXECUTE_UNIT_IN_TYPE [i][j])) (*(in_READ_UNIT_OUT_FRONT_END_ID  [x][y]));
		if (_param->_have_port_ooo_engine_id)
		(*(out_EXECUTE_UNIT_IN_TYPE [i][j])) (*(in_READ_UNIT_OUT_OOO_ENGINE_ID [x][y]));
	      }

	    (*(out_EXECUTE_UNIT_IN_STORE_QUEUE_PTR_WRITE [i][j])) (*(in_EXECUTE_UNIT_IN_ACK [i][j]));

	    for (uint32_t x=0; x<_param->_nb_read_unit; x++)
	      for (uint32_t y=0; y<_param->_nb_read_unit_port[x]; y++)
	      {
		(*(out_EXECUTE_UNIT_IN_STORE_QUEUE_PTR_WRITE [i][j])) (*(in_READ_UNIT_OUT_STORE_QUEUE_PTR_WRITE [x][y]));
		(*(out_EXECUTE_UNIT_IN_STORE_QUEUE_PTR_WRITE [i][j])) (*(in_READ_UNIT_OUT_VAL                   [x][y]));
		(*(out_EXECUTE_UNIT_IN_STORE_QUEUE_PTR_WRITE [i][j])) (*(in_READ_UNIT_OUT_TYPE                  [x][y]));
		if (_param->_have_port_context_id)
		(*(out_EXECUTE_UNIT_IN_STORE_QUEUE_PTR_WRITE [i][j])) (*(in_READ_UNIT_OUT_CONTEXT_ID            [x][y]));
		if (_param->_have_port_front_end_id)
		(*(out_EXECUTE_UNIT_IN_STORE_QUEUE_PTR_WRITE [i][j])) (*(in_READ_UNIT_OUT_FRONT_END_ID          [x][y]));
		if (_param->_have_port_ooo_engine_id)
		(*(out_EXECUTE_UNIT_IN_STORE_QUEUE_PTR_WRITE [i][j])) (*(in_READ_UNIT_OUT_OOO_ENGINE_ID [x][y]));
	      }

	    if (_param->_have_port_load_queue_ptr)
	      {
	    (*(out_EXECUTE_UNIT_IN_LOAD_QUEUE_PTR_WRITE [i][j])) (*(in_EXECUTE_UNIT_IN_ACK [i][j]));

	    for (uint32_t x=0; x<_param->_nb_read_unit; x++)
	      for (uint32_t y=0; y<_param->_nb_read_unit_port[x]; y++)
	      {
		(*(out_EXECUTE_UNIT_IN_LOAD_QUEUE_PTR_WRITE [i][j])) (*(in_READ_UNIT_OUT_LOAD_QUEUE_PTR_WRITE [x][y]));
		(*(out_EXECUTE_UNIT_IN_LOAD_QUEUE_PTR_WRITE [i][j])) (*(in_READ_UNIT_OUT_VAL                  [x][y]));
		(*(out_EXECUTE_UNIT_IN_LOAD_QUEUE_PTR_WRITE [i][j])) (*(in_READ_UNIT_OUT_TYPE                 [x][y]));
		if (_param->_have_port_context_id)
		(*(out_EXECUTE_UNIT_IN_LOAD_QUEUE_PTR_WRITE [i][j])) (*(in_READ_UNIT_OUT_CONTEXT_ID           [x][y]));
		if (_param->_have_port_front_end_id)
		(*(out_EXECUTE_UNIT_IN_LOAD_QUEUE_PTR_WRITE [i][j])) (*(in_READ_UNIT_OUT_FRONT_END_ID         [x][y]));
		if (_param->_have_port_ooo_engine_id)
		(*(out_EXECUTE_UNIT_IN_LOAD_QUEUE_PTR_WRITE [i][j])) (*(in_READ_UNIT_OUT_OOO_ENGINE_ID        [x][y]));
	      }
	      }
	    
	    (*(out_EXECUTE_UNIT_IN_HAS_IMMEDIAT [i][j])) (*(in_EXECUTE_UNIT_IN_ACK [i][j]));

	    for (uint32_t x=0; x<_param->_nb_read_unit; x++)
	      for (uint32_t y=0; y<_param->_nb_read_unit_port[x]; y++)
	      {
		(*(out_EXECUTE_UNIT_IN_HAS_IMMEDIAT [i][j])) (*(in_READ_UNIT_OUT_HAS_IMMEDIAT  [x][y]));
		(*(out_EXECUTE_UNIT_IN_HAS_IMMEDIAT [i][j])) (*(in_READ_UNIT_OUT_VAL           [x][y]));
		(*(out_EXECUTE_UNIT_IN_HAS_IMMEDIAT [i][j])) (*(in_READ_UNIT_OUT_TYPE          [x][y]));
		if (_param->_have_port_context_id)
		(*(out_EXECUTE_UNIT_IN_HAS_IMMEDIAT [i][j])) (*(in_READ_UNIT_OUT_CONTEXT_ID    [x][y]));
		if (_param->_have_port_front_end_id)
		(*(out_EXECUTE_UNIT_IN_HAS_IMMEDIAT [i][j])) (*(in_READ_UNIT_OUT_FRONT_END_ID  [x][y]));
		if (_param->_have_port_ooo_engine_id)
		(*(out_EXECUTE_UNIT_IN_HAS_IMMEDIAT [i][j])) (*(in_READ_UNIT_OUT_OOO_ENGINE_ID [x][y]));
	      }

	    (*(out_EXECUTE_UNIT_IN_IMMEDIAT [i][j])) (*(in_EXECUTE_UNIT_IN_ACK [i][j]));

	    for (uint32_t x=0; x<_param->_nb_read_unit; x++)
	      for (uint32_t y=0; y<_param->_nb_read_unit_port[x]; y++)
	      {
		(*(out_EXECUTE_UNIT_IN_IMMEDIAT [i][j])) (*(in_READ_UNIT_OUT_IMMEDIAT      [x][y]));
		(*(out_EXECUTE_UNIT_IN_IMMEDIAT [i][j])) (*(in_READ_UNIT_OUT_VAL           [x][y]));
		(*(out_EXECUTE_UNIT_IN_IMMEDIAT [i][j])) (*(in_READ_UNIT_OUT_TYPE          [x][y]));
		if (_param->_have_port_context_id)
		(*(out_EXECUTE_UNIT_IN_IMMEDIAT [i][j])) (*(in_READ_UNIT_OUT_CONTEXT_ID    [x][y]));
		if (_param->_have_port_front_end_id)
		(*(out_EXECUTE_UNIT_IN_IMMEDIAT [i][j])) (*(in_READ_UNIT_OUT_FRONT_END_ID  [x][y]));
		if (_param->_have_port_ooo_engine_id)
		(*(out_EXECUTE_UNIT_IN_IMMEDIAT [i][j])) (*(in_READ_UNIT_OUT_OOO_ENGINE_ID [x][y]));
	      }

	    (*(out_EXECUTE_UNIT_IN_DATA_RA [i][j])) (*(in_EXECUTE_UNIT_IN_ACK [i][j]));

	    for (uint32_t x=0; x<_param->_nb_read_unit; x++)
	      for (uint32_t y=0; y<_param->_nb_read_unit_port[x]; y++)
	      {
		(*(out_EXECUTE_UNIT_IN_DATA_RA [i][j])) (*(in_READ_UNIT_OUT_DATA_RA       [x][y]));
		(*(out_EXECUTE_UNIT_IN_DATA_RA [i][j])) (*(in_READ_UNIT_OUT_VAL           [x][y]));
		(*(out_EXECUTE_UNIT_IN_DATA_RA [i][j])) (*(in_READ_UNIT_OUT_TYPE          [x][y]));
		if (_param->_have_port_context_id)
		(*(out_EXECUTE_UNIT_IN_DATA_RA [i][j])) (*(in_READ_UNIT_OUT_CONTEXT_ID    [x][y]));
		if (_param->_have_port_front_end_id)
		(*(out_EXECUTE_UNIT_IN_DATA_RA [i][j])) (*(in_READ_UNIT_OUT_FRONT_END_ID  [x][y]));
		if (_param->_have_port_ooo_engine_id)
		(*(out_EXECUTE_UNIT_IN_DATA_RA [i][j])) (*(in_READ_UNIT_OUT_OOO_ENGINE_ID [x][y]));
	      }

	    (*(out_EXECUTE_UNIT_IN_DATA_RB [i][j])) (*(in_EXECUTE_UNIT_IN_ACK [i][j]));

	    for (uint32_t x=0; x<_param->_nb_read_unit; x++)
	      for (uint32_t y=0; y<_param->_nb_read_unit_port[x]; y++)
	      {
		(*(out_EXECUTE_UNIT_IN_DATA_RB [i][j])) (*(in_READ_UNIT_OUT_DATA_RB       [x][y]));
		(*(out_EXECUTE_UNIT_IN_DATA_RB [i][j])) (*(in_READ_UNIT_OUT_VAL           [x][y]));
		(*(out_EXECUTE_UNIT_IN_DATA_RB [i][j])) (*(in_READ_UNIT_OUT_TYPE          [x][y]));
		if (_param->_have_port_context_id)
		(*(out_EXECUTE_UNIT_IN_DATA_RB [i][j])) (*(in_READ_UNIT_OUT_CONTEXT_ID    [x][y]));
		if (_param->_have_port_front_end_id)
		(*(out_EXECUTE_UNIT_IN_DATA_RB [i][j])) (*(in_READ_UNIT_OUT_FRONT_END_ID  [x][y]));
		if (_param->_have_port_ooo_engine_id)
		(*(out_EXECUTE_UNIT_IN_DATA_RB [i][j])) (*(in_READ_UNIT_OUT_OOO_ENGINE_ID [x][y]));
	      }

	    (*(out_EXECUTE_UNIT_IN_DATA_RC [i][j])) (*(in_EXECUTE_UNIT_IN_ACK [i][j]));

	    for (uint32_t x=0; x<_param->_nb_read_unit; x++)
	      for (uint32_t y=0; y<_param->_nb_read_unit_port[x]; y++)
	      {
		(*(out_EXECUTE_UNIT_IN_DATA_RC [i][j])) (*(in_READ_UNIT_OUT_DATA_RC       [x][y]));
		(*(out_EXECUTE_UNIT_IN_DATA_RC [i][j])) (*(in_READ_UNIT_OUT_VAL           [x][y]));
		(*(out_EXECUTE_UNIT_IN_DATA_RC [i][j])) (*(in_READ_UNIT_OUT_TYPE          [x][y]));
		if (_param->_have_port_context_id)
		(*(out_EXECUTE_UNIT_IN_DATA_RC [i][j])) (*(in_READ_UNIT_OUT_CONTEXT_ID    [x][y]));
		if (_param->_have_port_front_end_id)
		(*(out_EXECUTE_UNIT_IN_DATA_RC [i][j])) (*(in_READ_UNIT_OUT_FRONT_END_ID  [x][y]));
		if (_param->_have_port_ooo_engine_id)
		(*(out_EXECUTE_UNIT_IN_DATA_RC [i][j])) (*(in_READ_UNIT_OUT_OOO_ENGINE_ID [x][y]));
	      }

	    (*(out_EXECUTE_UNIT_IN_WRITE_RD [i][j])) (*(in_EXECUTE_UNIT_IN_ACK [i][j]));

	    for (uint32_t x=0; x<_param->_nb_read_unit; x++)
	      for (uint32_t y=0; y<_param->_nb_read_unit_port[x]; y++)
	      {
		(*(out_EXECUTE_UNIT_IN_WRITE_RD [i][j])) (*(in_READ_UNIT_OUT_WRITE_RD      [x][y]));
		(*(out_EXECUTE_UNIT_IN_WRITE_RD [i][j])) (*(in_READ_UNIT_OUT_VAL           [x][y]));
		(*(out_EXECUTE_UNIT_IN_WRITE_RD [i][j])) (*(in_READ_UNIT_OUT_TYPE          [x][y]));
		if (_param->_have_port_context_id)
		(*(out_EXECUTE_UNIT_IN_WRITE_RD [i][j])) (*(in_READ_UNIT_OUT_CONTEXT_ID    [x][y]));
		if (_param->_have_port_front_end_id)
		(*(out_EXECUTE_UNIT_IN_WRITE_RD [i][j])) (*(in_READ_UNIT_OUT_FRONT_END_ID  [x][y]));
		if (_param->_have_port_ooo_engine_id)
		(*(out_EXECUTE_UNIT_IN_WRITE_RD [i][j])) (*(in_READ_UNIT_OUT_OOO_ENGINE_ID [x][y]));
	      }
	    
	    (*(out_EXECUTE_UNIT_IN_NUM_REG_RD [i][j])) (*(in_EXECUTE_UNIT_IN_ACK [i][j]));

	    for (uint32_t x=0; x<_param->_nb_read_unit; x++)
	      for (uint32_t y=0; y<_param->_nb_read_unit_port[x]; y++)
	      {
		(*(out_EXECUTE_UNIT_IN_NUM_REG_RD [i][j])) (*(in_READ_UNIT_OUT_NUM_REG_RD    [x][y]));
		(*(out_EXECUTE_UNIT_IN_NUM_REG_RD [i][j])) (*(in_READ_UNIT_OUT_VAL           [x][y]));
		(*(out_EXECUTE_UNIT_IN_NUM_REG_RD [i][j])) (*(in_READ_UNIT_OUT_TYPE          [x][y]));
		if (_param->_have_port_context_id)
		(*(out_EXECUTE_UNIT_IN_NUM_REG_RD [i][j])) (*(in_READ_UNIT_OUT_CONTEXT_ID    [x][y]));
		if (_param->_have_port_front_end_id)
		(*(out_EXECUTE_UNIT_IN_NUM_REG_RD [i][j])) (*(in_READ_UNIT_OUT_FRONT_END_ID  [x][y]));
		if (_param->_have_port_ooo_engine_id)
		(*(out_EXECUTE_UNIT_IN_NUM_REG_RD [i][j])) (*(in_READ_UNIT_OUT_OOO_ENGINE_ID [x][y]));
	      }

	    (*(out_EXECUTE_UNIT_IN_WRITE_RE [i][j])) (*(in_EXECUTE_UNIT_IN_ACK [i][j]));

	    for (uint32_t x=0; x<_param->_nb_read_unit; x++)
	      for (uint32_t y=0; y<_param->_nb_read_unit_port[x]; y++)
	      {
		(*(out_EXECUTE_UNIT_IN_WRITE_RE [i][j])) (*(in_READ_UNIT_OUT_WRITE_RE      [x][y]));
		(*(out_EXECUTE_UNIT_IN_WRITE_RE [i][j])) (*(in_READ_UNIT_OUT_VAL           [x][y]));
		(*(out_EXECUTE_UNIT_IN_WRITE_RE [i][j])) (*(in_READ_UNIT_OUT_TYPE          [x][y]));
		if (_param->_have_port_context_id)
		(*(out_EXECUTE_UNIT_IN_WRITE_RE [i][j])) (*(in_READ_UNIT_OUT_CONTEXT_ID    [x][y]));
		if (_param->_have_port_front_end_id)
		(*(out_EXECUTE_UNIT_IN_WRITE_RE [i][j])) (*(in_READ_UNIT_OUT_FRONT_END_ID  [x][y]));
		if (_param->_have_port_ooo_engine_id)
		(*(out_EXECUTE_UNIT_IN_WRITE_RE [i][j])) (*(in_READ_UNIT_OUT_OOO_ENGINE_ID [x][y]));
	      }

	    (*(out_EXECUTE_UNIT_IN_NUM_REG_RE [i][j])) (*(in_EXECUTE_UNIT_IN_ACK [i][j]));

	    for (uint32_t x=0; x<_param->_nb_read_unit; x++)
	      for (uint32_t y=0; y<_param->_nb_read_unit_port[x]; y++)
	      {
		(*(out_EXECUTE_UNIT_IN_NUM_REG_RE [i][j])) (*(in_READ_UNIT_OUT_NUM_REG_RE    [x][y]));
		(*(out_EXECUTE_UNIT_IN_NUM_REG_RE [i][j])) (*(in_READ_UNIT_OUT_VAL           [x][y]));
		(*(out_EXECUTE_UNIT_IN_NUM_REG_RE [i][j])) (*(in_READ_UNIT_OUT_TYPE          [x][y]));
		if (_param->_have_port_context_id)
		(*(out_EXECUTE_UNIT_IN_NUM_REG_RE [i][j])) (*(in_READ_UNIT_OUT_CONTEXT_ID    [x][y]));
		if (_param->_have_port_front_end_id)
		(*(out_EXECUTE_UNIT_IN_NUM_REG_RE [i][j])) (*(in_READ_UNIT_OUT_FRONT_END_ID  [x][y]));
		if (_param->_have_port_ooo_engine_id)
		(*(out_EXECUTE_UNIT_IN_NUM_REG_RE [i][j])) (*(in_READ_UNIT_OUT_OOO_ENGINE_ID [x][y]));
	      }
	  }
# endif    
	
#endif
      }
    log_printf(FUNC,Read_unit_to_Execution_unit,FUNCTION,_("<%s> End"),_name.c_str());
  };
    
#undef  FUNCTION
#define FUNCTION "Read_unit_to_Execution_unit::~Read_unit_to_Execution_unit"
  Read_unit_to_Execution_unit::~Read_unit_to_Execution_unit (void)
  {
    log_printf(FUNC,Read_unit_to_Execution_unit,FUNCTION,_("<%s> Begin"),_name.c_str());

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {
	log_printf(INFO,Read_unit_to_Execution_unit,FUNCTION,_("<%s> Generate Statistics file"),_name.c_str());
	
	delete _stat;
      }
#endif

    log_printf(INFO,Read_unit_to_Execution_unit,FUNCTION,_("<%s> Deallocation"),_name.c_str());
    deallocation ();

    log_printf(FUNC,Read_unit_to_Execution_unit,FUNCTION,_("<%s> End"),_name.c_str());
  };

}; // end namespace read_unit_to_execution_unit
}; // end namespace network
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
