#ifdef SYSTEMC
/*
 * $Id: Decod_queue_function_multi_fifo_genMoore.cpp 137 2010-02-16 12:35:48Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Decod_unit/Decod_queue/include/Decod_queue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace decod_unit {
namespace decod_queue {


#undef  FUNCTION
#define FUNCTION "Decod_queue::function_multi_fifo_genMoore"
  void Decod_queue::function_multi_fifo_genMoore (void)
  {
    log_begin(Decod_queue,FUNCTION);
    log_function(Decod_queue,FUNCTION,_name.c_str());

    if (PORT_READ(in_NRESET))
      {
    //--------------------------------------------------------------------
    //-----[ DECOD_IN ]---------------------------------------------------
    //--------------------------------------------------------------------
    {
      uint32_t num_bank = reg_NUM_BANK_TAIL;

      for (uint32_t i=0; i<_param->_nb_inst_decod; i++)
        {
	  internal_DECOD_IN_ACK [i] = (reg_QUEUE[num_bank].size() < _param->_size_queue);

          num_bank = (num_bank+1)%_param->_nb_bank;
	}
    }

    //--------------------------------------------------------------------
    //-----[ DECOD_OUT ]--------------------------------------------------
    //--------------------------------------------------------------------
    {
      uint32_t num_bank = reg_NUM_BANK_HEAD%_param->_nb_bank;

        for (uint32_t i=0; i<_param->_nb_inst_decod; i++)
          {
            if (not reg_QUEUE[num_bank].empty())
              {
                if (_param->_have_port_context_id)
	        PORT_WRITE(out_DECOD_OUT_CONTEXT_ID    [i],reg_QUEUE[num_bank].front()->_context_id    [0]);
	        if (_param->_have_port_depth)
	        PORT_WRITE(out_DECOD_OUT_DEPTH         [i],reg_QUEUE[num_bank].front()->_depth         [0]);
#ifdef STATISTICS
	        PORT_WRITE(out_DECOD_OUT_INSTRUCTION   [i],reg_QUEUE[num_bank].front()->_instruction   [0]);
#endif
	        PORT_WRITE(out_DECOD_OUT_TYPE          [i],reg_QUEUE[num_bank].front()->_type          [0]);
	        PORT_WRITE(out_DECOD_OUT_OPERATION     [i],reg_QUEUE[num_bank].front()->_operation     [0]);
	        PORT_WRITE(out_DECOD_OUT_NO_EXECUTE    [i],reg_QUEUE[num_bank].front()->_no_execute    [0]);
// 	        PORT_WRITE(out_DECOD_OUT_HAVE_EVENT    [i],0);
	        PORT_WRITE(out_DECOD_OUT_LAST_EVENT    [i],0);
	        PORT_WRITE(out_DECOD_OUT_IS_DELAY_SLOT [i],reg_QUEUE[num_bank].front()->_is_delay_slot [0]);
#ifdef DEBUG
                PORT_WRITE(out_DECOD_OUT_ADDRESS       [i],reg_QUEUE[num_bank].front()->_address       [0]);
#endif
	        PORT_WRITE(out_DECOD_OUT_ADDRESS_NEXT  [i],reg_QUEUE[num_bank].front()->_address_next  [0]);
	        PORT_WRITE(out_DECOD_OUT_HAS_IMMEDIAT  [i],reg_QUEUE[num_bank].front()->_has_immediat  [0]);
	        PORT_WRITE(out_DECOD_OUT_IMMEDIAT      [i],reg_QUEUE[num_bank].front()->_immediat      [0]);
	        PORT_WRITE(out_DECOD_OUT_READ_RA       [i],reg_QUEUE[num_bank].front()->_read_ra       [0]);
	        PORT_WRITE(out_DECOD_OUT_NUM_REG_RA    [i],reg_QUEUE[num_bank].front()->_num_reg_ra    [0]);
	        PORT_WRITE(out_DECOD_OUT_READ_RB       [i],reg_QUEUE[num_bank].front()->_read_rb       [0]);
	        PORT_WRITE(out_DECOD_OUT_NUM_REG_RB    [i],reg_QUEUE[num_bank].front()->_num_reg_rb    [0]);
	        PORT_WRITE(out_DECOD_OUT_READ_RC       [i],reg_QUEUE[num_bank].front()->_read_rc       [0]);
	        PORT_WRITE(out_DECOD_OUT_NUM_REG_RC    [i],reg_QUEUE[num_bank].front()->_num_reg_rc    [0]);
	        PORT_WRITE(out_DECOD_OUT_WRITE_RD      [i],reg_QUEUE[num_bank].front()->_write_rd      [0]);
	        PORT_WRITE(out_DECOD_OUT_NUM_REG_RD    [i],reg_QUEUE[num_bank].front()->_num_reg_rd    [0]);
	        PORT_WRITE(out_DECOD_OUT_WRITE_RE      [i],reg_QUEUE[num_bank].front()->_write_re      [0]);
	        PORT_WRITE(out_DECOD_OUT_NUM_REG_RE    [i],reg_QUEUE[num_bank].front()->_num_reg_re    [0]);
	        PORT_WRITE(out_DECOD_OUT_EXCEPTION_USE [i],reg_QUEUE[num_bank].front()->_exception_use [0]);
	        PORT_WRITE(out_DECOD_OUT_EXCEPTION     [i],reg_QUEUE[num_bank].front()->_exception     [0]);
              }
            num_bank = (num_bank+1)%_param->_nb_bank;
          }
    }

    //--------------------------------------------------------------------
    //-----[ NB_INST ]----------------------------------------------------
    //--------------------------------------------------------------------
    for (uint32_t i=0; i<_param->_nb_context; i++)
      PORT_WRITE(out_NB_INST_ALL [i], reg_NB_INST [i]);
      }
    else
      {
        for (uint32_t i=0; i<_param->_nb_inst_decod; i++)
          {
            internal_DECOD_IN_ACK [i] = 0;
          }
        for (uint32_t i=0; i<_param->_nb_context; i++)
          PORT_WRITE(out_NB_INST_ALL [i], 0);
      }


    // Write output
    for (uint32_t i=0; i<_param->_nb_inst_decod; i++)
      {
        PORT_WRITE(out_DECOD_IN_ACK [i],internal_DECOD_IN_ACK [i]);
      }


    log_end(Decod_queue,FUNCTION);
  };

}; // end namespace decod_queue
}; // end namespace decod_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
