/*
 * $Id: Parameters_msg_error.cpp 111 2009-02-27 18:37:40Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Types.h"
#include "Behavioural/Core/Multi_Front_end/Front_end/Decod_unit/Decod_queue/include/Parameters.h"
#include <sstream>

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace decod_unit {
namespace decod_queue {


#undef  FUNCTION
#define FUNCTION "Decod_queue::msg_error"
  Parameters_test Parameters::msg_error(void)
  {
    log_begin(Decod_queue,FUNCTION);

    Parameters_test test ("Decod_queue");

    if (not is_multiple (_nb_instruction_in_queue,_nb_inst_decod))
      test.error("Size of decod queue must be a multiple of nb_instruction.\n");

    switch (_queue_scheme)
      {
      case DECOD_QUEUE_SCHEME_ONE_FIFO :
      case DECOD_QUEUE_SCHEME_MULTI_FIFO :
        {
          break;
        }
      default :
	{
 	  test.error(toString(_("Decod queue scheme '%s' is not supported. Please wait a next revision.\n"),toString(_queue_scheme).c_str()));
	  break;
	}
      }

    log_end(Decod_queue,FUNCTION);

    return test;
  };

}; // end namespace decod_queue
}; // end namespace decod_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
