/*
 * $Id: Address_management_deallocation.cpp 128 2009-06-26 08:43:23Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Ifetch_unit/Address_management/include/Address_management.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace ifetch_unit {
namespace address_management {


#undef  FUNCTION
#define FUNCTION "Address_management::deallocation"
  void Address_management::deallocation (void)
  {
    log_printf(FUNC,Address_management,FUNCTION,"Begin");

    if (usage_is_set(_usage,USE_SYSTEMC))
      {
	delete    in_CLOCK ;
	delete    in_NRESET;
        
        DELETE0_SIGNAL(out_ADDRESS_VAL                        ,1);
        DELETE0_SIGNAL( in_ADDRESS_ACK                        ,1);
        DELETE0_SIGNAL(out_ADDRESS_INSTRUCTION_ADDRESS        ,_param->_size_instruction_address     );
        DELETE0_SIGNAL(out_ADDRESS_INST_IFETCH_PTR            ,_param->_size_inst_ifetch_ptr         );
        DELETE0_SIGNAL(out_ADDRESS_BRANCH_STATE               ,_param->_size_branch_state            );
        DELETE0_SIGNAL(out_ADDRESS_BRANCH_UPDATE_PREDICTION_ID,_param->_size_depth);
        DELETE1_SIGNAL(out_ADDRESS_INSTRUCTION_ENABLE         ,_param->_nb_instruction,1);
        
        DELETE0_SIGNAL(out_PREDICT_VAL                        ,1);
        DELETE0_SIGNAL( in_PREDICT_ACK                        ,1);
        DELETE0_SIGNAL(out_PREDICT_PC_PREVIOUS                ,_param->_size_instruction_address);
        DELETE0_SIGNAL(out_PREDICT_PC_CURRENT                 ,_param->_size_instruction_address);
        DELETE0_SIGNAL(out_PREDICT_PC_CURRENT_IS_DS_TAKE      ,1);
        DELETE0_SIGNAL( in_PREDICT_PC_NEXT                    ,_param->_size_instruction_address);
        DELETE0_SIGNAL( in_PREDICT_PC_NEXT_IS_DS_TAKE         ,1);
//      DELETE0_SIGNAL( in_PREDICT_BRANCH_IS_CURRENT          ,1);
        DELETE0_SIGNAL( in_PREDICT_BRANCH_STATE               ,_param->_size_branch_state);
        DELETE0_SIGNAL( in_PREDICT_BRANCH_UPDATE_PREDICTION_ID,_param->_size_depth);
        DELETE0_SIGNAL( in_PREDICT_INST_IFETCH_PTR            ,_param->_size_inst_ifetch_ptr);
        DELETE1_SIGNAL(in_PREDICT_INSTRUCTION_ENABLE          ,_param->_nb_instruction,1);
        
        DELETE0_SIGNAL( in_EVENT_VAL             ,1);
        DELETE0_SIGNAL(out_EVENT_ACK             ,1);
        DELETE0_SIGNAL( in_EVENT_ADDRESS         ,_param->_size_instruction_address);
        DELETE0_SIGNAL( in_EVENT_ADDRESS_NEXT    ,_param->_size_instruction_address);
        DELETE0_SIGNAL( in_EVENT_ADDRESS_NEXT_VAL,1);
        DELETE0_SIGNAL( in_EVENT_IS_DS_TAKE      ,1);
        
        DELETE1(reg_PC_ACCESS_INSTRUCTION_ENABLE ,_param->_nb_instruction);
        DELETE1(reg_PC_CURRENT_INSTRUCTION_ENABLE,_param->_nb_instruction);
        DELETE1(reg_PC_NEXT_INSTRUCTION_ENABLE   ,_param->_nb_instruction);
      }

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
    delete _component;

    log_printf(FUNC,Address_management,FUNCTION,"End");
  };

}; // end namespace address_management
}; // end namespace ifetch_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
