#ifndef morpheo_behavioural_core_multi_front_end_front_end_ifetch_unit_ifetch_queue_Ifetch_queue_h
#define morpheo_behavioural_core_multi_front_end_front_end_ifetch_unit_ifetch_queue_Ifetch_queue_h

/*
 * $Id: Ifetch_queue.h 136 2009-10-20 18:52:15Z rosiere $
 *
 * [ Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#include <iostream>
#include "Common/include/ToString.h"
#include "Common/include/Debug.h"

#include "Behavioural/Core/Multi_Front_end/Front_end/Ifetch_unit/Ifetch_queue/include/Types.h"
#include "Behavioural/Core/Multi_Front_end/Front_end/Ifetch_unit/Ifetch_queue/include/Parameters.h"
#ifdef STATISTICS
#include "Behavioural/include/Stat.h"
#endif
#include "Behavioural/include/Component.h"
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#include "Behavioural/include/Usage.h"

namespace morpheo {
namespace behavioural {

namespace core {
namespace multi_front_end {
namespace front_end {
namespace ifetch_unit {
namespace ifetch_queue {

  class Ifetch_queue 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[ fields ]----------------------------------------------------
    // Parameters
  protected : const std::string  _name;
  protected : const Parameters * _param;
  private   : const Tusage_t     _usage;

#ifdef STATISTICS
  public    : Stat                           * _stat;
  private   : counter_t                      * _sum_use_queue  ;
  private   : counter_t                      * _sum_use_queue_wait_rsp;
  private   : counter_t                      * _sum_use_queue_have_rsp;
  private   : counter_t                      * _sum_use_queue_error_wait_rsp;

  private   : counter_t                      * _sum_inst_enable;
  private   : counter_t                      * _sum_transaction_address;

  private   : counter_t                      * _average_occupation_bundle;
#endif

  public    : Component                      * _component;
  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[ Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_CLOCK                      *  in_CLOCK        ;
  public    : SC_IN (Tcontrol_t)            *  in_NRESET       ;

    // ~~~~~[ Interface : "address" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t         )   *  in_ADDRESS_VAL                         ;
  public    : SC_OUT(Tcontrol_t         )   * out_ADDRESS_ACK                         ;
  public    : SC_OUT(Tifetch_queue_ptr_t)   * out_ADDRESS_IFETCH_QUEUE_ID             ;
  public    : SC_IN (Tcontrol_t         )  **  in_ADDRESS_INSTRUCTION_ENABLE          ;//[nb_instruction]
  public    : SC_IN (Tgeneral_address_t )   *  in_ADDRESS_INSTRUCTION_ADDRESS         ;
  public    : SC_IN (Tinst_ifetch_ptr_t )   *  in_ADDRESS_INST_IFETCH_PTR             ;
  public    : SC_IN (Tbranch_state_t    )   *  in_ADDRESS_BRANCH_STATE                ;
  public    : SC_IN (Tprediction_ptr_t  )   *  in_ADDRESS_BRANCH_UPDATE_PREDICTION_ID ;

    // ~~~~~[ Interface : "decod" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_OUT(Tcontrol_t         )  ** out_DECOD_VAL                           ;//[nb_instruction]
  public    : SC_IN (Tcontrol_t         )  **  in_DECOD_ACK                           ;//[nb_instruction]
  public    : SC_OUT(Tinstruction_t     )  ** out_DECOD_INSTRUCTION                   ;//[nb_instruction]
  public    : SC_OUT(Tgeneral_address_t )  ** out_DECOD_ADDRESS                       ;
  public    : SC_OUT(Tbranch_state_t    )  ** out_DECOD_BRANCH_STATE                  ;
  public    : SC_OUT(Tprediction_ptr_t  )  ** out_DECOD_BRANCH_UPDATE_PREDICTION_ID   ;
  public    : SC_OUT(Texception_t       )  ** out_DECOD_EXCEPTION                     ;
//public    : SC_OUT(Tgeneral_address_t )   * out_DECOD_ADDRESS                       ;
//public    : SC_OUT(Tinst_ifetch_ptr_t )   * out_DECOD_INST_IFETCH_PTR               ;
//public    : SC_OUT(Tbranch_state_t    )   * out_DECOD_BRANCH_STATE                  ;
//public    : SC_OUT(Tprediction_ptr_t  )   * out_DECOD_BRANCH_UPDATE_PREDICTION_ID   ;
//public    : SC_OUT(Texception_t       )   * out_DECOD_EXCEPTION                     ;

    // ~~~~~[ Interface "icache_rsp" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t        )    *  in_ICACHE_RSP_VAL                      ;
  public    : SC_OUT(Tcontrol_t        )    * out_ICACHE_RSP_ACK                      ;
  public    : SC_IN (Tpacket_t         )    *  in_ICACHE_RSP_PACKET_ID                ;
  public    : SC_IN (Ticache_instruction_t)**  in_ICACHE_RSP_INSTRUCTION              ;//[nb_instruction]
  public    : SC_IN (Ticache_error_t   )    *  in_ICACHE_RSP_ERROR                    ;
    
    // ~~~~~[ Interface "event_reset" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t        )    *  in_EVENT_RESET_VAL                     ;// val if : miss_speculation, exception, synchronization
  public    : SC_OUT(Tcontrol_t        )    * out_EVENT_RESET_ACK                     ;
    
    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
  private   : uint32_t                        reg_PTR_READ ;
  private   : uint32_t                        reg_PTR_WRITE;
  private   : ifetch_queue_entry_t         ** _queue; // ifetch_queue

    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  private   : Tcontrol_t                      internal_ADDRESS_ACK    ;
  private   : Tcontrol_t                    * internal_DECOD_VAL      ;//[nb_instruction]
  private   : uint32_t                      * internal_DECOD_PTR      ;//[nb_instruction] Only queue_scheme == full_assoc
  private   : uint32_t                      * internal_DECOD_SLOT     ;//[nb_instruction] Only queue_scheme == full_assoc
  private   : Tcontrol_t                      internal_ICACHE_RSP_ACK ;
  private   : Tcontrol_t                      internal_EVENT_RESET_ACK;

    

    // function pointer
  public    : void (morpheo::behavioural::core::multi_front_end::front_end::ifetch_unit::ifetch_queue::Ifetch_queue::*function_transition        ) (void);
  public    : void (morpheo::behavioural::core::multi_front_end::front_end::ifetch_unit::ifetch_queue::Ifetch_queue::*function_genMoore          ) (void);
#endif

    // -----[ Methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (Ifetch_queue);
#endif
  public  :          Ifetch_queue              
  (
#ifdef SYSTEMC
   sc_module_name                                name,
#else					       
   std::string                                   name,
#endif					       
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   Parameters                                  * param,
   morpheo::behavioural::Tusage_t                usage
   );
  public  :          ~Ifetch_queue             (void);
					       
  private : void        allocation                (
#ifdef STATISTICS
						   morpheo::behavioural::Parameters_Statistics * param_statistics
#else
						   void
#endif
						   );
  private : void        deallocation              (void);
					       
#ifdef SYSTEMC				       
  public  : void        constant                  (void);

  public  : void        transition                     (void);
  public  : void        genMoore                       (void);

  public  : void        function_no_assoc_transition   (void);
  public  : void        function_no_assoc_genMoore     (void);

  public  : void        function_full_assoc_transition (void);
  public  : void        function_full_assoc_genMoore   (void);
#endif					       

#if VHDL				       
  public  : void        vhdl                      (void);
  private : void        vhdl_declaration          (Vhdl * & vhdl);
  private : void        vhdl_body                 (Vhdl * & vhdl);
#endif					       

#ifdef STATISTICS
  public  : void        statistics_allocation     (morpheo::behavioural::Parameters_Statistics * param_statistics);
  public  : void        statistics_deallocation   (void);
#endif
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  private : void        end_cycle                 (void);
#endif
  };

}; // end namespace ifetch_queue
}; // end namespace ifetch_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
