#ifdef VHDL
/*
 * $Id: Ifetch_queue_vhdl_declaration.cpp 137 2010-02-16 12:35:48Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Ifetch_unit/Ifetch_queue/include/Ifetch_queue.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace ifetch_unit {
namespace ifetch_queue {


#undef  FUNCTION
#define FUNCTION "Ifetch_queue::vhdl_declaration"
  void Ifetch_queue::vhdl_declaration (Vhdl * & vhdl)
  {
    log_printf(FUNC,Ifetch_queue,FUNCTION,"Begin");

    vhdl->set_constant ("IFETCH_QUEUE_STATE_EMPTY           ",IFETCH_QUEUE_STATE_SIZE,IFETCH_QUEUE_STATE_EMPTY);
//  vhdl->set_constant ("IFETCH_QUEUE_STATE_WAIT_REQ        ",IFETCH_QUEUE_STATE_SIZE,IFETCH_QUEUE_STATE_WAIT_REQ);
    vhdl->set_constant ("IFETCH_QUEUE_STATE_WAIT_RSP        ",IFETCH_QUEUE_STATE_SIZE,IFETCH_QUEUE_STATE_WAIT_RSP);
    vhdl->set_constant ("IFETCH_QUEUE_STATE_HAVE_RSP        ",IFETCH_QUEUE_STATE_SIZE,IFETCH_QUEUE_STATE_HAVE_RSP);
    vhdl->set_constant ("IFETCH_QUEUE_STATE_ERROR_WAIT_RSP  ",IFETCH_QUEUE_STATE_SIZE,IFETCH_QUEUE_STATE_ERROR_WAIT_RSP);
    
    vhdl->set_constant ("EXCEPTION_IFETCH_NONE              ",_param->_size_exception_ifetch,EXCEPTION_IFETCH_NONE);
    vhdl->set_constant ("EXCEPTION_IFETCH_BUS_ERROR         ",_param->_size_exception_ifetch,EXCEPTION_IFETCH_BUS_ERROR);

    vhdl->set_constant ("ICACHE_ERROR_NONE                  ",_param->_size_icache_error,ICACHE_ERROR_NONE);    
    vhdl->set_constant ("ICACHE_ERROR_BUS_ERROR             ",_param->_size_icache_error,ICACHE_ERROR_BUS_ERROR);    

    if (_param->_size_queue>1)
      {
    vhdl->set_signal  ("reg_PTR_READ                        ", log2(_param->_size_queue));
    vhdl->set_signal  ("reg_PTR_WRITE                       ", log2(_param->_size_queue));
      }
     if (_param->_have_port_ifetch_queue_ptr)
       {
	 if (_param->_size_queue>1)
	   vhdl->set_signal  ("reg_PACKET_PTR                 ", log2(_param->_size_queue));
	 else 
	   vhdl->set_signal  ("reg_PACKET_PTR                 ", 1);
       }

    vhdl->set_signal  ("reg_EMPTY                            ", 1);	

    vhdl->set_type    ("Tcase                                ","array ("+toString(_param->_nb_instruction-1)+" downto 0) of "+std_logic(_param->_size_instruction));
    vhdl->set_type    ("Tcase_enable                         ","array ("+toString(_param->_nb_instruction-1)+" downto 0) of std_logic");

    vhdl->set_type    ("Tstate                               ","array ("+toString(_param->_size_queue-1)+" downto 0) of "+std_logic(IFETCH_QUEUE_STATE_SIZE));
    vhdl->set_signal  ("reg_STATE                            ", "Tstate");
   
    vhdl->set_type    ("Tqueue                               ","array ("+toString(_param->_size_queue-1)+" downto 0) of Tcase");
    vhdl->set_signal  ("reg_DATA                             ", "Tqueue");
    
    vhdl->set_type    ("Tenable                              ","array ("+toString(_param->_size_queue-1)+" downto 0) of Tcase_enable");
    vhdl->set_signal  ("reg_INSTRUCTION_ENABLE               ", "Tenable");
    vhdl->set_type    ("Tadress                              ","array ("+toString(_param->_size_queue-1)+" downto 0) of "+std_logic(_param->_size_instruction_address));
    vhdl->set_signal  ("reg_ADDRESS                          ", "Tadress");

    if (_param->_have_port_inst_ifetch_ptr) 
      {
       vhdl->set_type    ("Tinst_ptr                         ","array ("+toString(_param->_size_queue-1)+" downto 0) of "+std_logic(_param->_size_inst_ifetch_ptr));
       vhdl->set_signal  ("reg_INST_IFETCH_PTR               ", "Tinst_ptr");
      }
    if (_param->_have_port_depth)
      {
	vhdl->set_type    ("Tbranch                           ","array ("+toString(_param->_size_queue-1)+" downto 0) of "+std_logic(_param->_size_depth));
	vhdl->set_signal  ("reg_BRANCH_UPDATE_PREDICTION_ID   ", "Tbranch");
      }
    vhdl->set_type    ("Tbranch_state                         ","array ("+toString(_param->_size_queue-1)+" downto 0) of "+std_logic(_param->_size_branch_state));
    vhdl->set_signal  ("reg_BRANCH_STATE                      ", "Tbranch_state");
    vhdl->set_type    ("Texception                            ","array ("+toString(_param->_size_queue-1)+" downto 0) of "+std_logic(_param->_size_exception_ifetch));
    vhdl->set_signal  ("reg_EXCEPTION                         ", "Texception"); 
    
    for (uint32_t i=0; i<_param->_nb_instruction; ++i)
    vhdl->set_signal  ("internal_DECOD_"+toString(i)+"_VAL                      ", 1);
    vhdl->set_signal  ("internal_ADDRESS_ACK                  ", 1);    
    vhdl->set_signal  ("internal_ICACHE_RSP_ACK               ", 1);
    vhdl->set_signal  ("internal_EVENT_RESET_ACK              ", 1);
    if(_param->_have_port_ifetch_queue_ptr)
    vhdl->set_signal  ("internal_ICACHE_RSP_PACKET_ID         ", _param->_size_ifetch_queue_ptr);
    vhdl->set_signal  ("internal_ack                          ", 1);

    log_printf(FUNC,Ifetch_queue,FUNCTION,"End");
  };

}; // end namespace ifetch_queue
}; // end namespace ifetch_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
