/*
 * $Id: Parameters.cpp 128 2009-06-26 08:43:23Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Meta_Predictor/Meta_Predictor_Glue/include/Parameters.h"
#include "Behavioural/include/Allocation.h"
#include "Common/include/BitManipulation.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace direction {
namespace meta_predictor {
namespace meta_predictor_glue {


#undef  FUNCTION
#define FUNCTION "Meta_Predictor_Glue::Parameters"
  Parameters::Parameters (uint32_t   nb_inst_predict         ,
                          uint32_t   nb_inst_update          ,
                          uint32_t   nb_predictor                  ,
                          uint32_t * predictor_size_history        ,//[nb_predictor]
                          bool     * predictor_update_on_prediction,//[nb_predictor]
                          bool       is_toplevel             )
  {
    log_begin(Meta_Predictor_Glue,FUNCTION);

    _nb_inst_predict                = nb_inst_predict               ;
    _nb_inst_update                 = nb_inst_update                ;
    _nb_predictor                   = nb_predictor                  ;
    _predictor_size_history         = predictor_size_history        ;
    _predictor_update_on_prediction = predictor_update_on_prediction;

    _size_history = 0;
    for (uint32_t i=0; i<_nb_predictor; ++i)
      _size_history += _predictor_size_history [i];

    test();

    ALLOC1(_predictor_history_shift    ,uint32_t  ,_nb_predictor);
    ALLOC1(_predictor_history_shift_msb,uint32_t  ,_nb_predictor);
    ALLOC1(_predictor_history_mask     ,Thistory_t,_nb_predictor);

    uint32_t shift = 0;
    for (uint32_t i=0; i<_nb_predictor; ++i)
      {
        _predictor_history_shift     [i] = shift;
        _predictor_history_shift_msb [i] = _predictor_size_history [i]-1;
        _predictor_history_mask      [i] = gen_mask<Thistory_t>(_predictor_size_history [i]);

        shift += _predictor_size_history [i];
      }

    if (is_toplevel)
      {
        copy();
      }

    log_end(Meta_Predictor_Glue,FUNCTION);
  };
  
// #undef  FUNCTION
// #define FUNCTION "Meta_Predictor_Glue::Parameters (copy)"
//   Parameters::Parameters (Parameters & param)
//   {
//     log_begin(Meta_Predictor_Glue,FUNCTION);
//     test();
//     log_end(Meta_Predictor_Glue,FUNCTION);
//   };

#undef  FUNCTION
#define FUNCTION "Meta_Predictor_Glue::~Parameters"
  Parameters::~Parameters (void) 
  {
    log_begin(Meta_Predictor_Glue,FUNCTION);

    DELETE1(_predictor_history_mask     ,_nb_predictor);
    DELETE1(_predictor_history_shift_msb,_nb_predictor);
    DELETE1(_predictor_history_shift    ,_nb_predictor);

    log_end(Meta_Predictor_Glue,FUNCTION);
  };

#undef  FUNCTION
#define FUNCTION "Meta_Predictor_Glue::copy"
  void Parameters::copy (void) 
  {
    log_begin(Meta_Predictor_Glue,FUNCTION);
    log_end(Meta_Predictor_Glue,FUNCTION);
  };

}; // end namespace meta_predictor_glue
}; // end namespace meta_predictor
}; // end namespace direction
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
