/*
 * $Id: Direction_deallocation.cpp 112 2009-03-18 22:36:26Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/include/Direction.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace direction {


#undef  FUNCTION
#define FUNCTION "Direction::deallocation"
  void Direction::deallocation (void)
  {
    log_printf(FUNC,Direction,FUNCTION,"Begin");

    if (usage_is_set(_usage,USE_SYSTEMC))
      {
	delete    in_CLOCK ;
	delete    in_NRESET;

        DELETE1_SIGNAL( in_PREDICT_VAL        ,_param->_nb_inst_predict,1);
        DELETE1_SIGNAL(out_PREDICT_ACK        ,_param->_nb_inst_predict,1);
        DELETE1_SIGNAL( in_PREDICT_ADDRESS_SRC,_param->_nb_inst_predict,_param->_size_instruction_address);
        DELETE1_SIGNAL( in_PREDICT_STATIC     ,_param->_nb_inst_predict,1);
        DELETE1_SIGNAL( in_PREDICT_LAST_TAKE  ,_param->_nb_inst_predict,1);
        DELETE1_SIGNAL(out_PREDICT_HISTORY    ,_param->_nb_inst_predict,_param->_size_history);
        DELETE1_SIGNAL(out_PREDICT_DIRECTION  ,_param->_nb_inst_predict,1);

        DELETE1_SIGNAL( in_UPDATE_VAL              ,_param->_nb_inst_update,1);
        DELETE1_SIGNAL(out_UPDATE_ACK              ,_param->_nb_inst_update,1);
        DELETE1_SIGNAL( in_UPDATE_ADDRESS          ,_param->_nb_inst_update,_param->_size_instruction_address);
        DELETE1_SIGNAL( in_UPDATE_HISTORY          ,_param->_nb_inst_update,_param->_size_history);
        DELETE1_SIGNAL( in_UPDATE_DIRECTION        ,_param->_nb_inst_update,1);
        DELETE1_SIGNAL( in_UPDATE_PREDICTION_IFETCH,_param->_nb_inst_update,1);
      }
    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
    delete _component_glue;
    if (_param->_have_component_meta_predictor)
    delete _component_meta_predictor;
    delete _component;

    log_printf(FUNC,Direction,FUNCTION,"End");
  };

}; // end namespace direction
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
