/*
 * $Id: Parameters_msg_error.cpp 111 2009-02-27 18:37:40Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Types.h"
#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/include/Parameters.h"
#include <sstream>

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace direction {


#undef  FUNCTION
#define FUNCTION "Direction::msg_error"
  Parameters_test Parameters::msg_error(void)
  {
    log_printf(FUNC,Direction,FUNCTION,"Begin");

    Parameters_test test ("Direction");

    if (_nb_inst_predict == 0)
      test.error("nb_inst_predict must be > 0.");

    if (_nb_inst_update == 0)
      test.error("nb_inst_update must be > 0.");

    switch (_predictor_scheme)
      {
      case PREDICTOR_NEVER_TAKE  :
      case PREDICTOR_ALWAYS_TAKE :
      case PREDICTOR_STATIC      :
      case PREDICTOR_LAST_TAKE   : 
      case PREDICTOR_COUNTER     :
      case PREDICTOR_LOCAL       :
      case PREDICTOR_GLOBAL      :
      case PREDICTOR_META        :
      case PREDICTOR_CUSTOM      :
	{
	  break;
	}
      default :
	{
	  test.error("Unimplemented predictor_scheme : \""+toString(_predictor_scheme)+"\". (Coming Soon)");
	  break;
	}
      }

    log_printf(FUNC,Direction,FUNCTION,"End");

    return test;
  };

}; // end namespace direction
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
