/*
 * $Id: Parameters.cpp 128 2009-06-26 08:43:23Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Update_Prediction_Table/include/Parameters.h"
#include "Behavioural/include/Allocation.h"
#include "Common/include/Max.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace update_prediction_table {


#undef  FUNCTION
#define FUNCTION "Update_Prediction_Table::Parameters"
  Parameters::Parameters (uint32_t   nb_context             ,
			  uint32_t * size_upt_queue         ,
			  uint32_t * size_ufpt_queue        ,
			  uint32_t   size_address           ,
			  uint32_t   nb_inst_predict        ,
			  uint32_t   nb_inst_decod          ,
			  uint32_t   nb_inst_branch_complete,
			  uint32_t   nb_inst_update         ,
			  uint32_t   size_history           ,
			  uint32_t * size_ras_index         ,
                          uint32_t   nb_thread                           ,
                          uint32_t * translate_num_context_to_num_thread ,//[nb_context]
                          bool       is_toplevel):
    _always_accurate_predict (false),
    _always_accurate_decod   (false),
    _can_accurate_predict    (true ),
    _can_accurate_decod      (true )
  {
    log_printf(FUNC,Update_Prediction_Table,FUNCTION,"Begin");

    _nb_context              = nb_context             ;
    _size_upt_queue          = size_upt_queue         ;
    _size_ufpt_queue         = size_ufpt_queue        ;
//  _size_address            = size_address           ;
    _nb_inst_predict         = nb_inst_predict        ;
    _nb_inst_decod           = nb_inst_decod          ;
    _nb_inst_branch_complete = nb_inst_branch_complete;
    _nb_inst_update          = nb_inst_update         ;
    _size_history            = size_history           ;
    _size_ras_index          = size_ras_index         ;
    _nb_thread                           = nb_thread                          ;
    _translate_num_context_to_num_thread = translate_num_context_to_num_thread;
    
    _max_size_ras_index      = max<uint32_t>(_size_ras_index,nb_context);

    _have_port_history       = _size_history   > 0;

    test();

    ALLOC1(_have_thread,bool,_nb_thread);
    for (uint32_t i=0; i<_nb_thread; i++)
      _have_thread[i] = false;
    for (uint32_t i=0; i<_nb_thread; i++)
      _have_thread[_translate_num_context_to_num_thread [i]] = true;

    if (is_toplevel)
      {
        _size_instruction_address = size_address;
        _size_context_id          = log2(nb_context);
	_size_depth               = log2(max<uint32_t>(_size_upt_queue,_nb_context));

        _have_port_context_id    = _size_context_id> 0;
	_have_port_depth          = _size_depth > 0;

        copy ();
      }
    
    log_printf(FUNC,Update_Prediction_Table,FUNCTION,"End");
  };
  
// #undef  FUNCTION
// #define FUNCTION "Update_Prediction_Table::Parameters (copy)"
//   Parameters::Parameters (Parameters & param)
//   {
//     log_printf(FUNC,Update_Prediction_Table,FUNCTION,"Begin");
//     test();
//     log_printf(FUNC,Update_Prediction_Table,FUNCTION,"End");
//   };

#undef  FUNCTION
#define FUNCTION "Update_Prediction_Table::~Parameters"
  Parameters::~Parameters () 
  {
    log_printf(FUNC,Update_Prediction_Table,FUNCTION,"Begin");
    DELETE1(_have_thread     ,_nb_thread);
//     delete [] _size_depth     ;
//     delete [] _have_port_depth;
    log_printf(FUNC,Update_Prediction_Table,FUNCTION,"End");
  };

#undef  FUNCTION
#define FUNCTION "Update_Prediction_Table::copy"
  void Parameters::copy (void) 
  {
    log_printf(FUNC,Update_Prediction_Table,FUNCTION,"Begin");
    log_printf(FUNC,Update_Prediction_Table,FUNCTION,"End");
  };

}; // end namespace update_prediction_table
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
