#ifndef morpheo_behavioural_core_multi_ooo_engine_ooo_engine_commit_unit_Types_h
#define morpheo_behavioural_core_multi_ooo_engine_ooo_engine_commit_unit_Types_h

/*
 * $Id: Types.h 138 2010-05-12 17:34:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Types.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace commit_unit {

  typedef enum
    {
      RETIRE_IN_ORDER       ,
      RETIRE_OOO_RENAME_UNIT,
      RETIRE_OOO_CONTEXT
    } Tretire_ooo_scheme_t;

  typedef enum
    {
      ROB_EMPTY                      , // 

      ROB_BRANCH_WAIT_END            , // 
      ROB_BRANCH_COMPLETE            , // 

      ROB_STORE_WAIT_END_OK          , // 
      ROB_STORE_WAIT_END_KO          , // 
      ROB_STORE_OK                   , // 
      ROB_STORE_KO                   , // 
      ROB_STORE_OK_WAIT_END          , // 
      ROB_STORE_KO_WAIT_END          , // 
      ROB_STORE_EVENT                , // 

      ROB_OTHER_WAIT_END             , // 

      ROB_EVENT_WAIT_END             , // 

      ROB_END_OK_SPECULATIVE         , // 
      ROB_END_OK                     , // 
      ROB_END_KO_SPECULATIVE         , // 
      ROB_END_KO                     , // 
      ROB_END_BRANCH_MISS_SPECULATIVE, // 
      ROB_END_BRANCH_MISS            , // 
      ROB_END_LOAD_MISS_SPECULATIVE  , // 
      ROB_END_LOAD_MISS_UPDATE       , // 
      ROB_END_LOAD_MISS              , // 
      ROB_END_MISS                   , // 
      ROB_END_EXCEPTION_WAIT_HEAD    , // 
      ROB_END_EXCEPTION_UPDATE       , // 
      ROB_END_EXCEPTION              , // 
      ROB_END
    } rob_state_t;

  typedef enum
    {
      COMMIT_EVENT_STATE_NO_EVENT     ,
      COMMIT_EVENT_STATE_NOT_YET_EVENT,
      COMMIT_EVENT_STATE_EVENT        ,
//    COMMIT_EVENT_STATE_WAIT_DECOD   ,
      COMMIT_EVENT_STATE_WAIT_END     ,
//    COMMIT_EVENT_STATE_END          
    } Tcommit_event_state_t;

#define commit_event_state_to_event_state(x) ((x==COMMIT_EVENT_STATE_EVENT)?EVENT_STATE_EVENT:((x==COMMIT_EVENT_STATE_WAIT_END)?EVENT_STATE_WAITEND:EVENT_STATE_NO_EVENT))

// #define commit_event_state_to_event_state(x) ((x==COMMIT_EVENT_STATE_EVENT)?EVENT_STATE_EVENT:((x==COMMIT_EVENT_STATE_WAIT_END)?EVENT_STATE_WAITEND:((x==COMMIT_EVENT_STATE_END)?EVENT_STATE_END:EVENT_STATE_NO_EVENT)))
// #define commit_event_state_to_event_state(x) ((x==COMMIT_EVENT_STATE_EVENT)?EVENT_STATE_EVENT:((x==COMMIT_EVENT_STATE_WAIT_DECOD)?EVENT_STATE_WAITEND:((x==COMMIT_EVENT_STATE_WAIT_END)?EVENT_STATE_WAITEND:((x==COMMIT_EVENT_STATE_END)?EVENT_STATE_END:EVENT_STATE_NO_EVENT))))


  class entry_t 
  {
  public  : rob_state_t        state                   ;
  public  : rob_state_t        state_old               ;
  public  : uint32_t           ptr                     ;
  public  : Tcontext_t         front_end_id            ;
  public  : Tcontext_t         context_id              ;
  public  : uint32_t           rename_unit_id          ;
  public  : Tdepth_t           depth                   ;
#ifdef STATISTICS
  public  : uint32_t           instruction             ;
#endif
  public  : Ttype_t            type                    ;
  public  : Toperation_t       operation               ;
  public  : Tcontrol_t         is_delay_slot           ;
//public  : Tgeneral_data_t    address                 ;
  public  : Tcontrol_t         use_store_queue         ;
  public  : Tcontrol_t         use_load_queue          ;
  public  : Tlsq_ptr_t         store_queue_ptr_write   ;
  public  : Tlsq_ptr_t         load_queue_ptr_write    ;
#ifdef DEBUG
  public  : Tcontrol_t         read_ra                 ;
  public  : Tgeneral_address_t num_reg_ra_log          ;
  public  : Tgeneral_address_t num_reg_ra_phy          ;
#endif
  public  : Tcontrol_t         read_rb                 ;
#ifdef DEBUG
  public  : Tgeneral_address_t num_reg_rb_log          ;
  public  : Tgeneral_address_t num_reg_rb_phy          ;
  public  : Tcontrol_t         read_rc                 ;
  public  : Tspecial_address_t num_reg_rc_log          ;
  public  : Tspecial_address_t num_reg_rc_phy          ;
#endif
  public  : Tcontrol_t         write_rd                ;
  public  : Tgeneral_address_t num_reg_rd_log          ;
  public  : Tgeneral_address_t num_reg_rd_phy_old      ;
  public  : Tgeneral_address_t num_reg_rd_phy_new      ;
  public  : Tcontrol_t         write_re                ;
  public  : Tspecial_address_t num_reg_re_log          ;
  public  : Tspecial_address_t num_reg_re_phy_old      ;
  public  : Tspecial_address_t num_reg_re_phy_new      ;

  public  : Texception_t       exception               ;
  public  : Texception_t       exception_use           ;

  public  : Tspecial_data_t    flags                   ;
  public  : Tcontrol_t         no_sequence             ;
//public  : Tcontrol_t         speculative             ;
//public  : Tgeneral_data_t    data_commit             ; // branch's destination
#ifdef DEBUG
  public  : Tgeneral_data_t    load_data               ;
  public  : Taddress_t         address                 ;
#endif
  public  : Taddress_t         address_next            ;
#ifdef DEBUG
  public  : double             cycle_rob_in            ;
  public  : double             cycle_commit            ;
#endif    

  };

}; // end namespace commit_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core
}; // end namespace behavioural

  template<> inline std::string toString<morpheo::behavioural::core::multi_ooo_engine::ooo_engine::commit_unit::Tretire_ooo_scheme_t>(const morpheo::behavioural::core::multi_ooo_engine::ooo_engine::commit_unit::Tretire_ooo_scheme_t& x)
  {
    switch (x)
      {
      case morpheo::behavioural::core::multi_ooo_engine::ooo_engine::commit_unit::RETIRE_IN_ORDER        : return "retire_in_order"       ; break;
      case morpheo::behavioural::core::multi_ooo_engine::ooo_engine::commit_unit::RETIRE_OOO_RENAME_UNIT : return "retire_ooo_rename_unit"; break;
      case morpheo::behavioural::core::multi_ooo_engine::ooo_engine::commit_unit::RETIRE_OOO_CONTEXT     : return "retire_ooo_context"    ; break;
      default    : return ""      ; break;
      }
  };

  template<> inline morpheo::behavioural::core::multi_ooo_engine::ooo_engine::commit_unit::Tretire_ooo_scheme_t fromString<morpheo::behavioural::core::multi_ooo_engine::ooo_engine::commit_unit::Tretire_ooo_scheme_t>(const std::string& x)
  {
    if ((x.compare(toString(static_cast<uint32_t>(morpheo::behavioural::core::multi_ooo_engine::ooo_engine::commit_unit::RETIRE_IN_ORDER       ))) == 0) or
        (x.compare(toString(                      morpheo::behavioural::core::multi_ooo_engine::ooo_engine::commit_unit::RETIRE_IN_ORDER        )) == 0))
      return morpheo::behavioural::core::multi_ooo_engine::ooo_engine::commit_unit::RETIRE_IN_ORDER;

    if ((x.compare(toString(static_cast<uint32_t>(morpheo::behavioural::core::multi_ooo_engine::ooo_engine::commit_unit::RETIRE_OOO_RENAME_UNIT))) == 0) or
        (x.compare(toString(                      morpheo::behavioural::core::multi_ooo_engine::ooo_engine::commit_unit::RETIRE_OOO_RENAME_UNIT )) == 0))
      return morpheo::behavioural::core::multi_ooo_engine::ooo_engine::commit_unit::RETIRE_OOO_RENAME_UNIT;

    if ((x.compare(toString(static_cast<uint32_t>(morpheo::behavioural::core::multi_ooo_engine::ooo_engine::commit_unit::RETIRE_OOO_CONTEXT    ))) == 0) or
        (x.compare(toString(                      morpheo::behavioural::core::multi_ooo_engine::ooo_engine::commit_unit::RETIRE_OOO_CONTEXT     )) == 0))
      return morpheo::behavioural::core::multi_ooo_engine::ooo_engine::commit_unit::RETIRE_OOO_CONTEXT;

    throw (ERRORMORPHEO ("fromString","Unknow string : \""+x+"\""));
  };

 template<> inline std::string toString<morpheo::behavioural::core::multi_ooo_engine::ooo_engine::commit_unit::rob_state_t>(const morpheo::behavioural::core::multi_ooo_engine::ooo_engine::commit_unit::rob_state_t& x)
  {
    switch (x)
      {
      case morpheo::behavioural::core::multi_ooo_engine::ooo_engine::commit_unit::ROB_EMPTY                      : return "ROB_EMPTY"                       ; break;
      case morpheo::behavioural::core::multi_ooo_engine::ooo_engine::commit_unit::ROB_BRANCH_WAIT_END            : return "ROB_BRANCH_WAIT_END"             ; break;
      case morpheo::behavioural::core::multi_ooo_engine::ooo_engine::commit_unit::ROB_BRANCH_COMPLETE            : return "ROB_BRANCH_COMPLETE"             ; break;
      case morpheo::behavioural::core::multi_ooo_engine::ooo_engine::commit_unit::ROB_STORE_WAIT_END_OK          : return "ROB_STORE_WAIT_END_OK"           ; break;
      case morpheo::behavioural::core::multi_ooo_engine::ooo_engine::commit_unit::ROB_STORE_WAIT_END_KO          : return "ROB_STORE_WAIT_END_KO"           ; break;
      case morpheo::behavioural::core::multi_ooo_engine::ooo_engine::commit_unit::ROB_STORE_OK                   : return "ROB_STORE_OK"                    ; break;
      case morpheo::behavioural::core::multi_ooo_engine::ooo_engine::commit_unit::ROB_STORE_KO                   : return "ROB_STORE_KO"                    ; break;
      case morpheo::behavioural::core::multi_ooo_engine::ooo_engine::commit_unit::ROB_STORE_OK_WAIT_END          : return "ROB_STORE_OK_WAIT_END"           ; break;
      case morpheo::behavioural::core::multi_ooo_engine::ooo_engine::commit_unit::ROB_STORE_KO_WAIT_END          : return "ROB_STORE_KO_WAIT_END"           ; break;
      case morpheo::behavioural::core::multi_ooo_engine::ooo_engine::commit_unit::ROB_STORE_EVENT                : return "ROB_STORE_EVENT"                 ; break;
      case morpheo::behavioural::core::multi_ooo_engine::ooo_engine::commit_unit::ROB_OTHER_WAIT_END             : return "ROB_OTHER_WAIT_END"              ; break;
      case morpheo::behavioural::core::multi_ooo_engine::ooo_engine::commit_unit::ROB_EVENT_WAIT_END             : return "ROB_EVENT_WAIT_END"              ; break;
      case morpheo::behavioural::core::multi_ooo_engine::ooo_engine::commit_unit::ROB_END_OK_SPECULATIVE         : return "ROB_END_OK_SPECULATIVE"          ; break;
      case morpheo::behavioural::core::multi_ooo_engine::ooo_engine::commit_unit::ROB_END_OK                     : return "ROB_END_OK"                      ; break;
      case morpheo::behavioural::core::multi_ooo_engine::ooo_engine::commit_unit::ROB_END_KO_SPECULATIVE         : return "ROB_END_KO_SPECULATIVE"          ; break;
      case morpheo::behavioural::core::multi_ooo_engine::ooo_engine::commit_unit::ROB_END_KO                     : return "ROB_END_KO"                      ; break;
      case morpheo::behavioural::core::multi_ooo_engine::ooo_engine::commit_unit::ROB_END_BRANCH_MISS_SPECULATIVE: return "ROB_END_BRANCH_MISS_SPECULATIVE" ; break;
      case morpheo::behavioural::core::multi_ooo_engine::ooo_engine::commit_unit::ROB_END_BRANCH_MISS            : return "ROB_END_BRANCH_MISS"             ; break;
      case morpheo::behavioural::core::multi_ooo_engine::ooo_engine::commit_unit::ROB_END_LOAD_MISS_SPECULATIVE  : return "ROB_END_LOAD_MISS_SPECULATIVE"   ; break;
      case morpheo::behavioural::core::multi_ooo_engine::ooo_engine::commit_unit::ROB_END_LOAD_MISS_UPDATE       : return "ROB_END_LOAD_MISS_UPDATE"        ; break;
      case morpheo::behavioural::core::multi_ooo_engine::ooo_engine::commit_unit::ROB_END_LOAD_MISS              : return "ROB_END_LOAD_MISS"               ; break;
      case morpheo::behavioural::core::multi_ooo_engine::ooo_engine::commit_unit::ROB_END_MISS                   : return "ROB_END_MISS"                    ; break;
      case morpheo::behavioural::core::multi_ooo_engine::ooo_engine::commit_unit::ROB_END_EXCEPTION_WAIT_HEAD    : return "ROB_END_EXCEPTION_WAIT_HEAD"     ; break;
      case morpheo::behavioural::core::multi_ooo_engine::ooo_engine::commit_unit::ROB_END_EXCEPTION_UPDATE       : return "ROB_END_EXCEPTION_UPDATE"        ; break;
      case morpheo::behavioural::core::multi_ooo_engine::ooo_engine::commit_unit::ROB_END_EXCEPTION              : return "ROB_END_EXCEPTION"               ; break;
      case morpheo::behavioural::core::multi_ooo_engine::ooo_engine::commit_unit::ROB_END                        : return "ROB_END"                         ; break;

      default    : return ""      ; break;
      }
  };

}; // end namespace morpheo              

#endif
