/*
 * $Id: Parameters.cpp 110 2009-02-19 16:31:47Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Load_Store_pointer_unit/include/Parameters.h"
#include "Common/include/Max.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace load_store_pointer_unit {


#undef  FUNCTION
#define FUNCTION "Load_Store_pointer_unit::Parameters"
  Parameters::Parameters (uint32_t    nb_front_end                    ,
			  uint32_t  * nb_context                      ,
//                        uint32_t    size_front_end_id               ,
//                        uint32_t    size_context_id                 ,
			  uint32_t    nb_load_store_queue             ,
			  uint32_t  * size_store_queue                ,
			  uint32_t  * size_load_queue                 ,
                          uint32_t  * nb_inst_memory                  ,
			  uint32_t ** link_load_store_unit_with_thread,
			  uint32_t    nb_inst_insert                  ,
			  uint32_t    nb_inst_retire                  ,
                          bool        is_toplevel
                          )
  {
    log_printf(FUNC,Load_Store_pointer_unit,FUNCTION,"Begin");

    _nb_front_end                     = nb_front_end                    ;
    _nb_context                       = nb_context                      ;
    _nb_load_store_queue              = nb_load_store_queue             ;
    _size_store_queue                 = size_store_queue                ;
    _size_load_queue                  = size_load_queue                 ;
    _nb_inst_memory                   = nb_inst_memory                  ;
    _link_load_store_unit_with_thread = link_load_store_unit_with_thread;
    _nb_inst_insert                   = nb_inst_insert                  ;
    _nb_inst_retire                   = nb_inst_retire                  ;
   
    test();

    _max_size_store_queue             = max<uint32_t>(_size_store_queue,_nb_load_store_queue);
    _max_size_load_queue              = max<uint32_t>(_size_load_queue ,_nb_load_store_queue);

    if (is_toplevel)
      {
        _size_front_end_id                = log2(_nb_front_end);
        _size_context_id                  = log2(max<uint32_t>(_nb_context,_nb_front_end));
        _size_store_queue_ptr             = log2(max<uint32_t>(size_store_queue, nb_load_store_queue));
        _size_load_queue_ptr              = log2(max<uint32_t>(size_load_queue,  nb_load_store_queue));

        _have_port_front_end_id           = (_size_front_end_id   > 0);
        _have_port_context_id             = (_size_context_id     > 0);
        _have_port_load_queue_ptr         = (_size_load_queue_ptr > 0);
    
        copy();
      }

    log_printf(FUNC,Load_Store_pointer_unit,FUNCTION,"End");
  };
  
// #undef  FUNCTION
// #define FUNCTION "Load_Store_pointer_unit::Parameters (copy)"
//   Parameters::Parameters (Parameters & param)
//   {
//     log_printf(FUNC,Load_Store_pointer_unit,FUNCTION,"Begin");
//     test();
//     log_printf(FUNC,Load_Store_pointer_unit,FUNCTION,"End");
//   };

#undef  FUNCTION
#define FUNCTION "Load_Store_pointer_unit::~Parameters"
  Parameters::~Parameters (void) 
  {
    log_printf(FUNC,Load_Store_pointer_unit,FUNCTION,"Begin");
    log_printf(FUNC,Load_Store_pointer_unit,FUNCTION,"End");
  };

#undef  FUNCTION
#define FUNCTION "Load_Store_pointer_unit::copy"
  void Parameters::copy (void) 
  {
    log_printf(FUNC,Load_Store_pointer_unit,FUNCTION,"Begin");
    log_printf(FUNC,Load_Store_pointer_unit,FUNCTION,"End");
  };

}; // end namespace load_store_pointer_unit
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
