#ifndef morpheo_behavioural_generic_comparator_Types_h
#define morpheo_behavioural_generic_comparator_Types_h

/*
 * $Id: Types.h 112 2009-03-18 22:36:26Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Types.h"

namespace morpheo {
namespace behavioural {
namespace generic {
namespace comparator {

typedef enum
  {
    COMPARATOR_EQUAL           ,
    COMPARATOR_NOT_EQUAL       ,
    COMPARATOR_GREATER         ,
    COMPARATOR_GREATER_OR_EQUAL,
    COMPARATOR_LESS            ,
    COMPARATOR_LESS_OR_EQUAL
  } Tcomparator_scheme_t;

  typedef Tgeneral_data_t Tdata_t;

}; // end namespace comparator
}; // end namespace generic
}; // end namespace behavioural

  template<> inline std::string toString<morpheo::behavioural::generic::comparator::Tcomparator_scheme_t>(const morpheo::behavioural::generic::comparator::Tcomparator_scheme_t& x)
  {
    switch (x)
      {
      case morpheo::behavioural::generic::comparator::COMPARATOR_EQUAL            : return "equal"           ; break;
      case morpheo::behavioural::generic::comparator::COMPARATOR_NOT_EQUAL        : return "not_equal"       ; break;
      case morpheo::behavioural::generic::comparator::COMPARATOR_GREATER          : return "greater"         ; break;
      case morpheo::behavioural::generic::comparator::COMPARATOR_GREATER_OR_EQUAL : return "greater_or_equal"; break;
      case morpheo::behavioural::generic::comparator::COMPARATOR_LESS             : return "less"            ; break;
      case morpheo::behavioural::generic::comparator::COMPARATOR_LESS_OR_EQUAL    : return "less_or_equal"   ; break;
      default : return ""; break;
      }
  };

  template<> inline morpheo::behavioural::generic::comparator::Tcomparator_scheme_t fromString<morpheo::behavioural::generic::comparator::Tcomparator_scheme_t>(const std::string& x)
  {
    if ((x.compare(toString(static_cast<uint32_t>(morpheo::behavioural::generic::comparator::COMPARATOR_EQUAL))) == 0) or
        (x.compare("equal") == 0))
      return morpheo::behavioural::generic::comparator::COMPARATOR_EQUAL;

    if ((x.compare(toString(static_cast<uint32_t>(morpheo::behavioural::generic::comparator::COMPARATOR_NOT_EQUAL))) == 0) or
        (x.compare("not_equal") == 0))
      return morpheo::behavioural::generic::comparator::COMPARATOR_NOT_EQUAL;

    if ((x.compare(toString(static_cast<uint32_t>(morpheo::behavioural::generic::comparator::COMPARATOR_GREATER))) == 0) or
        (x.compare("greater") == 0))
      return morpheo::behavioural::generic::comparator::COMPARATOR_GREATER;

    if ((x.compare(toString(static_cast<uint32_t>(morpheo::behavioural::generic::comparator::COMPARATOR_GREATER_OR_EQUAL))) == 0) or
        (x.compare("greater_or_equal") == 0))
      return morpheo::behavioural::generic::comparator::COMPARATOR_GREATER_OR_EQUAL;

    if ((x.compare(toString(static_cast<uint32_t>(morpheo::behavioural::generic::comparator::COMPARATOR_LESS))) == 0) or
        (x.compare("less") == 0))
      return morpheo::behavioural::generic::comparator::COMPARATOR_LESS;

    if ((x.compare(toString(static_cast<uint32_t>(morpheo::behavioural::generic::comparator::COMPARATOR_LESS_OR_EQUAL))) == 0) or
        (x.compare("less_or_equal") == 0))
      return morpheo::behavioural::generic::comparator::COMPARATOR_LESS_OR_EQUAL;

    throw (ErrorMorpheo ("<fromString> : Unknow string : \""+x+"\""));
  };


}; // end namespace morpheo              

#endif
