#ifndef morpheo_behavioural_generic_victim_Victim_h
#define morpheo_behavioural_generic_victim_Victim_h

/*
 * $Id: Victim.h 82 2008-05-01 16:48:45Z rosiere $
 *
 * [ Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#include <iostream>
#include "Common/include/ToString.h"
#include "Common/include/Debug.h"
#include "Behavioural/include/Types.h"

#include "Behavioural/Generic/Victim/include/Types.h"
#include "Behavioural/Generic/Victim/include/Parameters.h"
#ifdef STATISTICS
#include "Behavioural/include/Stat.h"
#endif
#include "Behavioural/include/Component.h"
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#include "Behavioural/include/Usage.h"

// #include "Behavioural/Generic/Victim/Victim_Random/include/Victim_Random.h"
// #include "Behavioural/Generic/Victim/Victim_Round_Robin/include/Victim_Round_Robin.h"
// #include "Behavioural/Generic/Victim/Victim_NLU/include/Victim_NLU.h"
#include "Behavioural/Generic/Victim/Victim_Pseudo_LRU/include/Victim_Pseudo_LRU.h"
// #include "Behavioural/Generic/Victim/Victim_LRU/include/Victim_LRU.h"
// #include "Behavioural/Generic/Victim/Victim_FIFO/include/Victim_FIFO.h"

namespace morpheo {
namespace behavioural {
namespace generic {
namespace victim {

  class Victim 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[ fields ]----------------------------------------------------
    // Parameters
  protected : const std::string  _name;
  protected : const Parameters * _param;
  private   : const Tusage_t     _usage;

#ifdef STATISTICS
  public    : Stat                           * _stat;
#endif

  public    : Component                      * _component;

#ifdef SYSTEMC
    // ~~~~~[ Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_CLOCK                      *  in_CLOCK        ;
  public    : SC_IN (Tcontrol_t)            *  in_NRESET       ;

    // ~~~~~[ Interface : "Access" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t)           **  in_ACCESS_VAL    ;
  public    : SC_OUT(Tcontrol_t)           ** out_ACCESS_ACK    ;
  public    : SC_IN (Taddress_t)           **  in_ACCESS_ADDRESS;
  public    : SC_IN (Tcontrol_t)           **  in_ACCESS_HIT    ;
  public    : SC_IN (Tentity_t )           **  in_ACCESS_ENTITY ;
  public    : SC_OUT(Tentity_t )           ** out_ACCESS_VICTIM ;

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

//public : morpheo::behavioural::generic::victim::victim_random     ::Victim_Random      * _component_victim_random     ;
//public : morpheo::behavioural::generic::victim::victim_round_robin::Victim_Round_Robin * _component_victim_round_robin;
//public : morpheo::behavioural::generic::victim::victim_nlu        ::Victim_NLU         * _component_victim_nlu        ;
  public : morpheo::behavioural::generic::victim::victim_pseudo_lru ::Victim_Pseudo_LRU  * _component_victim_pseudo_lru ;
//public : morpheo::behavioural::generic::victim::victim_lru        ::Victim_LRU         * _component_victim_lru        ;
//public : morpheo::behavioural::generic::victim::victim_fifo       ::Victim_FIFO        * _component_victim_fifo       ;

    // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#endif

    // -----[ Methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (Victim);
#endif
  public  :          Victim              
  (
#ifdef SYSTEMC
   sc_module_name                                name,
#else					       
   std::string                                   name,
#endif					       
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   Parameters                                  * param,
   morpheo::behavioural::Tusage_t                usage
   );
  public  :          ~Victim             (void);
					       
  private : void        allocation                (
#ifdef STATISTICS
						   morpheo::behavioural::Parameters_Statistics * param_statistics
#else
						   void
#endif
						   );
  private : void        deallocation              (void);
  };
}; // end namespace victim
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
