#!/bin/bash

#-----------------------------------------------------------
# $Id: list_sensitive.sh 132 2009-07-11 16:39:35Z rosiere $
#-----------------------------------------------------------
declare path;
declare path_src;
declare entity;
declare _path_src="src";
declare remove_comments="${MORPHEO_SCRIPT}/remove_comments.sed"

#-----[ usage ]---------------------------------------------
function usage ()
{
    echo "Usage     : ${0}";

    exit;
}

#-----[ test_usage ]----------------------------------------
function test_usage ()
{
    if test -z "${MORPHEO_SCRIPT}"; then
        echo "Environment variable MORPHEO_SCRIPT is not set";
        distexe_usage;
    fi;

    if test ! -d ${path_src}; then
	echo "Directory ${path_src} don't exist";
	usage ${*};
    fi;
}

#-----[ list_sensitive ]------------------------------------
function list_sensitive ()
{
    path=${PWD};
    path_src=${path}/${_path_src};
    entity=$(basename ${path});

    test_usage ${*};

    echo "  * ${entity}";

    # 1) Erase comment
    # 2) Erase all newline
    # 3) Add newline before each SC_METHOD
    # 4) Replace all tab by space
    # 5) Erase all space

    export file1=${path_src}/${entity}.cpp;

    sc_methods=$(sed -f ${remove_comments} ${file1}  | tr -d '\n' |sed s/SC_METHOD/\\nSC_METHOD/g |sed s/\\t/\ /g | sed s/\ //g | grep SC_METHOD)

    for sc_method in ${sc_methods}; do
	method=$(echo ${sc_method} |sed s/SC_METHOD\(//g |cut -d ')' -f 1);
 	echo "    * ${method}";

        file2=${path_src}/${entity}_${method}.cpp;

    	#  1) erase comment
        #  2) Replace all tab by space
        #  3) Erase all space
    	#  4) add a previous newline before each port_read.
    	#  5) add an space before each )
    	#  6) replace all space by an newline
    	#  7) grep PORT_READ(
    	#  8) replace PORT_READ( by nothing
    	#  9) erase array
    	# 10) sort
    	# 11) erase duplicate port
    	ports_read=$(sed -f ${remove_comments} ${file2} |sed s/\\t/\ /g | sed s/\ //g | sed s/PORT_READ/\\nPORT_READ/g | sed s/\)/\ /g | sed s/\ /\\n/g | grep PORT_READ | sed s/PORT_READ\(//g |cut -d '[' -f 1 |sort |uniq);

	# 1) add space before (*(
	list_sensitives=$(echo ${sc_method} |sed s/\(\\*\(/\\n/g);
	list_sensitive="";

	local -i first=1;
	for sensitive in ${list_sensitives}; do
	    if test ${first} -eq 0; then
		signal=$(echo ${sensitive} |cut -d '[' -f 1 |cut -d ')' -f 1);

		list_sensitive=${list_sensitive}" "${signal};

# 		echo -n "    * ${signal}";

#		if test $(echo ${ports_read} | grep -c ${signal}) -eq 0; then
# 		    echo "    * ${signal} in sensitive list, not in file";
##		else
##		    echo " ... OK";
#		fi;
	    else
		first=0;
	    fi;
	done;

	if test "${method}" != "transition" -a "${method}" != "constant" ; then
    	    for port in ${ports_read}; do
		if test $(echo ${list_sensitive} | grep -c ${port}) -eq 0; then
		    echo "      * ${port} in file, not in sensitive list";
		fi;
    	    done;
	fi;

    done;
}

#-----[ Corps ]---------------------------------------------
list_sensitive ${*};
