/********************************************
 * files               : asm_016_load.s
 * authors             : Rosiere Mathieu
 * date                : 2006/06/20
 ********************************************
 * input               : -
 * output              : 1 test OK
 *                       0 test KO
 ********************************************
 * test                :
 * warning             : instruction ok 
 *                         l.addi
 *                         l.and
 *                         l.bf
 *                         l.jal
 *                         l.jr
 *			   l.sw
 ********************************************
 */
	.file	"asm_016_load.s"
	.section .text
	.align	4

	.global _asm_016_load
_asm_016_load :	
	/* save context */
	l.addi	r1,r1,-16
	/*      0 (r1) is reserved */
	l.sw	4 (r1),r20
	l.sw	8 (r1),r21
	l.sw	12(r1),r22

	/* Return is KO (default)*/
	l.and   r11,r0,r0

	/* Value Not Signed */
 	l.movhi	r20,0x1234
	l.ori	r20,r20,0x5678
		
	/* TEST BYTES */
	l.sb	0 (r1), r20
	l.lbz	r21, 0 (r1)
	l.extbz	r22,r20

	l.sfeq	r21,r22
	l.bnf	_asm_016_load_ko
	l.nop	1

	l.lbs	r21, 0 (r1)
	l.extbs	r22,r20

	l.sfeq	r21,r22
	l.bnf	_asm_016_load_ko
	l.nop	1

	/* TEST HALF WORD */
	l.sh	0 (r1), r20
	l.lhz	r21, 0 (r1)
	l.exthz	r22,r20

	l.sfeq	r21,r22
	l.bnf	_asm_016_load_ko
	l.nop	1

	l.lhs	r21, 0 (r1)
	l.exths	r22,r20

	l.sfeq	r21,r22
	l.bnf	_asm_016_load_ko
	l.nop	1

	/* TEST WORD */
	l.sw	0 (r1), r20
	l.lwz	r21, 0 (r1)
	l.extwz	r22,r20

	l.sfeq	r21,r22
	l.bnf	_asm_016_load_ko
	l.nop	1

	l.lws	r21, 0 (r1)
	l.extws	r22,r20

	l.sfeq	r21,r22
	l.bnf	_asm_016_load_ko
	l.nop	1

	/* Value Signed */
 	l.movhi	r20,0xdead
	l.ori	r20,r20,0xbeaf
		
	/* TEST BYTES */
	l.sb	0 (r1), r20
	l.lbz	r21, 0 (r1)
	l.extbz	r22,r20

	l.sfeq	r21,r22
	l.bnf	_asm_016_load_ko
	l.nop	1

	l.lbs	r21, 0 (r1)
	l.extbs	r22,r20

	l.sfeq	r21,r22
	l.bnf	_asm_016_load_ko
	l.nop	1

	/* TEST HALF WORD */
	l.sh	0 (r1), r20
	l.lhz	r21, 0 (r1)
	l.exthz	r22,r20

	l.sfeq	r21,r22
	l.bnf	_asm_016_load_ko
	l.nop	1

	l.lhs	r21, 0 (r1)
	l.exths	r22,r20

	l.sfeq	r21,r22
	l.bnf	_asm_016_load_ko
	l.nop	1

	/* TEST WORD */
	l.sw	0 (r1), r20
	l.lwz	r21, 0 (r1)
	l.extwz	r22,r20

	l.sfeq	r21,r22
	l.bnf	_asm_016_load_ko
	l.nop	1

	l.lws	r21, 0 (r1)
	l.extws	r22,r20

	l.sfeq	r21,r22
	l.bnf	_asm_016_load_ko
	l.nop	1
			
_asm_016_load_ok :	
	l.addi	r11,r0,1
_asm_016_load_ko :
	
	/* load context */
	l.lwz	r22,12(r1)
	l.lwz	r21,8 (r1)
	l.lwz	r20,4 (r1)
	/*          0 (r1) is reserved */	
	l.jr	r9
	l.addi	r1,r1,16
