/*
 * $Id: Instance_fromInternalStructure.cpp 138 2010-05-12 17:34:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Configuration/include/Instance.h"
#include "Behavioural/include/Allocation.h"
#include "Common/include/FromString.h"

namespace morpheo {
namespace behavioural {
namespace configuration {

#undef  FUNCTION
#define FUNCTION "Instance::fromInternalStructure"
  void Instance::fromInternalStructure (void)
  {
    //-----------------------------------------------------
    // Common
    //-----------------------------------------------------
  //log_printf(INFO,Configuration,FUNCTION,_("COMMON"));

    _param->_size_general_data   = fromString<uint32_t>(getParam("size_data"          , ""));
    _param->_size_special_data   = SIZE_SPECIAL_DATA; // Constant

    _param->_nb_thread           = fromString<uint32_t>(getParam("nb_thread"          , ""));
    _param->_nb_decod_bloc       = fromString<uint32_t>(getParam("nb_decod_bloc"      , ""));
    _param->_nb_rename_bloc      = fromString<uint32_t>(getParam("nb_rename_bloc"     , ""));
    _param->_nb_read_bloc        = fromString<uint32_t>(getParam("nb_read_bloc"       , ""));
    _param->_nb_write_bloc       = fromString<uint32_t>(getParam("nb_write_bloc"      , ""));
    _param->_nb_load_store_unit  = fromString<uint32_t>(getParam("nb_load_store_unit" , ""));
    _param->_nb_functionnal_unit = fromString<uint32_t>(getParam("nb_functionnal_unit", ""));
    _param->_nb_front_end        = fromString<uint32_t>(getParam("nb_front_end"       , ""));
    _param->_nb_ooo_engine       = fromString<uint32_t>(getParam("nb_ooo_engine"      , ""));
    _param->_nb_execute_loop     = fromString<uint32_t>(getParam("nb_execute_loop"    , ""));

    //-----------------------------------------------------
    // Thread
    //-----------------------------------------------------

    ALLOC1(_param->_size_ifetch_queue,uint32_t,_param->_nb_thread);
    ALLOC1(_param->_ifetch_queue_scheme           ,morpheo::behavioural::core::multi_front_end::front_end::ifetch_unit::ifetch_queue::Tifetch_queue_scheme_t
                                              ,_param->_nb_thread);
    ALLOC1(_param->_nb_inst_fetch    ,uint32_t,_param->_nb_thread);
    ALLOC2(_param->_implement_group  ,bool    ,_param->_nb_thread,NB_GROUP);
    ALLOC1(_param->_ras_size_queue   ,uint32_t,_param->_nb_thread);
    ALLOC1(_param->_upt_size_queue   ,uint32_t,_param->_nb_thread);
    ALLOC1(_param->_ufpt_size_queue  ,uint32_t,_param->_nb_thread);
    
    for (uint32_t i=0; i<_param->_nb_thread; ++i)
      {
      //log_printf(INFO,Configuration,FUNCTION,_("THREAD [%d]"),i);

        _param->_size_ifetch_queue   [i] = fromString<uint32_t>(getParam("size_ifetch_queue"  , "thread",toString(i).c_str(),""));
        _param->_ifetch_queue_scheme [i] = fromString<morpheo::behavioural::core::multi_front_end::front_end::ifetch_unit::ifetch_queue::Tifetch_queue_scheme_t> 
                                                               (getParam("ifetch_queue_scheme", "thread",toString(i).c_str(),""));
        _param->_nb_inst_fetch       [i] = fromString<uint32_t>(getParam("nb_inst_fetch"      , "thread",toString(i).c_str(),""));
        _param->_ras_size_queue      [i] = fromString<uint32_t>(getParam("ras_size_queue"     , "thread",toString(i).c_str(),""));
        _param->_upt_size_queue      [i] = fromString<uint32_t>(getParam("upt_size_queue"     , "thread",toString(i).c_str(),""));
        _param->_ufpt_size_queue     [i] = fromString<uint32_t>(getParam("ufpt_size_queue"    , "thread",toString(i).c_str(),""));

        // just read !!!
        try
          {
            getParam("nb_group","thread",toString(i).c_str(), "");
          }
        catch (morpheo::ErrorMorpheo & error)
          {
          }

        for (uint32_t j=0; j<NB_GROUP; ++j)
          {
            _param->_implement_group [i][j] = fromString<bool>(getParam("implement_group", 
                                                                       "thread",toString(i).c_str(),
                                                                       "group" ,toString(j).c_str(),""));
          }
      }

    //-----------------------------------------------------
    // Decod_bloc
    //-----------------------------------------------------

    ALLOC1(_param->_size_decod_queue             ,uint32_t         ,_param->_nb_decod_bloc);
    ALLOC1(_param->_decod_queue_scheme           ,morpheo::behavioural::core::multi_front_end::front_end::decod_unit::decod_queue::Tdecod_queue_scheme_t
                                                                   ,_param->_nb_decod_bloc);
    ALLOC1(_param->_nb_inst_decod                ,uint32_t         ,_param->_nb_decod_bloc);
    ALLOC1(_param->_nb_context_select            ,uint32_t         ,_param->_nb_decod_bloc);
    ALLOC1(_param->_context_select_priority      ,Tpriority_t      ,_param->_nb_decod_bloc);
    ALLOC1(_param->_context_select_load_balancing,Tload_balancing_t,_param->_nb_decod_bloc);

    for (uint32_t i=0; i<_param->_nb_decod_bloc; ++i)
      {
      //log_printf(INFO,Configuration,FUNCTION,_("DECOD_BLOC [%d]"),i);

        _param->_size_decod_queue              [i] = fromString<uint32_t         > (getParam("size_decod_queue"             , "decod_bloc",toString(i).c_str(),""));
        _param->_decod_queue_scheme            [i] = fromString<morpheo::behavioural::core::multi_front_end::front_end::decod_unit::decod_queue::Tdecod_queue_scheme_t> 
                                                                                   (getParam("decod_queue_scheme"           , "decod_bloc",toString(i).c_str(),""));
        _param->_nb_inst_decod                 [i] = fromString<uint32_t         > (getParam("nb_inst_decod"                , "decod_bloc",toString(i).c_str(),""));
        _param->_nb_context_select             [i] = fromString<uint32_t         > (getParam("nb_context_select"            , "decod_bloc",toString(i).c_str(),""));
        _param->_context_select_priority       [i] = fromString<Tpriority_t      > (getParam("context_select_priority"      , "decod_bloc",toString(i).c_str(),""));
        _param->_context_select_load_balancing [i] = fromString<Tload_balancing_t> (getParam("context_select_load_balancing", "decod_bloc",toString(i).c_str(),""));
      }

    //-----------------------------------------------------
    // Rename_bloc
    //-----------------------------------------------------

    ALLOC1(_param->_nb_inst_insert                   ,uint32_t         ,_param->_nb_rename_bloc);
    ALLOC1(_param->_nb_inst_retire                   ,uint32_t         ,_param->_nb_rename_bloc);
    ALLOC1(_param->_rename_select_priority           ,Tpriority_t      ,_param->_nb_rename_bloc);
    ALLOC1(_param->_rename_select_load_balancing     ,Tload_balancing_t,_param->_nb_rename_bloc);
    ALLOC1(_param->_rename_select_nb_front_end_select,uint32_t         ,_param->_nb_rename_bloc);
    ALLOC1(_param->_nb_general_register              ,uint32_t         ,_param->_nb_rename_bloc);
    ALLOC1(_param->_nb_special_register              ,uint32_t         ,_param->_nb_rename_bloc);
    ALLOC1(_param->_nb_reg_free                      ,uint32_t         ,_param->_nb_rename_bloc);
    ALLOC1(_param->_nb_rename_unit_bank              ,uint32_t         ,_param->_nb_rename_bloc);
//     ALLOC1(_param->_size_read_counter                ,uint32_t         ,_param->_nb_rename_bloc);

    for (uint32_t i=0; i<_param->_nb_rename_bloc; ++i)
      {
      //log_printf(INFO,Configuration,FUNCTION,_("RENAME_BLOC [%d]"),i);

        _param->_nb_inst_insert                    [i] = fromString<uint32_t         > (getParam("nb_inst_insert"                   , "rename_bloc",toString(i).c_str(),""));
        _param->_nb_inst_retire                    [i] = fromString<uint32_t         > (getParam("nb_inst_retire"                   , "rename_bloc",toString(i).c_str(),""));
        _param->_rename_select_priority            [i] = fromString<Tpriority_t      > (getParam("rename_select_priority"           , "rename_bloc",toString(i).c_str(),""));
        _param->_rename_select_load_balancing      [i] = fromString<Tload_balancing_t> (getParam("rename_select_load_balancing"     , "rename_bloc",toString(i).c_str(),""));
        _param->_rename_select_nb_front_end_select [i] = fromString<uint32_t         > (getParam("rename_select_nb_front_end_select", "rename_bloc",toString(i).c_str(),""));
        _param->_nb_general_register               [i] = fromString<uint32_t         > (getParam("nb_general_register"              , "rename_bloc",toString(i).c_str(),""));
        _param->_nb_special_register               [i] = fromString<uint32_t         > (getParam("nb_special_register"              , "rename_bloc",toString(i).c_str(),""));
        _param->_nb_reg_free                       [i] = fromString<uint32_t         > (getParam("nb_reg_free"                      , "rename_bloc",toString(i).c_str(),""));
        _param->_nb_rename_unit_bank               [i] = fromString<uint32_t         > (getParam("nb_rename_unit_bank"              , "rename_bloc",toString(i).c_str(),""));
//         _param->_size_read_counter                 [i] = fromString<uint32_t         > (getParam("size_read_counter"                , "rename_bloc",toString(i).c_str(),""));
      }   

    //-----------------------------------------------------
    // Read_bloc
    //-----------------------------------------------------
    ALLOC1(_param->_nb_inst_read                      ,uint32_t,_param->_nb_read_bloc);
    ALLOC1(_param->_size_read_queue                   ,uint32_t,_param->_nb_read_bloc);
    ALLOC1(_param->_size_reservation_station          ,uint32_t,_param->_nb_read_bloc);
    ALLOC1(_param->_nb_inst_retire_reservation_station,uint32_t,_param->_nb_read_bloc);

    for (uint32_t i=0; i<_param->_nb_read_bloc; ++i)
      {
      //log_printf(INFO,Configuration,FUNCTION,_("READ_BLOC [%d]"),i);

        _param->_nb_inst_read                       [i] = fromString<uint32_t> (getParam("nb_inst_read"                      ,"read_bloc",toString(i).c_str(),""));
        _param->_size_read_queue                    [i] = fromString<uint32_t> (getParam("size_read_queue"                   ,"read_bloc",toString(i).c_str(),""));
        _param->_size_reservation_station           [i] = fromString<uint32_t> (getParam("size_reservation_station"          ,"read_bloc",toString(i).c_str(),""));
        _param->_nb_inst_retire_reservation_station [i] = fromString<uint32_t> (getParam("nb_inst_retire_reservation_station","read_bloc",toString(i).c_str(),""));
      }   

    //-----------------------------------------------------
    // Write_bloc
    //-----------------------------------------------------
    ALLOC1(_param->_nb_inst_write     ,uint32_t,_param->_nb_write_bloc);
    ALLOC1(_param->_size_write_queue  ,uint32_t,_param->_nb_write_bloc);
    ALLOC1(_param->_size_execute_queue,uint32_t,_param->_nb_write_bloc);
    ALLOC1(_param->_nb_bypass_write   ,uint32_t,_param->_nb_write_bloc);
    ALLOC1(_param->_write_queue_scheme,core::multi_execute_loop::execute_loop::multi_write_unit::write_unit::write_queue::Twrite_queue_scheme_t,_param->_nb_write_bloc);

    for (uint32_t i=0; i<_param->_nb_write_bloc; ++i)
      {
      //log_printf(INFO,Configuration,FUNCTION,_("WRITE_BLOC [%d]"),i);

        _param->_nb_inst_write      [i] = fromString<uint32_t> (getParam("nb_inst_write"     ,"write_bloc",toString(i).c_str(),""));
        _param->_size_write_queue   [i] = fromString<uint32_t> (getParam("size_write_queue"  ,"write_bloc",toString(i).c_str(),""));
        _param->_size_execute_queue [i] = fromString<uint32_t> (getParam("size_execute_queue","write_bloc",toString(i).c_str(),""));
        _param->_nb_bypass_write    [i] = fromString<uint32_t> (getParam("nb_bypass_write"   ,"write_bloc",toString(i).c_str(),""));
	_param->_write_queue_scheme [i] = fromString<core::multi_execute_loop::execute_loop::multi_write_unit::write_unit::write_queue::Twrite_queue_scheme_t> (getParam("write_queue_scheme","write_bloc",toString(i).c_str(),""));
      }   

    //-----------------------------------------------------
    // load_store_unit
    //-----------------------------------------------------
    ALLOC1(_param->_size_store_queue                   ,uint32_t    ,_param->_nb_load_store_unit);
    ALLOC1(_param->_size_load_queue                    ,uint32_t    ,_param->_nb_load_store_unit);
    ALLOC1(_param->_size_speculative_access_queue      ,uint32_t    ,_param->_nb_load_store_unit);
    ALLOC1(_param->_nb_store_queue_bank                ,uint32_t    ,_param->_nb_load_store_unit);
    ALLOC1(_param->_nb_load_queue_bank                 ,uint32_t    ,_param->_nb_load_store_unit);
    ALLOC1(_param->_nb_port_check                      ,uint32_t    ,_param->_nb_load_store_unit);
    ALLOC1(_param->_speculative_load                   ,core::multi_execute_loop::execute_loop::Tspeculative_load_t,_param->_nb_load_store_unit);
    ALLOC1(_param->_speculative_commit_predictor_scheme,Tpredictor_t,_param->_nb_load_store_unit);
    ALLOC2(_param->_lsu_pht_size_counter               ,uint32_t    ,_param->_nb_load_store_unit,1);
    ALLOC2(_param->_lsu_pht_nb_counter                 ,uint32_t    ,_param->_nb_load_store_unit,1);
    ALLOC1(_param->_nb_bypass_memory                   ,uint32_t    ,_param->_nb_load_store_unit);
    ALLOC1(_param->_nb_cache_port                      ,uint32_t    ,_param->_nb_load_store_unit);
    ALLOC1(_param->_nb_inst_memory                     ,uint32_t    ,_param->_nb_load_store_unit);

    for (uint32_t i=0; i<_param->_nb_load_store_unit; ++i)
      {
      //log_printf(INFO,Configuration,FUNCTION,_("LOAD_STORE_UNIT [%d]"),i);

        _param->_size_store_queue                    [i] = fromString<uint32_t    > (getParam("size_store_queue"                   ,"load_store_unit",toString(i).c_str(),""));
        _param->_size_load_queue                     [i] = fromString<uint32_t    > (getParam("size_load_queue"                    ,"load_store_unit",toString(i).c_str(),""));
        _param->_size_speculative_access_queue       [i] = fromString<uint32_t    > (getParam("size_speculative_access_queue"      ,"load_store_unit",toString(i).c_str(),""));
        _param->_nb_store_queue_bank                 [i] = fromString<uint32_t    > (getParam("nb_store_queue_bank"                ,"load_store_unit",toString(i).c_str(),""));
        _param->_nb_load_queue_bank                  [i] = fromString<uint32_t    > (getParam("nb_load_queue_bank"                 ,"load_store_unit",toString(i).c_str(),""));
        _param->_speculative_load                    [i] = fromString<core::multi_execute_loop::execute_loop::Tspeculative_load_t> 
                                                                                    (getParam("speculative_load"                   ,"load_store_unit",toString(i).c_str(),""));
        _param->_speculative_commit_predictor_scheme [i] = fromString<Tpredictor_t> 
                                                                                    (getParam("speculative_commit_predictor_scheme","load_store_unit",toString(i).c_str(),""));
        _param->_nb_port_check                       [i] = fromString<uint32_t    > (getParam("nb_port_check"                      ,"load_store_unit",toString(i).c_str(),""));
        
        // just read !!!
        try
          {
            getParam("nb_predictor","load_store_unit",toString(i).c_str(), "");
          }
        catch (morpheo::ErrorMorpheo & error)
          {
          }

        const uint32_t max_nb_predictor=1;
        for (uint32_t j=0; j<max_nb_predictor; ++j)
          {
          //log_printf(INFO,Configuration,FUNCTION,_("PREDICTOR [%d][%d]"),i,j);
        _param->_lsu_pht_size_counter             [i][j] = fromString<uint32_t    > (getParam("lsu_pht_size_counter"               ,"load_store_unit",toString(i).c_str(),"predictor",toString(j).c_str(), ""));
        _param->_lsu_pht_nb_counter               [i][j] = fromString<uint32_t    > (getParam("lsu_pht_nb_counter"                 ,"load_store_unit",toString(i).c_str(),"predictor",toString(j).c_str(), ""));
          }

        _param->_nb_bypass_memory                    [i] = fromString<uint32_t    > (getParam("nb_bypass_memory"                   ,"load_store_unit",toString(i).c_str(),""));
        _param->_nb_cache_port                       [i] = fromString<uint32_t    > (getParam("nb_cache_port"                      ,"load_store_unit",toString(i).c_str(),""));
        _param->_nb_inst_memory                      [i] = fromString<uint32_t    > (getParam("nb_inst_memory"                     ,"load_store_unit",toString(i).c_str(),""));
      }   

    //-----------------------------------------------------
    // functionnal_unit
    //-----------------------------------------------------
    ALLOC1(_param->_nb_inst_functionnal_unit,uint32_t,_param->_nb_functionnal_unit);
    ALLOC3(_param->_timing,core::multi_execute_loop::execute_loop::execute_timing_t,_param->_nb_functionnal_unit,MAX_TYPE,MAX_OPERATION);

    for (uint32_t i=0; i<_param->_nb_functionnal_unit; ++i)
      {
      //log_printf(INFO,Configuration,FUNCTION,_("FUNCTIONNAL_UNIT [%d]"),i);

        _param->_nb_inst_functionnal_unit [i] = fromString<uint32_t> (getParam("nb_inst_functionnal_unit","functionnal_unit",toString(i).c_str(),""));

        // just read !!!
        try
          {
            getParam("nb_type","functionnal_unit",toString(i).c_str(), "");
          }
        catch (morpheo::ErrorMorpheo & error)
          {
          }

        for (uint32_t j=0; j<MAX_TYPE; ++j)
          {
            // just read !!!
            try
              {
                getParam("nb_operation","functionnal_unit",toString(i).c_str(),"type",toString(j).c_str(), "");
              }
            catch (morpheo::ErrorMorpheo & error)
              {
              }
            
            
            for (uint32_t k=0; k<MAX_OPERATION; ++k)
              {
                if (is_type_valid(j) and (j != TYPE_MEMORY))// A functional unit can't execute memory instruction
                  {
                    _param->_timing [i][j][k]._latence = fromString<uint32_t> (getParam("latence",
                                                                                        "functionnal_unit",toString(i).c_str(),
                                                                                        "type"            ,toString(j).c_str(),
                                                                                        "operation"       ,toString(k).c_str(),
                                                                                        ""));
                    _param->_timing [i][j][k]._delay   = fromString<uint32_t> (getParam("delay",
                                                                                        "functionnal_unit",toString(i).c_str(),
                                                                                        "type"            ,toString(j).c_str(),
                                                                                        "operation"       ,toString(k).c_str(),
                                                                                        ""));
                  }
                else
                  {
                    _param->_timing [i][j][k]._latence = 0;
                    _param->_timing [i][j][k]._delay   = 0;
                  }
              }
          }
      }

    //-----------------------------------------------------
    // icache_port
    //-----------------------------------------------------

  //log_printf(INFO,Configuration,FUNCTION,_("ICACHE_PORT"));

    _param->_nb_icache_port             = fromString<uint32_t           >(getParam("nb_icache_port"            , ""));
    _param->_icache_port_priority       = fromString<Tpriority_t        >(getParam("icache_port_priority"      , ""));
    _param->_icache_port_load_balancing = fromString<Tload_balancing_t  >(getParam("icache_port_load_balancing", ""));

    //-----------------------------------------------------
    // dcache_port
    //-----------------------------------------------------
  //log_printf(INFO,Configuration,FUNCTION,_("DCACHE_PORT"));

    _param->_nb_dcache_port               = fromString<uint32_t         >(getParam("nb_dcache_port"            , ""));
    _param->_dcache_port_priority       = fromString<Tpriority_t        >(getParam("dcache_port_priority"      , ""));
    _param->_dcache_port_load_balancing = fromString<Tload_balancing_t  >(getParam("dcache_port_load_balancing", ""));


    //-----------------------------------------------------
    // front_end
    //-----------------------------------------------------
    ALLOC1(_param->_nb_context                    ,uint32_t    ,_param->_nb_front_end);
    ALLOC1(_param->_nb_decod_unit                 ,uint32_t    ,_param->_nb_front_end);
    ALLOC1(_param->_nb_inst_branch_predict        ,uint32_t    ,_param->_nb_front_end);
    ALLOC1(_param->_nb_inst_branch_decod          ,uint32_t    ,_param->_nb_front_end);
    ALLOC1(_param->_nb_inst_branch_update         ,uint32_t    ,_param->_nb_front_end);
    ALLOC1(_param->_btb_size_queue                ,uint32_t    ,_param->_nb_front_end);
    ALLOC1(_param->_btb_associativity             ,uint32_t    ,_param->_nb_front_end);
    ALLOC1(_param->_btb_size_counter              ,uint32_t    ,_param->_nb_front_end);
    ALLOC1(_param->_btb_victim_scheme             ,Tvictim_t   ,_param->_nb_front_end);
    ALLOC1(_param->_dir_predictor_scheme          ,Tpredictor_t,_param->_nb_front_end);
    ALLOC2(_param->_dir_have_bht                  ,bool        ,_param->_nb_front_end,3);
    ALLOC2(_param->_dir_bht_size_shifter          ,uint32_t    ,_param->_nb_front_end,3);
    ALLOC2(_param->_dir_bht_nb_shifter            ,uint32_t    ,_param->_nb_front_end,3);
    ALLOC2(_param->_dir_have_pht                  ,bool        ,_param->_nb_front_end,3);
    ALLOC2(_param->_dir_pht_size_counter          ,uint32_t    ,_param->_nb_front_end,3);
    ALLOC2(_param->_dir_pht_nb_counter            ,uint32_t    ,_param->_nb_front_end,3);
    ALLOC2(_param->_dir_pht_size_address_share    ,uint32_t    ,_param->_nb_front_end,3);

    for (uint32_t i=0; i<_param->_nb_front_end; ++i)
      {
      //log_printf(INFO,Configuration,FUNCTION,_("FRONT_END [%d]"),i);

        _param->_nb_context                    [i] = fromString<uint32_t    >(getParam("nb_context"                ,"front_end",toString(i).c_str(), ""));
        _param->_nb_decod_unit                 [i] = fromString<uint32_t    >(getParam("nb_decod_unit"             ,"front_end",toString(i).c_str(), ""));
        _param->_nb_inst_branch_predict        [i] = fromString<uint32_t    >(getParam("nb_inst_branch_predict"    ,"front_end",toString(i).c_str(), ""));
        _param->_nb_inst_branch_decod          [i] = fromString<uint32_t    >(getParam("nb_inst_branch_decod"      ,"front_end",toString(i).c_str(), ""));
        _param->_nb_inst_branch_update         [i] = fromString<uint32_t    >(getParam("nb_inst_branch_update"     ,"front_end",toString(i).c_str(), ""));
        _param->_btb_size_queue                [i] = fromString<uint32_t    >(getParam("btb_size_queue"            ,"front_end",toString(i).c_str(), ""));
        _param->_btb_associativity             [i] = fromString<uint32_t    >(getParam("btb_associativity"         ,"front_end",toString(i).c_str(), ""));
        _param->_btb_size_counter              [i] = fromString<uint32_t    >(getParam("btb_size_counter"          ,"front_end",toString(i).c_str(), ""));
        _param->_btb_victim_scheme             [i] = fromString<Tvictim_t   >(getParam("btb_victim_scheme"         ,"front_end",toString(i).c_str(), ""));
        _param->_dir_predictor_scheme          [i] = fromString<Tpredictor_t>(getParam("dir_predictor_scheme"      ,"front_end",toString(i).c_str(), ""));

        // just read !!!
        try
          {
            getParam("nb_predictor","front_end",toString(i).c_str(), "");
          }
        catch (morpheo::ErrorMorpheo & error)
          {
          }

        const uint32_t max_nb_predictor=3;
        for (uint32_t j=0; j<max_nb_predictor; ++j)
          {
          //log_printf(INFO,Configuration,FUNCTION,_("PREDICTOR [%d][%d]"),i,j);

        _param->_dir_have_bht               [i][j] = fromString<bool        >(getParam("dir_have_bht"              ,"front_end",toString(i).c_str(),"predictor",toString(j).c_str(), ""));
        _param->_dir_bht_size_shifter       [i][j] = fromString<uint32_t    >(getParam("dir_bht_size_shifter"      ,"front_end",toString(i).c_str(),"predictor",toString(j).c_str(), ""));
        _param->_dir_bht_nb_shifter         [i][j] = fromString<uint32_t    >(getParam("dir_bht_nb_shifter"        ,"front_end",toString(i).c_str(),"predictor",toString(j).c_str(), ""));
        _param->_dir_have_pht               [i][j] = fromString<bool        >(getParam("dir_have_pht"              ,"front_end",toString(i).c_str(),"predictor",toString(j).c_str(), ""));
        _param->_dir_pht_size_counter       [i][j] = fromString<uint32_t    >(getParam("dir_pht_size_counter"      ,"front_end",toString(i).c_str(),"predictor",toString(j).c_str(), ""));
        _param->_dir_pht_nb_counter         [i][j] = fromString<uint32_t    >(getParam("dir_pht_nb_counter"        ,"front_end",toString(i).c_str(),"predictor",toString(j).c_str(), ""));
        _param->_dir_pht_size_address_share [i][j] = fromString<uint32_t    >(getParam("dir_pht_size_address_share","front_end",toString(i).c_str(),"predictor",toString(j).c_str(), ""));
          }
      }   

    //-----------------------------------------------------
    // ooo_engine
    //-----------------------------------------------------

    ALLOC1(_param->_nb_rename_unit          ,uint32_t         ,_param->_nb_ooo_engine);
    ALLOC1(_param->_nb_inst_issue           ,uint32_t         ,_param->_nb_ooo_engine);
    ALLOC1(_param->_nb_inst_reexecute       ,uint32_t         ,_param->_nb_ooo_engine);
    ALLOC1(_param->_nb_inst_commit          ,uint32_t         ,_param->_nb_ooo_engine);
    ALLOC1(_param->_nb_inst_branch_complete ,uint32_t         ,_param->_nb_ooo_engine);
    ALLOC1(_param->_nb_rename_unit_select   ,uint32_t         ,_param->_nb_ooo_engine);
    ALLOC1(_param->_nb_execute_loop_select  ,uint32_t         ,_param->_nb_ooo_engine);
    ALLOC1(_param->_size_re_order_buffer    ,uint32_t         ,_param->_nb_ooo_engine);
    ALLOC1(_param->_nb_re_order_buffer_bank ,uint32_t         ,_param->_nb_ooo_engine);
    ALLOC1(_param->_retire_ooo_scheme       ,morpheo::behavioural::core::multi_ooo_engine::ooo_engine::commit_unit::Tretire_ooo_scheme_t
                                                              ,_param->_nb_ooo_engine);
    ALLOC1(_param->_commit_priority         ,Tpriority_t      ,_param->_nb_ooo_engine);
    ALLOC1(_param->_commit_load_balancing   ,Tload_balancing_t,_param->_nb_ooo_engine);
    ALLOC1(_param->_size_issue_queue        ,uint32_t         ,_param->_nb_ooo_engine);
    ALLOC1(_param->_issue_queue_scheme      ,morpheo::behavioural::core::multi_ooo_engine::ooo_engine::issue_queue::Tissue_queue_scheme_t
                                                              ,_param->_nb_ooo_engine);
    ALLOC1(_param->_nb_issue_queue_bank     ,uint32_t         ,_param->_nb_ooo_engine);
    ALLOC1(_param->_issue_priority          ,Tpriority_t      ,_param->_nb_ooo_engine);
    ALLOC1(_param->_issue_load_balancing    ,Tload_balancing_t,_param->_nb_ooo_engine);
    ALLOC1(_param->_size_reexecute_queue    ,uint32_t         ,_param->_nb_ooo_engine);

    for (uint32_t i=0; i<_param->_nb_ooo_engine; ++i)
      {
      //log_printf(INFO,Configuration,FUNCTION,_("OOO_ENGINE [%d]"),i);

        _param->_nb_rename_unit          [i] = fromString<uint32_t         >(getParam("nb_rename_unit"          ,"ooo_engine",toString(i).c_str(), ""));
        _param->_nb_inst_issue           [i] = fromString<uint32_t         >(getParam("nb_inst_issue"           ,"ooo_engine",toString(i).c_str(), ""));
        _param->_nb_inst_reexecute       [i] = fromString<uint32_t         >(getParam("nb_inst_reexecute"       ,"ooo_engine",toString(i).c_str(), ""));
        _param->_nb_inst_commit          [i] = fromString<uint32_t         >(getParam("nb_inst_commit"          ,"ooo_engine",toString(i).c_str(), ""));
        _param->_nb_inst_branch_complete [i] = fromString<uint32_t         >(getParam("nb_inst_branch_complete" ,"ooo_engine",toString(i).c_str(), ""));
        _param->_nb_rename_unit_select   [i] = fromString<uint32_t         >(getParam("nb_rename_unit_select"   ,"ooo_engine",toString(i).c_str(), ""));
        _param->_nb_execute_loop_select  [i] = fromString<uint32_t         >(getParam("nb_execute_loop_select"  ,"ooo_engine",toString(i).c_str(), ""));
        _param->_size_re_order_buffer    [i] = fromString<uint32_t         >(getParam("size_re_order_buffer"    ,"ooo_engine",toString(i).c_str(), ""));
        _param->_nb_re_order_buffer_bank [i] = fromString<uint32_t         >(getParam("nb_re_order_buffer_bank" ,"ooo_engine",toString(i).c_str(), ""));
        _param->_retire_ooo_scheme       [i] = fromString<morpheo::behavioural::core::multi_ooo_engine::ooo_engine::commit_unit::Tretire_ooo_scheme_t>
                                                                            (getParam("retire_ooo_scheme"       ,"ooo_engine",toString(i).c_str(), ""));
        _param->_commit_priority         [i] = fromString<Tpriority_t      >(getParam("commit_priority"         ,"ooo_engine",toString(i).c_str(), ""));
        _param->_commit_load_balancing   [i] = fromString<Tload_balancing_t>(getParam("commit_load_balancing"   ,"ooo_engine",toString(i).c_str(), ""));
        _param->_size_issue_queue        [i] = fromString<uint32_t         >(getParam("size_issue_queue"        ,"ooo_engine",toString(i).c_str(), ""));
        _param->_issue_queue_scheme      [i] = fromString<morpheo::behavioural::core::multi_ooo_engine::ooo_engine::issue_queue::Tissue_queue_scheme_t>
                                                                            (getParam("issue_queue_scheme"      ,"ooo_engine",toString(i).c_str(), ""));
        _param->_nb_issue_queue_bank     [i] = fromString<uint32_t         >(getParam("nb_issue_queue_bank"     ,"ooo_engine",toString(i).c_str(), ""));
        _param->_issue_priority          [i] = fromString<Tpriority_t      >(getParam("issue_priority"          ,"ooo_engine",toString(i).c_str(), ""));
        _param->_issue_load_balancing    [i] = fromString<Tload_balancing_t>(getParam("issue_load_balancing"    ,"ooo_engine",toString(i).c_str(), ""));
        _param->_size_reexecute_queue    [i] = fromString<uint32_t         >(getParam("size_reexecute_queue"    ,"ooo_engine",toString(i).c_str(), ""));
      }   

    //-----------------------------------------------------
    // execute_loop
    //-----------------------------------------------------
    
    ALLOC1(_param->_nb_read_unit                         ,uint32_t   ,_param->_nb_execute_loop);
    ALLOC1(_param->_nb_execute_unit                      ,uint32_t   ,_param->_nb_execute_loop);
    ALLOC1(_param->_nb_write_unit                        ,uint32_t   ,_param->_nb_execute_loop);
    ALLOC1(_param->_nb_gpr_bank                          ,uint32_t   ,_param->_nb_execute_loop);
    ALLOC1(_param->_nb_gpr_port_read_by_bank             ,uint32_t   ,_param->_nb_execute_loop);
    ALLOC1(_param->_nb_gpr_port_write_by_bank            ,uint32_t   ,_param->_nb_execute_loop);
    ALLOC1(_param->_nb_spr_bank                          ,uint32_t   ,_param->_nb_execute_loop);
    ALLOC1(_param->_nb_spr_port_read_by_bank             ,uint32_t   ,_param->_nb_execute_loop);
    ALLOC1(_param->_nb_spr_port_write_by_bank            ,uint32_t   ,_param->_nb_execute_loop);
    ALLOC1(_param->_execution_unit_to_write_unit_priority,Tpriority_t,_param->_nb_execute_loop);
    ALLOC1(_param->_read_unit_to_execution_unit_priority ,Tpriority_t,_param->_nb_execute_loop);

    for (uint32_t i=0; i<_param->_nb_execute_loop; ++i)
      {
      //log_printf(INFO,Configuration,FUNCTION,_("EXECUTE_LOOP [%d]"),i);

        _param->_nb_read_unit                         [i] = fromString<uint32_t   >(getParam("nb_read_unit"                         ,"execute_loop",toString(i).c_str(), ""));
        _param->_nb_execute_unit                      [i] = fromString<uint32_t   >(getParam("nb_execute_unit"                      ,"execute_loop",toString(i).c_str(), ""));
        _param->_nb_write_unit                        [i] = fromString<uint32_t   >(getParam("nb_write_unit"                        ,"execute_loop",toString(i).c_str(), ""));
        _param->_nb_gpr_bank                          [i] = fromString<uint32_t   >(getParam("nb_gpr_bank"                          ,"execute_loop",toString(i).c_str(), ""));
        _param->_nb_gpr_port_read_by_bank             [i] = fromString<uint32_t   >(getParam("nb_gpr_port_read_by_bank"             ,"execute_loop",toString(i).c_str(), ""));
        _param->_nb_gpr_port_write_by_bank            [i] = fromString<uint32_t   >(getParam("nb_gpr_port_write_by_bank"            ,"execute_loop",toString(i).c_str(), ""));
        _param->_nb_spr_bank                          [i] = fromString<uint32_t   >(getParam("nb_spr_bank"                          ,"execute_loop",toString(i).c_str(), ""));
        _param->_nb_spr_port_read_by_bank             [i] = fromString<uint32_t   >(getParam("nb_spr_port_read_by_bank"             ,"execute_loop",toString(i).c_str(), ""));
        _param->_nb_spr_port_write_by_bank            [i] = fromString<uint32_t   >(getParam("nb_spr_port_write_by_bank"            ,"execute_loop",toString(i).c_str(), ""));
        _param->_execution_unit_to_write_unit_priority[i] = fromString<Tpriority_t>(getParam("execution_unit_to_write_unit_priority","execute_loop",toString(i).c_str(), ""));
        _param->_read_unit_to_execution_unit_priority [i] = fromString<Tpriority_t>(getParam("read_unit_to_execution_unit_priority" ,"execute_loop",toString(i).c_str(), ""));
      }   

    //-----------------------------------------------------
    // Link
    //-----------------------------------------------------

  //log_printf(INFO,Configuration,FUNCTION,_("LINK"));

    _param->_dispatch_priority       = fromString<Tpriority_t      >(getParam("dispatch_priority"      , ""));
    _param->_dispatch_load_balancing = fromString<Tload_balancing_t>(getParam("dispatch_load_balancing", ""));

    ALLOC1(_param->_link_context_with_thread               ,pair_dual,_param->_nb_thread);
    ALLOC1(_param->_link_decod_unit_with_decod_bloc        ,pair_dual,_param->_nb_decod_bloc);
    ALLOC1(_param->_link_rename_unit_with_rename_bloc      ,pair_dual,_param->_nb_rename_bloc);
    ALLOC1(_param->_link_read_unit_with_read_bloc          ,pair_dual,_param->_nb_read_bloc);
    ALLOC1(_param->_link_write_unit_with_write_bloc        ,pair_dual,_param->_nb_write_bloc);
    ALLOC1(_param->_link_execute_unit_with_functionnal_unit,pair_dual,_param->_nb_functionnal_unit);
    ALLOC1(_param->_link_execute_unit_with_load_store_unit ,pair_dual,_param->_nb_load_store_unit);
    ALLOC1(_param->_link_decod_bloc_with_thread            ,uint32_t ,_param->_nb_thread);
    ALLOC1(_param->_link_rename_bloc_with_front_end        ,uint32_t ,_param->_nb_front_end);
//  ALLOC3(_param->_table_dispatch                         ,bool     ,_param->_nb_ooo_engine,_param->_nb_issue_queue_bank[it1],_param->_nb_read_bloc);
    ALLOC1(_param->_link_read_bloc_with_load_store_unit    ,uint32_t ,_param->_nb_load_store_unit);
    ALLOC2(_param->_link_read_bloc_and_functionnal_unit    ,bool     ,_param->_nb_read_bloc,_param->_nb_functionnal_unit);
    ALLOC1(_param->_link_write_bloc_with_load_store_unit   ,uint32_t ,_param->_nb_load_store_unit);
    ALLOC2(_param->_link_write_bloc_and_functionnal_unit   ,bool     ,_param->_nb_write_bloc,_param->_nb_functionnal_unit);
    ALLOC1(_param->_link_load_store_unit_with_thread       ,uint32_t ,_param->_nb_thread);
    ALLOC2(_param->_link_thread_and_functionnal_unit       ,bool     ,_param->_nb_thread,_param->_nb_functionnal_unit);
    ALLOC1(_param->_link_icache_port_with_thread           ,uint32_t ,_param->_nb_thread);
    ALLOC2(_param->_link_dcache_port_with_load_store_unit  ,uint32_t ,_param->_nb_load_store_unit,_param->_nb_cache_port[it1]);

    std::vector<std::string> dest;

#define getLink_n(x,nb_dest,src...) {dest = getLink(x, src); test(x,dest,nb_dest);}
#define getLink_2(x,src...) {getLink_n(x,2,src);}
#define getLink_1(x,src...) {getLink_n(x,1,src);}

    for (uint32_t i=0; i<_param->_nb_thread; ++i)
      {
        getLink_2("link_context_with_thread",toString(i).c_str(), "");
        _param->_link_context_with_thread [i] = pair_dual(fromString<uint32_t>(dest[0]),
                                                          fromString<uint32_t>(dest[1]));
        
        getLink_1("link_decod_bloc_with_thread",toString(i).c_str(), "");
        _param->_link_decod_bloc_with_thread [i] = fromString<uint32_t>(dest[0]);
        
        getLink_1("link_load_store_unit_with_thread",toString(i).c_str(), "");
        _param->_link_load_store_unit_with_thread [i] = fromString<uint32_t>(dest[0]);

        getLink_1("link_icache_port_with_thread",toString(i).c_str(), "");
        _param->_link_icache_port_with_thread [i] = fromString<uint32_t>(dest[0]);

        for (uint32_t j=0; j<_param->_nb_functionnal_unit; ++j)
          {
            getLink_1("link_thread_and_functionnal_unit",toString(i).c_str(),toString(j).c_str(), "");
            _param->_link_thread_and_functionnal_unit [i][j] = fromString<bool>(dest[0]);
          }
      }
    
    for (uint32_t i=0; i<_param->_nb_decod_bloc; ++i)
      {
        getLink_2("link_decod_unit_with_decod_bloc",toString(i).c_str(), "");
        _param->_link_decod_unit_with_decod_bloc [i] = pair_dual(fromString<uint32_t>(dest[0]),
                                                                fromString<uint32_t>(dest[1]));
      }

    for (uint32_t i=0; i<_param->_nb_rename_bloc; ++i)
      {
        getLink_2("link_rename_unit_with_rename_bloc",toString(i).c_str(), "");
        _param->_link_rename_unit_with_rename_bloc [i] = pair_dual(fromString<uint32_t>(dest[0]),
                                                                  fromString<uint32_t>(dest[1]));
      }

    for (uint32_t i=0; i<_param->_nb_read_bloc; ++i)
      {
        getLink_2("link_read_unit_with_read_bloc",toString(i).c_str(), "");
        _param->_link_read_unit_with_read_bloc [i] = pair_dual(fromString<uint32_t>(dest[0]),
                                                              fromString<uint32_t>(dest[1]));

        for (uint32_t j=0; j<_param->_nb_functionnal_unit; ++j)
          {
            getLink_1("link_read_bloc_and_functionnal_unit",toString(i).c_str(),toString(j).c_str(), "");
            _param->_link_read_bloc_and_functionnal_unit [i][j] = fromString<bool>(dest[0]);
          }
      }

    for (uint32_t i=0; i<_param->_nb_load_store_unit; ++i)
      {
        getLink_1("link_read_bloc_with_load_store_unit",toString(i).c_str(), "");
        _param->_link_read_bloc_with_load_store_unit [i] = fromString<uint32_t>(dest[0]);

        getLink_1("link_write_bloc_with_load_store_unit",toString(i).c_str(), "");
        _param->_link_write_bloc_with_load_store_unit [i] = fromString<uint32_t>(dest[0]);
      }

    for (uint32_t i=0; i<_param->_nb_write_bloc; ++i)
      {
        getLink_2("link_write_unit_with_write_bloc",toString(i).c_str(), "");
        _param->_link_write_unit_with_write_bloc [i] = pair_dual(fromString<uint32_t>(dest[0]),
                                                                fromString<uint32_t>(dest[1]));

        for (uint32_t j=0; j<_param->_nb_functionnal_unit; ++j)
          {
            getLink_1("link_write_bloc_and_functionnal_unit",toString(i).c_str(),toString(j).c_str(), "");
            _param->_link_write_bloc_and_functionnal_unit [i][j] = fromString<bool>(dest[0]);
          }
      }

    for (uint32_t i=0; i<_param->_nb_functionnal_unit; ++i)
      {
        getLink_2("link_execute_unit_with_functionnal_unit",toString(i).c_str(), "");
        _param->_link_execute_unit_with_functionnal_unit [i] = pair_dual(fromString<uint32_t>(dest[0]),
                                                                         fromString<uint32_t>(dest[1]));
      }

    for (uint32_t i=0; i<_param->_nb_load_store_unit; ++i)
      {
        getLink_2("link_execute_unit_with_load_store_unit",toString(i).c_str(), "");
        _param->_link_execute_unit_with_load_store_unit [i] = pair_dual(fromString<uint32_t>(dest[0]),
                                                                        fromString<uint32_t>(dest[1]));

        for (uint32_t j=0; j<_param->_nb_cache_port[i]; ++j)
          {
            getLink_1("link_dcache_port_with_load_store_unit",toString(i).c_str(),toString(j).c_str(), "");
            _param->_link_dcache_port_with_load_store_unit [i][j] = fromString<uint32_t>(dest[0]);
          }
      }

    for (uint32_t i=0; i<_param->_nb_front_end; ++i)
      {
        getLink_1("link_rename_bloc_with_front_end",toString(i).c_str(), "");
        _param->_link_rename_bloc_with_front_end [i] = fromString<uint32_t>(dest[0]);
      }

    // for (uint32_t i=0; i<_param->_nb_ooo_engine; ++i)
    //   for (uint32_t j=0; j<_param->_nb_issue_queue_bank[i]; ++j)
    //     for (uint32_t k=0; k<_param->_nb_read_bloc; ++k)
    //       {
    //         getLink_1("table_dispatch",toString(i).c_str(),toString(j).c_str(),toString(k).c_str(),"");
    //         _param->_table_dispatch [i][j][k] = fromString<bool>(dest[0]);
    //       }

    test_use ();
  };

}; // end namespace configuration
}; // end namespace behavioural
}; // end namespace morpheo              
