#ifdef VHDL
/*
 * $Id: Functionnal_unit_vhdl.cpp 116 2009-04-30 13:51:41Z moulu $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Execute_unit/Execute_unit/Functionnal_unit/include/Functionnal_unit.h"
#include "Behavioural/include/Vhdl.h"
#include "Behavioural/Generic/Shifter/include/Shifter.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_execute_unit {
namespace execute_unit {
namespace functionnal_unit {


#undef  FUNCTION
#define FUNCTION "Functionnal_unit::vhdl"
  void Functionnal_unit::vhdl (void)
  {
    log_printf(FUNC,Functionnal_unit,FUNCTION,"Begin");

    morpheo::behavioural::generic::shifter::Parameters * param_shifter;
    
    param_shifter = new morpheo::behavioural::generic::shifter::Parameters
      (
       _param->_size_general_data,     // size_data
       1,                     // nb_port
       0,                     // shift_value
       generic::shifter::external_rotate,       // rotate
       generic::shifter::external_direction,    // direction
       generic::shifter::external_carry,         // carry
       false                 // type_completion_bool
       );
 
    morpheo::behavioural::generic::shifter::Shifter      * shifter;

    std::string shifter_name = _name + "_shifter";
    shifter = new morpheo::behavioural::generic::shifter::Shifter
      (shifter_name.c_str()
#ifdef STATISTICS
       ,NULL
#endif
       ,param_shifter
       ,USE_VHDL);
    
    _component->set_component(shifter->_component
#ifdef POSITION
                              , 50, 50, 50, 50
#endif
                              , INSTANCE_LIBRARY
                              );

    Vhdl * vhdl = new Vhdl (_name);

    _interfaces->set_port(vhdl);
    _component->vhdl_instance(vhdl);

    vhdl_declaration (vhdl);
    vhdl_body        (vhdl);

    vhdl->generate_file();

    delete vhdl;

    log_printf(FUNC,Functionnal_unit,FUNCTION,"End");
  };

}; // end namespace functionnal_unit
}; // end namespace execute_unit
}; // end namespace multi_execute_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
