#ifndef morpheo_behavioural_core_multi_execute_loop_execute_loop_register_unit_Register_unit_h
#define morpheo_behavioural_core_multi_execute_loop_execute_loop_register_unit_Register_unit_h

/*
 * $Id: Register_unit.h 136 2009-10-20 18:52:15Z rosiere $
 *
 * [ Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#include <iostream>
#include "Common/include/ToString.h"
#include "Common/include/Debug.h"
#include "Behavioural/include/Types.h"

// Internal Component 
#include "Behavioural/Generic/RegisterFile/include/RegisterFile.h"
#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Register_unit/Register_unit_Glue/include/Register_unit_Glue.h"

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Register_unit/include/Parameters.h"
#ifdef STATISTICS
#include "Behavioural/include/Stat.h"
#endif
#include "Behavioural/include/Component.h"
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#include "Behavioural/include/Usage.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace register_unit {


  class Register_unit 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[ fields ]----------------------------------------------------
    // Parameters
  protected : const std::string       _name;
  protected : const Parameters * _param;
  private   : const Tusage_t     _usage;

#ifdef STATISTICS
  public    : Stat                           * _stat;
#endif

  public    : Component                      * _component;
  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[ Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // Interface
  public    : SC_CLOCK                      *  in_CLOCK        ;
  public    : SC_IN (Tcontrol_t)            *  in_NRESET       ;

    // ~~~~~[ Interface "gpr_read" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t        )   **  in_GPR_READ_VAL                 ;
  public    : SC_OUT(Tcontrol_t        )   ** out_GPR_READ_ACK                 ;
  public    : SC_IN (Tcontext_t        )   **  in_GPR_READ_OOO_ENGINE_ID       ;
  public    : SC_IN (Tgeneral_address_t)   **  in_GPR_READ_NUM_REG             ;
  public    : SC_OUT(Tgeneral_data_t   )   ** out_GPR_READ_DATA                ;
  public    : SC_OUT(Tcontrol_t        )   ** out_GPR_READ_DATA_VAL            ;

    // ~~~~~[ Interface "gpr_write" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t        )   **  in_GPR_WRITE_VAL                ;
  public    : SC_OUT(Tcontrol_t        )   ** out_GPR_WRITE_ACK                ;
  public    : SC_IN (Tcontext_t        )   **  in_GPR_WRITE_OOO_ENGINE_ID      ;
  public    : SC_IN (Tgeneral_address_t)   **  in_GPR_WRITE_NUM_REG            ;
  public    : SC_IN (Tgeneral_data_t   )   **  in_GPR_WRITE_DATA               ;

    // ~~~~~[ Interface "spr_read" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t        )   **  in_SPR_READ_VAL                 ;
  public    : SC_OUT(Tcontrol_t        )   ** out_SPR_READ_ACK                 ;
  public    : SC_IN (Tcontext_t        )   **  in_SPR_READ_OOO_ENGINE_ID       ;
  public    : SC_IN (Tspecial_address_t)   **  in_SPR_READ_NUM_REG             ;
  public    : SC_OUT(Tspecial_data_t   )   ** out_SPR_READ_DATA                ;
  public    : SC_OUT(Tcontrol_t        )   ** out_SPR_READ_DATA_VAL            ;

    // ~~~~~[ Interface "spr_write" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t        )   **  in_SPR_WRITE_VAL                ;
  public    : SC_OUT(Tcontrol_t        )   ** out_SPR_WRITE_ACK                ;
  public    : SC_IN (Tcontext_t        )   **  in_SPR_WRITE_OOO_ENGINE_ID      ;
  public    : SC_IN (Tspecial_address_t)   **  in_SPR_WRITE_NUM_REG            ;
  public    : SC_IN (Tspecial_data_t   )   **  in_SPR_WRITE_DATA               ;

    // ~~~~~[ Interface "issue" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t        )   **  in_ISSUE_VAL                    ;
  public    : SC_OUT(Tcontrol_t        )   ** out_ISSUE_ACK                    ;
  public    : SC_IN (Tcontext_t        )   **  in_ISSUE_OOO_ENGINE_ID          ;
  public    : SC_IN (Tcontrol_t        )   **  in_ISSUE_RD_USE                 ;
  public    : SC_IN (Tgeneral_address_t)   **  in_ISSUE_RD_NUM_REG             ; // use=1 : status[num_reg]<- 0
  public    : SC_IN (Tcontrol_t        )   **  in_ISSUE_RE_USE                 ;
  public    : SC_IN (Tspecial_address_t)   **  in_ISSUE_RE_NUM_REG             ;
    
//     // ~~~~~[ Interface "insert_rob" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//   public    : SC_IN (Tcontrol_t        )  ***  in_INSERT_ROB_VAL               ;
//   public    : SC_OUT(Tcontrol_t        )  *** out_INSERT_ROB_ACK               ;
//   public    : SC_IN (Tcontrol_t        )  ***  in_INSERT_ROB_RD_USE            ;
//   public    : SC_IN (Tgeneral_address_t)  ***  in_INSERT_ROB_RD_NUM_REG        ; // use=1 : status[num_reg]<- 0
//   public    : SC_IN (Tcontrol_t        )  ***  in_INSERT_ROB_RE_USE            ;
//   public    : SC_IN (Tspecial_address_t)  ***  in_INSERT_ROB_RE_NUM_REG        ;

//     // ~~~~~[ Interface "retire_rob" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//   public    : SC_IN (Tcontrol_t        )  ***  in_RETIRE_ROB_VAL               ;
//   public    : SC_OUT(Tcontrol_t        )  *** out_RETIRE_ROB_ACK               ;
//   public    : SC_IN (Tcontrol_t        )  ***  in_RETIRE_ROB_RD_OLD_USE        ; 
//   public    : SC_IN (Tgeneral_address_t)  ***  in_RETIRE_ROB_RD_OLD_NUM_REG    ; // old_use=1 : status[old_num_reg]<- 0
//   public    : SC_IN (Tcontrol_t        )  ***  in_RETIRE_ROB_RD_NEW_USE        ;
//   public    : SC_IN (Tgeneral_address_t)  ***  in_RETIRE_ROB_RD_NEW_NUM_REG    ; // new_use=1 : status[new_num_reg]<- 1
//   public    : SC_IN (Tcontrol_t        )  ***  in_RETIRE_ROB_RE_OLD_USE        ; 
//   public    : SC_IN (Tspecial_address_t)  ***  in_RETIRE_ROB_RE_OLD_NUM_REG    ;
//   public    : SC_IN (Tcontrol_t        )  ***  in_RETIRE_ROB_RE_NEW_USE        ;
//   public    : SC_IN (Tspecial_address_t)  ***  in_RETIRE_ROB_RE_NEW_NUM_REG    ;

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
  protected : morpheo::behavioural::generic::registerfile::RegisterFile::RegisterFile ** component_gpr       ;
  protected : morpheo::behavioural::generic::registerfile::RegisterFile::RegisterFile ** component_gpr_status;
  protected : morpheo::behavioural::generic::registerfile::RegisterFile::RegisterFile ** component_spr       ;
  protected : morpheo::behavioural::generic::registerfile::RegisterFile::RegisterFile ** component_spr_status;

//   protected : morpheo::behavioural::generic::registerfile::registerfile_multi_banked::RegisterFile_Multi_Banked::RegisterFile_Multi_Banked ** component_gpr       ;
//   protected : morpheo::behavioural::generic::registerfile::registerfile_monolithic  ::RegisterFile_Monolithic  ::RegisterFile_Monolithic   ** component_gpr_status;
//   protected : morpheo::behavioural::generic::registerfile::registerfile_multi_banked::RegisterFile_Multi_Banked::RegisterFile_Multi_Banked ** component_spr       ;
//   protected : morpheo::behavioural::generic::registerfile::registerfile_monolithic  ::RegisterFile_Monolithic  ::RegisterFile_Monolithic   ** component_spr_status;

  protected : morpheo::behavioural::core::multi_execute_loop::execute_loop::register_unit::register_unit_glue::Register_unit_Glue::Register_unit_Glue      * component_glue      ;

    // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#endif

    // -----[ methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (Register_unit);
#endif
  public  :          Register_unit              
  (
#ifdef SYSTEMC
   sc_module_name                                name,
#else					       
   std::string                                        name,
#endif					       
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   Parameters                                  * param,
   morpheo::behavioural::Tusage_t                usage
   );
  public  :          ~Register_unit             (void);
					       
  private : void     allocation                (
#ifdef STATISTICS
						morpheo::behavioural::Parameters_Statistics * param_statistics
#else
						void
#endif
						);
  private : void     deallocation              (void);
					       
#ifdef SYSTEMC				       
//#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  public  : void     transition                (void);
//#endif
#endif					       
					       
#if VHDL				       
  public  : void     vhdl                      (void);
  private : void     vhdl_declaration          (Vhdl * & vhdl);
  private : void     vhdl_body                 (Vhdl * & vhdl);
#endif					       
					       
#ifdef STATISTICS
  public  : void        statistics_declaration    (morpheo::behavioural::Parameters_Statistics * param_statistics);
#endif
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  private : void        end_cycle                 (void);
#endif
  };


}; // end namespace register_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
