#ifdef SYSTEMC
/*
 * $Id: Context_State_genMealy_decod_event.cpp 123 2009-06-08 20:43:30Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Context_State/include/Context_State.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace context_state {


#undef  FUNCTION
#define FUNCTION "Context_State::genMealy_decod_event"
  void Context_State::genMealy_decod_event (void)
  {
    log_begin(Context_State,FUNCTION);
    log_function(Context_State,FUNCTION,_name.c_str());

    if (PORT_READ(in_NRESET))
      {
    for (uint32_t i=0; i<_param->_nb_decod_unit; i++)
      {
        Tcontrol_t ack = 1;
        if (PORT_READ(in_DECOD_EVENT_VAL [i]))
          {
            Tcontext_t    context_id = (_param->_have_port_context_id)?PORT_READ(in_DECOD_EVENT_CONTEXT_ID [i]):0;
            Tevent_type_t event_type = PORT_READ(in_DECOD_EVENT_TYPE [i]);
            Tcounter_t    inst_all   = PORT_READ(in_NB_INST_COMMIT_ALL[context_id]) + PORT_READ(in_NB_INST_DECOD_ALL [context_id]);
            Tcounter_t    inst_mem   = PORT_READ(in_NB_INST_COMMIT_MEM[context_id]) + PORT_READ(in_NB_INST_DECOD_ALL [context_id]);

            switch (event_type)
              {
              case EVENT_TYPE_SPR_ACCESS         : ack = (inst_all == 0); break;
              case EVENT_TYPE_MSYNC              : ack = (inst_mem == 0); break;
              case EVENT_TYPE_PSYNC              : ack = (inst_all == 0); break;
              case EVENT_TYPE_CSYNC              : ack = (inst_all == 0); break;
//            case EVENT_TYPE_NONE               :
//            case EVENT_TYPE_MISS_SPECULATION   :
//            case EVENT_TYPE_EXCEPTION          :
//            case EVENT_TYPE_BRANCH_NO_ACCURATE :
              default : break; // ack == 1
              }
          }

        internal_DECOD_EVENT_ACK [i] = ack;
      }
      }
    else
      {
        for (uint32_t i=0; i<_param->_nb_decod_unit; i++)
          internal_DECOD_EVENT_ACK [i] = 0;
      }

    for (uint32_t i=0; i<_param->_nb_decod_unit; i++)
      PORT_WRITE(out_DECOD_EVENT_ACK [i], internal_DECOD_EVENT_ACK [i]);

    log_end(Context_State,FUNCTION);
  };

}; // end namespace context_state
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
