#ifdef SYSTEMC
/*
 * $Id: Ifetch_unit_Glue_genMealy_event.cpp 123 2009-06-08 20:43:30Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Ifetch_unit/Ifetch_unit_Glue/include/Ifetch_unit_Glue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace ifetch_unit {
namespace ifetch_unit_glue {


#undef  FUNCTION
#define FUNCTION "Ifetch_unit_Glue::genMealy_event"
  void Ifetch_unit_Glue::genMealy_event (void)
  {
    log_printf(FUNC,Ifetch_unit_Glue,FUNCTION,"Begin");

    if (PORT_READ(in_NRESET))
      {
    Tcontrol_t address_ack = PORT_READ(in_EVENT_ADDRESS_ACK);
    Tcontrol_t queue_ack   = PORT_READ(in_EVENT_QUEUE_ACK  );
    Tcontrol_t val         = PORT_READ(in_EVENT_VAL        );

    PORT_WRITE(out_EVENT_ACK        , address_ack and queue_ack);
    PORT_WRITE(out_EVENT_ADDRESS_VAL, val         and queue_ack);
    PORT_WRITE(out_EVENT_QUEUE_VAL  , address_ack and val);
      }
    else
      {
    PORT_WRITE(out_EVENT_ACK        , 0);
    PORT_WRITE(out_EVENT_ADDRESS_VAL, 0);
    PORT_WRITE(out_EVENT_QUEUE_VAL  , 0);
      }

    log_printf(FUNC,Ifetch_unit_Glue,FUNCTION,"End");
  };

}; // end namespace ifetch_unit_glue
}; // end namespace ifetch_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
