/*
 * $Id: OOO_Engine_Glue_allocation.cpp 137 2010-02-16 12:35:48Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/OOO_Engine_Glue/include/OOO_Engine_Glue.h"
#include "Behavioural/include/Allocation.h"
#include "Common/include/Max.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace ooo_engine_glue {



#undef  FUNCTION
#define FUNCTION "OOO_Engine_Glue::allocation"
  void OOO_Engine_Glue::allocation (
#ifdef STATISTICS
			       morpheo::behavioural::Parameters_Statistics * param_statistics
#else
			       void
#endif
			       )
  {
    log_begin(OOO_Engine_Glue,FUNCTION);

    _component   = new Component (_usage);

    Entity * entity = _component->set_entity (_name       
					      ,"OOO_Engine_Glue"
#ifdef POSITION
					      ,COMBINATORY 
#endif
					      );

    _interfaces = entity->set_interfaces();

    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      Interface * interface = _interfaces->set_interface(""
#ifdef POSITION
							 ,IN
							 ,SOUTH,
							 _("Generalist interface")
#endif
							 );
      
      in_CLOCK        = interface->set_signal_clk              ("clock" ,1, CLOCK_VHDL_YES);
      in_NRESET       = interface->set_signal_in  <Tcontrol_t> ("nreset",1, RESET_VHDL_YES);
    }

    // ~~~~~[ Interface : "rename" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC2_INTERFACE_BEGIN("rename",IN, SOUTH,_("rename's interface"),_param->_nb_front_end,_param->_nb_inst_decod[it1]);
      
      _ALLOC2_SIGNAL_IN ( in_RENAME_FRONT_END_ID                          ,"FRONT_END_ID"                          ,Tcontext_t         ,_param->_size_front_end_id    ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);
      _ALLOC2_SIGNAL_OUT(out_RENAME_RENAME_UNIT_FRONT_END_ID              ,"RENAME_UNIT_FRONT_END_ID"              ,Tcontext_t         ,_param->_size_front_end_id    ,_param->_nb_front_end,_param->_nb_inst_decod[it1]);

      ALLOC2_INTERFACE_END(_param->_nb_front_end,_param->_nb_inst_decod[it1]);
    }
    
    // ~~~~~[ Interface : "insert" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//     {
//       ALLOC1_INTERFACE_BEGIN("insert",OUT, WEST,_("insert's interface"),_param->_sum_inst_insert);

//       ALLOC1_SIGNAL_OUT (out_INSERT_VAL                                   ,"VAL"                                   ,Tcontrol_t         ,1                             );
//       ALLOC1_SIGNAL_IN  ( in_INSERT_ACK                                   ,"ACK"                                   ,Tcontrol_t         ,1                             );
//       ALLOC1_SIGNAL_OUT (out_INSERT_RD_USE                                ,"RD_USE"                                ,Tcontrol_t         ,1                             );
//       ALLOC1_SIGNAL_OUT (out_INSERT_RD_NUM_REG                            ,"RD_NUM_REG"                            ,Tgeneral_address_t ,_param->_size_general_register);
//       ALLOC1_SIGNAL_OUT (out_INSERT_RE_USE                                ,"RE_USE"                                ,Tcontrol_t         ,1                             );
//       ALLOC1_SIGNAL_OUT (out_INSERT_RE_NUM_REG                            ,"RE_NUM_REG"                            ,Tspecial_address_t ,_param->_size_special_register);

//       ALLOC1_INTERFACE_END(_param->_sum_inst_insert);
//     }

    {
      ALLOC2_INTERFACE_BEGIN("insert",IN, EAST,_("insert's interface"),_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);

      _ALLOC2_SIGNAL_IN ( in_INSERT_RENAME_UNIT_VAL                       ,"RENAME_UNIT_VAL"                       ,Tcontrol_t         ,1                             ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_OUT(out_INSERT_RENAME_UNIT_ACK                       ,"RENAME_UNIT_ACK"                       ,Tcontrol_t         ,1                             ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_IN ( in_INSERT_RENAME_UNIT_FRONT_END_ID              ,"RENAME_UNIT_FRONT_END_ID"              ,Tcontext_t         ,_param->_size_front_end_id    ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_IN ( in_INSERT_RENAME_UNIT_CONTEXT_ID                ,"RENAME_UNIT_CONTEXT_ID"                ,Tcontext_t         ,_param->_size_context_id      ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_IN ( in_INSERT_RENAME_UNIT_TYPE                      ,"RENAME_UNIT_TYPE"                      ,Ttype_t            ,_param->_size_type            ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_IN ( in_INSERT_RENAME_UNIT_OPERATION                 ,"RENAME_UNIT_OPERATION"                 ,Toperation_t       ,_param->_size_operation       ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_IN ( in_INSERT_RENAME_UNIT_NO_EXECUTE                ,"RENAME_UNIT_NO_EXECUTE"                ,Tcontrol_t         ,1                             ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_IN ( in_INSERT_RENAME_UNIT_HAS_IMMEDIAT              ,"RENAME_UNIT_HAS_IMMEDIAT"              ,Tcontrol_t         ,1                             ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_IN ( in_INSERT_RENAME_UNIT_IMMEDIAT                  ,"RENAME_UNIT_IMMEDIAT"                  ,Tgeneral_data_t    ,_param->_size_general_data    ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_IN ( in_INSERT_RENAME_UNIT_STORE_QUEUE_PTR_WRITE     ,"RENAME_UNIT_STORE_QUEUE_PTR_WRITE"     ,Tlsq_ptr_t         ,_param->_size_store_queue_ptr ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_IN ( in_INSERT_RENAME_UNIT_STORE_QUEUE_PTR_READ      ,"RENAME_UNIT_STORE_QUEUE_PTR_READ"      ,Tlsq_ptr_t         ,_param->_size_store_queue_ptr ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_IN ( in_INSERT_RENAME_UNIT_STORE_QUEUE_EMPTY         ,"RENAME_UNIT_STORE_QUEUE_EMPTY"         ,Tcontrol_t         ,1                             ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_IN ( in_INSERT_RENAME_UNIT_LOAD_QUEUE_PTR_WRITE      ,"RENAME_UNIT_LOAD_QUEUE_PTR_WRITE"      ,Tlsq_ptr_t         ,_param->_size_load_queue_ptr  ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_IN ( in_INSERT_RENAME_UNIT_READ_RA                   ,"RENAME_UNIT_READ_RA"                   ,Tcontrol_t         ,1                             ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_IN ( in_INSERT_RENAME_UNIT_NUM_REG_RA_PHY            ,"RENAME_UNIT_NUM_REG_RA_PHY"            ,Tgeneral_address_t ,_param->_size_general_register,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_IN ( in_INSERT_RENAME_UNIT_READ_RB                   ,"RENAME_UNIT_READ_RB"                   ,Tcontrol_t         ,1                             ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_IN ( in_INSERT_RENAME_UNIT_NUM_REG_RB_PHY            ,"RENAME_UNIT_NUM_REG_RB_PHY"            ,Tgeneral_address_t ,_param->_size_general_register,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_IN ( in_INSERT_RENAME_UNIT_READ_RC                   ,"RENAME_UNIT_READ_RC"                   ,Tcontrol_t         ,1                             ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_IN ( in_INSERT_RENAME_UNIT_NUM_REG_RC_PHY            ,"RENAME_UNIT_NUM_REG_RC_PHY"            ,Tspecial_address_t ,_param->_size_special_register,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_IN ( in_INSERT_RENAME_UNIT_WRITE_RD                  ,"RENAME_UNIT_WRITE_RD"                  ,Tcontrol_t         ,1                             ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_IN ( in_INSERT_RENAME_UNIT_NUM_REG_RD_PHY_OLD        ,"RENAME_UNIT_NUM_REG_RD_PHY_OLD"        ,Tgeneral_address_t ,_param->_size_general_register,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_IN ( in_INSERT_RENAME_UNIT_NUM_REG_RD_PHY_NEW        ,"RENAME_UNIT_NUM_REG_RD_PHY_NEW"        ,Tgeneral_address_t ,_param->_size_general_register,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_IN ( in_INSERT_RENAME_UNIT_WRITE_RE                  ,"RENAME_UNIT_WRITE_RE"                  ,Tcontrol_t         ,1                             ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_IN ( in_INSERT_RENAME_UNIT_NUM_REG_RE_PHY_OLD        ,"RENAME_UNIT_NUM_REG_RE_PHY_OLD"        ,Tspecial_address_t ,_param->_size_special_register,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_IN ( in_INSERT_RENAME_UNIT_NUM_REG_RE_PHY_NEW        ,"RENAME_UNIT_NUM_REG_RE_PHY_NEW"        ,Tspecial_address_t ,_param->_size_special_register,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);

      _ALLOC2_SIGNAL_OUT(out_INSERT_COMMIT_UNIT_VAL                       ,"COMMIT_UNIT_VAL"                       ,Tcontrol_t         ,1                             ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_IN ( in_INSERT_COMMIT_UNIT_ACK                       ,"COMMIT_UNIT_ACK"                       ,Tcontrol_t         ,1                             ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_OUT(out_INSERT_COMMIT_UNIT_FRONT_END_ID              ,"COMMIT_UNIT_FRONT_END_ID"              ,Tcontext_t         ,_param->_size_front_end_id    ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_OUT(out_INSERT_COMMIT_UNIT_CONTEXT_ID                ,"COMMIT_UNIT_CONTEXT_ID"                ,Tcontext_t         ,_param->_size_context_id      ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
//    _ALLOC2_SIGNAL_OUT(out_INSERT_COMMIT_UNIT_RENAME_UNIT_ID            ,"COMMIT_UNIT_RENAME_UNIT_ID"            ,Tcontext_t         ,_param->_size_rename_unit_id  ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_OUT(out_INSERT_COMMIT_UNIT_TYPE                      ,"COMMIT_UNIT_TYPE"                      ,Ttype_t            ,_param->_size_type            ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_OUT(out_INSERT_COMMIT_UNIT_OPERATION                 ,"COMMIT_UNIT_OPERATION"                 ,Toperation_t       ,_param->_size_operation       ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_OUT(out_INSERT_COMMIT_UNIT_NO_EXECUTE                ,"COMMIT_UNIT_NO_EXECUTE"                ,Tcontrol_t         ,1                             ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_OUT(out_INSERT_COMMIT_UNIT_STORE_QUEUE_PTR_WRITE     ,"COMMIT_UNIT_STORE_QUEUE_PTR_WRITE"     ,Tlsq_ptr_t         ,_param->_size_store_queue_ptr ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_OUT(out_INSERT_COMMIT_UNIT_LOAD_QUEUE_PTR_WRITE      ,"COMMIT_UNIT_LOAD_QUEUE_PTR_WRITE"      ,Tlsq_ptr_t         ,_param->_size_load_queue_ptr  ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
#ifdef DEBUG
      _ALLOC2_SIGNAL_OUT(out_INSERT_COMMIT_UNIT_READ_RA                   ,"COMMIT_UNIT_READ_RA"                   ,Tcontrol_t         ,1                             ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_OUT(out_INSERT_COMMIT_UNIT_NUM_REG_RA_PHY            ,"COMMIT_UNIT_NUM_REG_RA_PHY"            ,Tgeneral_address_t ,_param->_size_general_register,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
#endif
      _ALLOC2_SIGNAL_OUT(out_INSERT_COMMIT_UNIT_READ_RB                   ,"COMMIT_UNIT_READ_RB"                   ,Tcontrol_t         ,1                             ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
#ifdef DEBUG
      _ALLOC2_SIGNAL_OUT(out_INSERT_COMMIT_UNIT_NUM_REG_RB_PHY            ,"COMMIT_UNIT_NUM_REG_RB_PHY"            ,Tgeneral_address_t ,_param->_size_general_register,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_OUT(out_INSERT_COMMIT_UNIT_READ_RC                   ,"COMMIT_UNIT_READ_RC"                   ,Tcontrol_t         ,1                             ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_OUT(out_INSERT_COMMIT_UNIT_NUM_REG_RC_PHY            ,"COMMIT_UNIT_NUM_REG_RC_PHY"            ,Tspecial_address_t ,_param->_size_special_register,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
#endif
      _ALLOC2_SIGNAL_OUT(out_INSERT_COMMIT_UNIT_WRITE_RD                  ,"COMMIT_UNIT_WRITE_RD"                  ,Tcontrol_t         ,1                             ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_OUT(out_INSERT_COMMIT_UNIT_NUM_REG_RD_PHY_OLD        ,"COMMIT_UNIT_NUM_REG_RD_PHY_OLD"        ,Tgeneral_address_t ,_param->_size_general_register,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_OUT(out_INSERT_COMMIT_UNIT_NUM_REG_RD_PHY_NEW        ,"COMMIT_UNIT_NUM_REG_RD_PHY_NEW"        ,Tgeneral_address_t ,_param->_size_general_register,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_OUT(out_INSERT_COMMIT_UNIT_WRITE_RE                  ,"COMMIT_UNIT_WRITE_RE"                  ,Tcontrol_t         ,1                             ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_OUT(out_INSERT_COMMIT_UNIT_NUM_REG_RE_PHY_OLD        ,"COMMIT_UNIT_NUM_REG_RE_PHY_OLD"        ,Tspecial_address_t ,_param->_size_special_register,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_OUT(out_INSERT_COMMIT_UNIT_NUM_REG_RE_PHY_NEW        ,"COMMIT_UNIT_NUM_REG_RE_PHY_NEW"        ,Tspecial_address_t ,_param->_size_special_register,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);

      _ALLOC2_SIGNAL_OUT(out_INSERT_ISSUE_QUEUE_VAL                       ,"ISSUE_QUEUE_VAL"                       ,Tcontrol_t         ,1                             ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_IN ( in_INSERT_ISSUE_QUEUE_ACK                       ,"ISSUE_QUEUE_ACK"                       ,Tcontrol_t         ,1                             ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_OUT(out_INSERT_ISSUE_QUEUE_FRONT_END_ID              ,"ISSUE_QUEUE_FRONT_END_ID"              ,Tcontext_t         ,_param->_size_front_end_id    ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_OUT(out_INSERT_ISSUE_QUEUE_CONTEXT_ID                ,"ISSUE_QUEUE_CONTEXT_ID"                ,Tcontext_t         ,_param->_size_context_id      ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_OUT(out_INSERT_ISSUE_QUEUE_OPERATION                 ,"ISSUE_QUEUE_OPERATION"                 ,Toperation_t       ,_param->_size_operation       ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_OUT(out_INSERT_ISSUE_QUEUE_TYPE                      ,"ISSUE_QUEUE_TYPE"                      ,Ttype_t            ,_param->_size_type            ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_OUT(out_INSERT_ISSUE_QUEUE_STORE_QUEUE_PTR_WRITE     ,"ISSUE_QUEUE_STORE_QUEUE_PTR_WRITE"     ,Tlsq_ptr_t         ,_param->_size_store_queue_ptr ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_OUT(out_INSERT_ISSUE_QUEUE_STORE_QUEUE_PTR_READ      ,"ISSUE_QUEUE_STORE_QUEUE_PTR_READ"      ,Tlsq_ptr_t         ,_param->_size_store_queue_ptr ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_OUT(out_INSERT_ISSUE_QUEUE_STORE_QUEUE_EMPTY         ,"ISSUE_QUEUE_STORE_QUEUE_EMPTY"         ,Tcontrol_t         ,1                             ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_OUT(out_INSERT_ISSUE_QUEUE_LOAD_QUEUE_PTR_WRITE      ,"ISSUE_QUEUE_LOAD_QUEUE_PTR_WRITE"      ,Tlsq_ptr_t         ,_param->_size_load_queue_ptr  ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_OUT(out_INSERT_ISSUE_QUEUE_HAS_IMMEDIAT              ,"ISSUE_QUEUE_HAS_IMMEDIAT"              ,Tcontrol_t         ,1                             ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_OUT(out_INSERT_ISSUE_QUEUE_IMMEDIAT                  ,"ISSUE_QUEUE_IMMEDIAT"                  ,Tgeneral_data_t    ,_param->_size_general_data    ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_OUT(out_INSERT_ISSUE_QUEUE_READ_RA                   ,"ISSUE_QUEUE_READ_RA"                   ,Tcontrol_t         ,1                             ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_OUT(out_INSERT_ISSUE_QUEUE_NUM_REG_RA                ,"ISSUE_QUEUE_NUM_REG_RA"                ,Tgeneral_address_t ,_param->_size_general_register,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_OUT(out_INSERT_ISSUE_QUEUE_READ_RB                   ,"ISSUE_QUEUE_READ_RB"                   ,Tcontrol_t         ,1                             ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_OUT(out_INSERT_ISSUE_QUEUE_NUM_REG_RB                ,"ISSUE_QUEUE_NUM_REG_RB"                ,Tgeneral_address_t ,_param->_size_general_register,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_OUT(out_INSERT_ISSUE_QUEUE_READ_RC                   ,"ISSUE_QUEUE_READ_RC"                   ,Tcontrol_t         ,1                             ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_OUT(out_INSERT_ISSUE_QUEUE_NUM_REG_RC                ,"ISSUE_QUEUE_NUM_REG_RC"                ,Tspecial_address_t ,_param->_size_special_register,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_OUT(out_INSERT_ISSUE_QUEUE_WRITE_RD                  ,"ISSUE_QUEUE_WRITE_RD"                  ,Tcontrol_t         ,1                             ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_OUT(out_INSERT_ISSUE_QUEUE_NUM_REG_RD                ,"ISSUE_QUEUE_NUM_REG_RD"                ,Tgeneral_address_t ,_param->_size_general_register,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_OUT(out_INSERT_ISSUE_QUEUE_WRITE_RE                  ,"ISSUE_QUEUE_WRITE_RE"                  ,Tcontrol_t         ,1                             ,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
      _ALLOC2_SIGNAL_OUT(out_INSERT_ISSUE_QUEUE_NUM_REG_RE                ,"ISSUE_QUEUE_NUM_REG_RE"                ,Tspecial_address_t ,_param->_size_special_register,_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);

      ALLOC2_INTERFACE_END(_param->_nb_rename_unit,_param->_nb_inst_insert[it1]);
    }

//     // ~~~~~[ Interface "retire" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//     {
//       ALLOC1_INTERFACE_BEGIN("retire",OUT, WEST,_("retire's interface"),_param->_sum_inst_retire);
      
//       ALLOC1_SIGNAL_OUT (out_RETIRE_VAL                                   ,"VAL"                                   ,Tcontrol_t         ,1                             );
//       ALLOC1_SIGNAL_IN  ( in_RETIRE_ACK                                   ,"ACK"                                   ,Tcontrol_t         ,1                             );
//       ALLOC1_SIGNAL_OUT (out_RETIRE_RD_OLD_USE                            ,"RD_OLD_USE"                            ,Tcontrol_t         ,1                             );
//       ALLOC1_SIGNAL_OUT (out_RETIRE_RD_OLD_NUM_REG                        ,"RD_OLD_NUM_REG"                        ,Tgeneral_address_t ,_param->_size_general_register);
//       ALLOC1_SIGNAL_OUT (out_RETIRE_RD_NEW_USE                            ,"RD_NEW_USE"                            ,Tcontrol_t         ,1                             );
//       ALLOC1_SIGNAL_OUT (out_RETIRE_RD_NEW_NUM_REG                        ,"RD_NEW_NUM_REG"                        ,Tgeneral_address_t ,_param->_size_general_register);
//       ALLOC1_SIGNAL_OUT (out_RETIRE_RE_OLD_USE                            ,"RE_OLD_USE"                            ,Tcontrol_t         ,1                             );
//       ALLOC1_SIGNAL_OUT (out_RETIRE_RE_OLD_NUM_REG                        ,"RE_OLD_NUM_REG"                        ,Tspecial_address_t ,_param->_size_special_register);
//       ALLOC1_SIGNAL_OUT (out_RETIRE_RE_NEW_USE                            ,"RE_NEW_USE"                            ,Tcontrol_t         ,1                             );
//       ALLOC1_SIGNAL_OUT (out_RETIRE_RE_NEW_NUM_REG                        ,"RE_NEW_NUM_REG"                        ,Tspecial_address_t ,_param->_size_special_register);

//       ALLOC1_INTERFACE_END(_param->_sum_inst_retire);
//     }

//     {
//       ALLOC2_INTERFACE_BEGIN("retire",IN, EAST,_("retire's interface"),_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);

//       _ALLOC2_SIGNAL_OUT(out_RETIRE_RENAME_UNIT_VAL                       ,"RENAME_UNIT_VAL"                       ,Tcontrol_t         ,1                             ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//       _ALLOC2_SIGNAL_IN ( in_RETIRE_RENAME_UNIT_ACK                       ,"RENAME_UNIT_ACK"                       ,Tcontrol_t         ,1                             ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//       _ALLOC2_SIGNAL_OUT(out_RETIRE_RENAME_UNIT_FRONT_END_ID              ,"RENAME_UNIT_FRONT_END_ID"              ,Tcontext_t         ,_param->_size_front_end_id    ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//       _ALLOC2_SIGNAL_OUT(out_RETIRE_RENAME_UNIT_WRITE_RD                  ,"RENAME_UNIT_WRITE_RD"                  ,Tcontrol_t         ,1                             ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//       _ALLOC2_SIGNAL_OUT(out_RETIRE_RENAME_UNIT_NUM_REG_RD_PHY_OLD        ,"RENAME_UNIT_NUM_REG_RD_PHY_OLD"        ,Tgeneral_address_t ,_param->_size_general_register,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//       _ALLOC2_SIGNAL_OUT(out_RETIRE_RENAME_UNIT_NUM_REG_RD_PHY_NEW        ,"RENAME_UNIT_NUM_REG_RD_PHY_NEW"        ,Tgeneral_address_t ,_param->_size_general_register,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//       _ALLOC2_SIGNAL_OUT(out_RETIRE_RENAME_UNIT_WRITE_RE                  ,"RENAME_UNIT_WRITE_RE"                  ,Tcontrol_t         ,1                             ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//       _ALLOC2_SIGNAL_OUT(out_RETIRE_RENAME_UNIT_NUM_REG_RE_PHY_OLD        ,"RENAME_UNIT_NUM_REG_RE_PHY_OLD"        ,Tspecial_address_t ,_param->_size_special_register,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//       _ALLOC2_SIGNAL_OUT(out_RETIRE_RENAME_UNIT_NUM_REG_RE_PHY_NEW        ,"RENAME_UNIT_NUM_REG_RE_PHY_NEW"        ,Tspecial_address_t ,_param->_size_special_register,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//       _ALLOC2_SIGNAL_OUT(out_RETIRE_RENAME_UNIT_EVENT_STATE               ,"RENAME_UNIT_EVENT_STATE"               ,Tevent_state_t     ,_param->_size_event_state     ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);

//       _ALLOC2_SIGNAL_IN ( in_RETIRE_COMMIT_UNIT_VAL                       ,"COMMIT_UNIT_VAL"                       ,Tcontrol_t         ,1                             ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//       _ALLOC2_SIGNAL_OUT(out_RETIRE_COMMIT_UNIT_ACK                       ,"COMMIT_UNIT_ACK"                       ,Tcontrol_t         ,1                             ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//       _ALLOC2_SIGNAL_IN ( in_RETIRE_COMMIT_UNIT_FRONT_END_ID              ,"COMMIT_UNIT_FRONT_END_ID"              ,Tcontext_t         ,_param->_size_front_end_id    ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//       _ALLOC2_SIGNAL_IN ( in_RETIRE_COMMIT_UNIT_WRITE_RD                  ,"COMMIT_UNIT_WRITE_RD"                  ,Tcontrol_t         ,1                             ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//       _ALLOC2_SIGNAL_IN ( in_RETIRE_COMMIT_UNIT_NUM_REG_RD_PHY_OLD        ,"COMMIT_UNIT_NUM_REG_RD_PHY_OLD"        ,Tgeneral_address_t ,_param->_size_general_register,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//       _ALLOC2_SIGNAL_IN ( in_RETIRE_COMMIT_UNIT_NUM_REG_RD_PHY_NEW        ,"COMMIT_UNIT_NUM_REG_RD_PHY_NEW"        ,Tgeneral_address_t ,_param->_size_general_register,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//       _ALLOC2_SIGNAL_IN ( in_RETIRE_COMMIT_UNIT_WRITE_RE                  ,"COMMIT_UNIT_WRITE_RE"                  ,Tcontrol_t         ,1                             ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//       _ALLOC2_SIGNAL_IN ( in_RETIRE_COMMIT_UNIT_NUM_REG_RE_PHY_OLD        ,"COMMIT_UNIT_NUM_REG_RE_PHY_OLD"        ,Tspecial_address_t ,_param->_size_special_register,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//       _ALLOC2_SIGNAL_IN ( in_RETIRE_COMMIT_UNIT_NUM_REG_RE_PHY_NEW        ,"COMMIT_UNIT_NUM_REG_RE_PHY_NEW"        ,Tspecial_address_t ,_param->_size_special_register,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//       _ALLOC2_SIGNAL_IN ( in_RETIRE_COMMIT_UNIT_EVENT_STATE               ,"COMMIT_UNIT_EVENT_STATE"               ,Tevent_state_t     ,_param->_size_event_state     ,_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);

//       ALLOC2_INTERFACE_END(_param->_nb_rename_unit,_param->_nb_inst_retire[it1]);
//     }

    // ~~~~~[ Interface : "spr" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC2_INTERFACE_BEGIN("spr",IN, NORTH,_("spr's interface"),_param->_nb_front_end,_param->_nb_context[it1]);

      _ALLOC2_SIGNAL_OUT(out_SPR_SR_IEE                                   ,"SR_IEE"                                ,Tcontrol_t         ,1                             ,_param->_nb_front_end,_param->_nb_context[it1]);
      _ALLOC2_SIGNAL_OUT(out_SPR_SR_EPH                                   ,"SR_EPH"                                ,Tcontrol_t         ,1                             ,_param->_nb_front_end,_param->_nb_context[it1]);
      _ALLOC2_SIGNAL_OUT(out_SPR_RENAME_UNIT_SR                           ,"RENAME_UNIT_SR"                        ,Tspr_t             ,_param->_size_spr             ,_param->_nb_front_end,_param->_nb_context[it1]);
      _ALLOC2_SIGNAL_OUT(out_SPR_COMMIT_UNIT_SR_OVE                       ,"COMMIT_UNIT_SR_OVE"                    ,Tcontrol_t         ,1                             ,_param->_nb_front_end,_param->_nb_context[it1]);
      _ALLOC2_SIGNAL_IN ( in_SPR_SPECIAL_REGISTER_UNIT_SR                 ,"SPECIAL_REGISTER_UNIT_SR"              ,Tspr_t             ,_param->_size_spr             ,_param->_nb_front_end,_param->_nb_context[it1]);

      ALLOC2_INTERFACE_END(_param->_nb_front_end,_param->_nb_context[it1]);
    }

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

#ifdef POSITION
    if (usage_is_set(_usage,USE_POSITION))
      _component->generate_file();
#endif

    log_end(OOO_Engine_Glue,FUNCTION);
  };

}; // end namespace ooo_engine_glue
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
