/*
 * $Id: Stat_List_unit.cpp 131 2009-07-08 18:40:08Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Register_translation_unit/Stat_List_unit/include/Stat_List_unit.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace register_translation_unit {
namespace stat_list_unit {

#undef  FUNCTION
#define FUNCTION "Stat_List_unit::Stat_List_unit"
  Stat_List_unit::Stat_List_unit 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   string name,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   morpheo::behavioural::core::multi_ooo_engine::ooo_engine::rename_unit::register_translation_unit::stat_list_unit::Parameters * param,
   morpheo::behavioural::Tusage_t usage
   ):
    _name              (name)
    ,_param            (param)
    ,_usage            (usage)
  {
    log_printf(FUNC,Stat_List_unit,FUNCTION,"Begin");

// #if DEBUG_Stat_List_unit == true
//     log_printf(INFO,Stat_List_unit,FUNCTION,_("<%s> Parameters"),_name.c_str());

//     std::cout << *param << std::endl;
// #endif    

    log_printf(INFO,Stat_List_unit,FUNCTION,"Allocation");

    allocation (
#ifdef STATISTICS
		param_statistics
#endif
		);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {	
	log_printf(INFO,Stat_List_unit,FUNCTION,"Allocation of statistics");

	statistics_declaration(param_statistics);
      }
#endif

#ifdef VHDL
    if (usage_is_set(_usage,USE_VHDL))
      {
	// generate the vhdl
	log_printf(INFO,Stat_List_unit,FUNCTION,"Generate the vhdl");
	
	vhdl();
      }
#endif

#ifdef SYSTEMC
    if (usage_is_set(_usage,USE_SYSTEMC))
      {
#ifdef SYSTEMCASS_SPECIFIC
        constant();
#else
	log_printf(INFO,Stat_List_unit,FUNCTION,"Method - constant");

	SC_METHOD (constant);
// 	dont_initialize ();
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    
#endif

	log_printf(INFO,Stat_List_unit,FUNCTION,"Method - transition");

	SC_METHOD (transition);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).pos();
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    

	log_printf(INFO,Stat_List_unit,FUNCTION,"Method - genMoore");

	SC_METHOD (genMoore);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).neg(); // need internal register
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    

// 	log_printf(INFO,Stat_List_unit,FUNCTION,"Method - genMealy");

// 	SC_METHOD (genMealy);
// 	dont_initialize ();
// 	sensitive << (*(in_CLOCK)).neg(); // need internal register
// 	for (uint32_t i=0; i<_param->_nb_inst_insert; i++)
// 	  sensitive << (*(in_INSERT_READ_RA        [i]))
// 		    << (*(in_INSERT_NUM_REG_RA_PHY [i]))
// 		    << (*(in_INSERT_READ_RB        [i]))
// 		    << (*(in_INSERT_NUM_REG_RB_PHY [i]))
// 		    << (*(in_INSERT_READ_RC        [i]))
// 		    << (*(in_INSERT_NUM_REG_RC_PHY [i]));

// # ifdef SYSTEMCASS_SPECIFIC
// 	// List dependency information

// 	for (uint32_t i=0; i<_param->_nb_inst_insert; i++)
// 	  {
// 	    (*(out_INSERT_ACK [i])) (*(in_INSERT_READ_RA        [i]));
// 	    (*(out_INSERT_ACK [i])) (*(in_INSERT_NUM_REG_RA_PHY [i]));
// 	    (*(out_INSERT_ACK [i])) (*(in_INSERT_READ_RB        [i]));
// 	    (*(out_INSERT_ACK [i])) (*(in_INSERT_NUM_REG_RB_PHY [i]));
// 	    (*(out_INSERT_ACK [i])) (*(in_INSERT_READ_RC        [i]));
// 	    (*(out_INSERT_ACK [i])) (*(in_INSERT_NUM_REG_RC_PHY [i]));
// 	  }
// # endif    
	
#endif
      }
    log_printf(FUNC,Stat_List_unit,FUNCTION,"End");
  };
    
#undef  FUNCTION
#define FUNCTION "Stat_List_unit::~Stat_List_unit"
  Stat_List_unit::~Stat_List_unit (void)
  {
    log_printf(FUNC,Stat_List_unit,FUNCTION,"Begin");

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {
	log_printf(INFO,Stat_List_unit,FUNCTION,"Generate Statistics file");
	
	delete _stat;
      }
#endif

    log_printf(INFO,Stat_List_unit,FUNCTION,"Deallocation");
    deallocation ();

    log_printf(FUNC,Stat_List_unit,FUNCTION,"End");
  };

}; // end namespace stat_list_unit
}; // end namespace register_translation_unit
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
