#ifdef SYSTEMC
/*
 * $Id: RegisterFile_allocation.cpp 131 2009-07-08 18:40:08Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Generic/RegisterFile/include/RegisterFile.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace registerfile {

  void RegisterFile::allocation (
#ifdef STATISTICS
				 morpheo::behavioural::Parameters_Statistics * param_statistics
#else
				 void
#endif
				 )
  {
    std::string rename;

    log_printf(FUNC,RegisterFile,"allocation","Begin");

#ifdef SYSTEMCASS_SPECIFIC
    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      __ALLOC0_SIGNAL(in_CLOCK ,"in_CLOCK" ,SC_CLOCK          );
      __ALLOC0_SIGNAL(in_NRESET,"in_NRESET",SC_IN (Tcontrol_t));
    }
    // ~~~~~[ Interface : "read" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      __ALLOC1_INTERFACE_BEGIN("READ",_param->_nb_port_read);

      __ALLOC1_SIGNAL_IN ( in_READ_VAL    ,"VAL"    ,Tcontrol_t);
      __ALLOC1_SIGNAL_OUT(out_READ_ACK    ,"ACK"    ,Tcontrol_t);
      if (_param->_have_port_address)
      __ALLOC1_SIGNAL_IN ( in_READ_ADDRESS,"ADDRESS",Taddress_t);
      __ALLOC1_SIGNAL_OUT(out_READ_DATA   ,"DATA"   ,Tdata_t   );

      __ALLOC1_INTERFACE_END(_param->_nb_port_read);
    }

    // ~~~~~[ Interface : "write" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      __ALLOC1_INTERFACE_BEGIN("WRITE",_param->_nb_port_write);

      __ALLOC1_SIGNAL_IN ( in_WRITE_VAL    ,"VAL"    ,Tcontrol_t);
      __ALLOC1_SIGNAL_OUT(out_WRITE_ACK    ,"ACK"    ,Tcontrol_t);
      if (_param->_have_port_address)
      __ALLOC1_SIGNAL_IN ( in_WRITE_ADDRESS,"ADDRESS",Taddress_t);
      __ALLOC1_SIGNAL_IN ( in_WRITE_DATA   ,"DATA"   ,Tdata_t   );

      __ALLOC1_INTERFACE_END(_param->_nb_port_write);
    }
#endif

     // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~                                                                                                
    if (_param->_instance == instance_RegisterFile_Monolithic)
    // =====[ component_RegisterFile_Monolithic ]=========================
      {
	component_RegisterFile_Monolithic  = new morpheo::behavioural::generic::registerfile::registerfile_monolithic  ::RegisterFile_Monolithic  ::RegisterFile_Monolithic   (_name.c_str()
#ifdef STATISTICS
																					       ,param_statistics
#endif
																					       ,_param->_param_registerfile_monolithic
																					       ,_usage);
	
      }
    else
    // =====[ component_RegisterFile_Multi_Banked ]=======================
      {
	component_RegisterFile_Multi_Banked = new morpheo::behavioural::generic::registerfile::registerfile_multi_banked::RegisterFile_Multi_Banked::RegisterFile_Multi_Banked (_name.c_str()
#ifdef STATISTICS
																						,param_statistics
#endif
																						,_param->_param_registerfile_multi_banked
																						,_usage);
	
      }
    // ~~~~~[ Component - Instanciation ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    if (_param->_instance == instance_RegisterFile_Monolithic)
    // =====[ Component_RegisterFile_Monolithic - Instanciation ]=========
      {
#ifdef SYSTEMCASS_SPECIFIC
        (*(component_RegisterFile_Monolithic  ->in_CLOCK )) (*(in_CLOCK ));
	(*(component_RegisterFile_Monolithic  ->in_NRESET)) (*(in_NRESET));
	
	for (uint32_t i=0; i<_param->_nb_port_read; i++)
	  { 
	    (*(component_RegisterFile_Monolithic  -> in_READ_VAL     [i])) (*( in_READ_VAL     [i]));   
	    (*(component_RegisterFile_Monolithic  ->out_READ_ACK     [i])) (*(out_READ_ACK     [i]));
	    if (_param->_have_port_address == true)
	    (*(component_RegisterFile_Monolithic  -> in_READ_ADDRESS [i])) (*( in_READ_ADDRESS [i]));
	    (*(component_RegisterFile_Monolithic  ->out_READ_DATA    [i])) (*(out_READ_DATA    [i]));
	  }
	
	for (uint32_t i=0; i<_param->_nb_port_write; i++)
	  {
	    (*(component_RegisterFile_Monolithic  -> in_WRITE_VAL     [i])) (*( in_WRITE_VAL     [i]));
	    (*(component_RegisterFile_Monolithic  ->out_WRITE_ACK     [i])) (*(out_WRITE_ACK     [i]));
	    if (_param->_have_port_address == true)
	    (*(component_RegisterFile_Monolithic  -> in_WRITE_ADDRESS [i])) (*( in_WRITE_ADDRESS [i]));
	    (*(component_RegisterFile_Monolithic  -> in_WRITE_DATA    [i])) (*( in_WRITE_DATA    [i]));
	  }
#else
	 in_CLOCK         = component_RegisterFile_Monolithic-> in_CLOCK        ;
	 in_NRESET        = component_RegisterFile_Monolithic-> in_NRESET       ;

         in_READ_VAL      = component_RegisterFile_Monolithic-> in_READ_VAL     ;   
        out_READ_ACK      = component_RegisterFile_Monolithic->out_READ_ACK     ;
         in_READ_ADDRESS  = component_RegisterFile_Monolithic-> in_READ_ADDRESS ;
        out_READ_DATA     = component_RegisterFile_Monolithic->out_READ_DATA    ;

         in_WRITE_VAL     = component_RegisterFile_Monolithic-> in_WRITE_VAL    ;
        out_WRITE_ACK     = component_RegisterFile_Monolithic->out_WRITE_ACK    ;
         in_WRITE_ADDRESS = component_RegisterFile_Monolithic-> in_WRITE_ADDRESS;
         in_WRITE_DATA    = component_RegisterFile_Monolithic-> in_WRITE_DATA   ;
#endif
      }
    else
    // =====[ Component_RegisterFile_Multi_Banked - Instanciation ]=======
      {
#ifdef SYSTEMCASS_SPECIFIC
	(*(component_RegisterFile_Multi_Banked->in_CLOCK )) (*(in_CLOCK ));
	(*(component_RegisterFile_Multi_Banked->in_NRESET)) (*(in_NRESET));
	
	for (uint32_t i=0; i<_param->_nb_port_read; i++)
	  { 
	    (*(component_RegisterFile_Multi_Banked-> in_READ_VAL     [i])) (*( in_READ_VAL     [i]));   
	    (*(component_RegisterFile_Multi_Banked->out_READ_ACK     [i])) (*(out_READ_ACK     [i]));
	    if (_param->_have_port_address == true)
	    (*(component_RegisterFile_Multi_Banked-> in_READ_ADDRESS [i])) (*( in_READ_ADDRESS [i]));
	    (*(component_RegisterFile_Multi_Banked->out_READ_DATA    [i])) (*(out_READ_DATA    [i]));
	  }
	
	for (uint32_t i=0; i<_param->_nb_port_write; i++)
	  {
	    (*(component_RegisterFile_Multi_Banked-> in_WRITE_VAL     [i])) (*( in_WRITE_VAL     [i]));
	    (*(component_RegisterFile_Multi_Banked->out_WRITE_ACK     [i])) (*(out_WRITE_ACK     [i]));
	    if (_param->_have_port_address == true)
	    (*(component_RegisterFile_Multi_Banked-> in_WRITE_ADDRESS [i])) (*( in_WRITE_ADDRESS [i]));
	    (*(component_RegisterFile_Multi_Banked-> in_WRITE_DATA    [i])) (*( in_WRITE_DATA    [i]));
	  }
#else
	 in_CLOCK         = component_RegisterFile_Multi_Banked-> in_CLOCK        ;
	 in_NRESET        = component_RegisterFile_Multi_Banked-> in_NRESET       ;
	
         in_READ_VAL      = component_RegisterFile_Multi_Banked-> in_READ_VAL     ;   
        out_READ_ACK      = component_RegisterFile_Multi_Banked->out_READ_ACK     ;
         in_READ_ADDRESS  = component_RegisterFile_Multi_Banked-> in_READ_ADDRESS ;
        out_READ_DATA     = component_RegisterFile_Multi_Banked->out_READ_DATA    ;
        
         in_WRITE_VAL     = component_RegisterFile_Multi_Banked-> in_WRITE_VAL    ;
        out_WRITE_ACK     = component_RegisterFile_Multi_Banked->out_WRITE_ACK    ;
         in_WRITE_ADDRESS = component_RegisterFile_Multi_Banked-> in_WRITE_ADDRESS;
         in_WRITE_DATA    = component_RegisterFile_Multi_Banked-> in_WRITE_DATA   ;
#endif

      }

    if (_param->_instance == instance_RegisterFile_Monolithic)
      _component = component_RegisterFile_Monolithic  ->_component;
    else
      _component = component_RegisterFile_Multi_Banked->_component;

    log_printf(FUNC,RegisterFile,"allocation","End");
  };

}; // end namespace registerfile
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
